unit XMS;
INTERFACE
uses Crt,Dos;

const ERR_NOERR          = $00;         {kein Fehler}
      ERR_NOTIMPLEMENTED = $80;         {angegebenen Fkt nicht bekannt}
      ERR_VDISKFOUND     = $81;
      ERR_A20            = $82;
      ERR_GENERAL        = $8E;
      ERR_UNRECOVERABLE  = $8F;
      ERR_HMANOTEXIST    = $90;
      ERR_HMAINUSE       = $91;
      ERR_HMAMINSIZE     = $92;
      ERR_HMANOTALLOCED  = $93;
      ERR_A20STILLON     = $94;
      ERR_OUTOFMEMORY    = $A0;
      ERR_OUTOFHANDLES   = $A1;
      ERR_INVALIDHANDLE  = $A2;
      ERR_SHINVALID      = $A3;
      ERR_SOINVALID      = $A4;
      ERR_DHINVALID      = $A5;
      ERR_DOINVALID      = $A6;
      ERR_LENINVALID     = $A7;
      ERR_OVERLAP        = $A8;
      ERR_PARITY         = $A9;
      ERR_EMBUNLOCKED    = $AA;
      ERR_EMBLOCKED      = $AB;
      ERR_LOCKOVERFLOW   = $AC;
      ERR_LOCKFAIL       = $AD;
      ERR_UMBSIZETOOBIG  = $B0;
      ERR_NOUMBS         = $B1;
      ERR_INVALIDUMB     = $B2;

TYPE XMSRegs = record
               ax,
               bx,
               dx,
               si,
               segment: word;
               end;

var XMSPtr : pointer;
    XMSErr : Byte;

function XMSQueryVer(var VerNr, RevNr : word): Boolean;
function XMSGetHMA(lenB : word): Boolean;
function XMSIsA20On: Boolean;
function XMSGetMem(LenKB : word) : word;
function XMSLock(Handle: word): longint;
function XMSRealloc(Handle, NeuLenKB: word): Boolean;
function XMSGetUMB(LenPara: word; var Seg,MaxPara : word): Boolean;

procedure XMSReleaseHMA;
procedure XMS20OnGlobal;
procedure XMS20OffGlobal;
procedure XMS20OnLocal;
procedure XMS20OffLocal;
procedure XMSQueryFree(var GesFrei, MaxB1 : word);
procedure XMSFreeMem(Handle: word);
procedure XMSCopy(VonHandle : word; VonOffset : longint;
                  NachHandle: word; NachOffset: longint;
                  LenW : longint);
procedure XMSUnLock(Handle: word);
procedure XMSQueryInfo(Handle: word; var Lock, LenKB: word;
                      var FreeH: word);
procedure XMSFreeUMB(var Seg : word);

IMPLEMENTATION

{***************************************************************************}
{*                                                                         *}
{***************************************************************************}
function XMSInit : Boolean;
var regs : registers;
    xr   : XMSRegs;
begin
regs.ax := $4300;
intr($2F,regs);
if regs.al = $80 then begin
  regs.ax := $4310;
  intr($2F,regs);
  XMSPtr := ptr(regs.es,regs.bx);
  XMSErr := ERR_NOERR;
  XMSInit := True;
  end
else
  XMSInit := False;
end;

{***************************************************************************}
{*                                                                         *}
{***************************************************************************}
procedure XMSCall(Fktnr: Byte; var XRegs : XMSRegs);
begin
{inline( $8C / $D9 /
        $51 /
        $C5 / $BE / $04 / $00 /
        $8A / $66 / $08 /
        $8B / $9D / $02 / $00 /
        $8B / $95 / $04 / $00 /
        $8B / $B5 / $06 / $00 /
        $8E / $5D / $08 /
        $8E / $C1 /
        $26 / $FF / $1E / XMSPtr /
        $8C / $D9 /
        $C5 / $7E / $04 /
        $89 / $05 /
        $89 / $5D / $02 /
        $89 / $55 / $04 /
        $89 / $75 / $06 /
        $89 / $4D / $08 /
        $1F
      );
}
asm
  mov  cx,ds
  push cx
  lds  di,[bp+0004]
  mov  ah,[bp+0008]
  mov  bx,[di+0002]
  mov  dx,[di+0004]
  mov  si,[di+0006]
  mov  ds,[di+0008]
  mov  es,cx
  call es:[XMSPtr]
  mov  cx,ds
  lds  di,[bp+0004]
  mov  [di],ax
  mov  [di+0002],bx
  mov  [di+0004],dx
  mov  [di+0006],si
  mov  [di+0008],cx
  pop  ds
end;
if (XRegs.ax = 0) and (XRegs.Bx >= 128) then
  XMSErr := Lo(XRegs.Bx)
else
  XMSErr := ERR_NOERR;
end;

{***************************************************************************}
{*                                                                         *}
{***************************************************************************}
function XMSQueryVer(var VerNr, RevNr : word): Boolean;
var xr : XMSRegs;
begin
XMSCall(0,xr);
VerNr := Hi(xr.ax)*100 + (Lo(xr.ax) shr 4) * 10 + (Lo(xr.ax) and 15);
RevNr := Hi(xr.bx)*100 + (Lo(xr.bx) shr 4) * 10 + (Lo(xr.bx) and 15);
XMSQueryVer := (xr.dx = 1);
end;

{***************************************************************************}
{*                                                                         *}
{***************************************************************************}
function XMSGetHMA(lenB : word): Boolean;
var xr : XMSRegs;
begin
xr.dx := LenB;
XmsCall(1,xr);
XMSGetHMA := (XMSErr = ERR_NOERR);
end;

{***************************************************************************}
{*                                                                         *}
{***************************************************************************}
procedure XMSReleaseHMA;
var xr : XMSRegs;
begin
XmsCall(2,xr);
end;

procedure XMS20OnGlobal;
var xr : XMSRegs;
begin
XmsCall(3,xr);
end;

procedure XMS20OffGlobal;
var xr : XMSRegs;
begin
XmsCall(4,xr);
end;

procedure XMS20OnLocal;
var xr : XMSRegs;
begin
XmsCall(5,xr);
end;

procedure XMS20OffLocal;
var xr : XMSRegs;
begin
XmsCall(6,xr);
end;

function XMSIsA20On: Boolean;
var xr : XMSRegs;
begin
XmsCall(7,xr);
XMSIsA20On := (xr.ax = 1);
end;

procedure XMSQueryFree(var GesFrei, MaxB1 : word);
var xr : XMSRegs;
begin
XmsCall(8,xr);
GesFrei := xr.ax;
MaxB1 := xr.dx;
end;

function XMSGetMem(LenKB : word) : word;
var xr : XMSRegs;
begin
xr.dx := LenKB;
XmsCall(9,xr);
XMSGetMem := xr.dx;
end;

procedure XMSFreeMem(Handle: word);
var xr : XMSRegs;
begin
xr.dx := Handle;
XmsCall(10,xr);
end;

procedure XMSCopy(VonHandle : word; VonOffset : longint;
                  NachHandle: word; NachOffset: longint;
                  LenW : longint);
type EMMS = record
            LenB   : longint;
            SHandle: word;
            SOffset: longint;
            DHandle: word;
            DOffset: longint;
            end;
var xr : XMSRegs;
    mi : EMMS;
begin
with mi do begin
  LenB := 2 * LenW;
  SHandle := VonHandle;
  SOffset := VonOffset;
  DHandle := NachHandle;
  DOffset := NachOffset;
  end;
xr.si := Ofs(mi);
xr.segment := Seg(mi);
XmsCall(11,xr);
end;

function XMSLock(Handle: word): longint;
var xr : XMSRegs;
begin
xr.dx := Handle;
XmsCall(12,xr);
XMSLock := longint(xr.dx) shl 16 + xr.bx;
end;

procedure XMSUnLock(Handle: word);
var xr : XMSRegs;
begin
xr.dx := Handle;
XmsCall(13,xr);
end;

procedure XMSQueryInfo(Handle: word; var Lock, LenKB: word;
                      var FreeH: word);
var xr : XMSRegs;
begin
xr.dx := Handle;
XmsCall(14,xr);
Lock := Hi(xr.bx);
FreeH := Lo(xr.bx);
LenKB :=xr.dx;
end;

function XMSRealloc(Handle, NeuLenKB: word): Boolean;
var xr : XMSRegs;
begin
xr.dx := Handle;
xr.bx := NeuLenKB;
XmsCall(15,xr);
XMSRealloc := (XMSErr = ERR_NOERR);
end;

function XMSGetUMB(LenPara: word; var Seg,MaxPara : word): Boolean;
var xr : XMSRegs;
begin
xr.dx := LenPara;
XmsCall(16,xr);
Seg := xr.bx;
MaxPara := xr.dx;
XMSGetUMB := (XMSErr = ERR_NOERR);
end;

procedure XMSFreeUMB(var Seg : word);
var xr : XMSRegs;
begin
xr.dx := Seg;
XmsCall(17,xr);
end;

procedure EMBTest;
type XBar = array[1..1024] of Byte;
     BarPtr = ^XBar;
var ch : char;
    Adr : longint;
    barp: BarPtr;
    i,j, err,
    Handle,
    GesFrei, MaxBl: word;

begin
XmsQueryFree(GesFrei,MaxBl);
writeLn('Frei: ',GesFrei,'  davon im Block: ',MaxBl);
GesFrei := GesFrei - 64;
if MaxBl > GesFrei then
  MaxBl := MaxBl - 64;
if MaxBl <> 0 then begin
  Handle := XmsGetMem(MaxBl);
  writeLn(MaxBl,' KB allokiert');
  writeLn('Handle: ',Handle);
  Adr := XmsLock(Handle);
  XmsUnlock(Handle);
  writeLn('Startadresse: ',Adr,'(',Adr div 1024, 'KB');
  getMem(barp,1024);
  err := 0;
  for i := 1 to MaxBl-1 do begin
    write(#13, 'KB-Test: ',i+1);
    Fillchar(barp^,1024, i mod 255);
    XmsCopy(0,longint(barp),Handle,longint(i)*1024,512);
    FillChar(barp^,1024,255);
    XmsCopy(Handle,longint(i)*1024,0,longint(barp),512);
    j := 1;
    while (j < 1024) do
      if barp^[j] <> i mod 255 then begin
        writeln('Fehler');
        inc(err);
        j := 1025;
        end
      else
        inc(j);
      end;
  FreeMem(barp,1024);
  XmsFreeMem(Handle);
  end;
end;

{***************************************************************************}
var VerNr, RevNr,Frei,maxB,FreiB : word;
begin
Clrscr;
writeln('XMS - Installation');
if XMSInit then begin
  if XMSQueryVer(VerNr,RevNr) then
    writeln('Zugriff auf HMA mglich')
  else
    writeln('Kein Zugriff auf HMA');
  writeln('XMS - Versionsnummer: ',VerNr div 100,'.',VerNr mod 100);
  writeln('Revisionsnummer: ',RevNr div 100,'.',RevNr mod 100);
  XMSQueryFree(Frei,maxB);
  writeln('Gesamt(incl.HMA): ',Frei,'   grter Block: ',maxB);
  writeln('Gesamt(ohne HMA): ',Frei-64,'   grter Block: ',maxB-64);
{  XMSQueryInfo(0,Frei,maxB,FreiB);
  Writeln('Freie Handles: ',FreiB);}
  writeln;
{  EMBTest;}
  end
else
  Writeln('Kein XMS-Treiber installiert');
end.