unit mymouse;
{
                 Da die Routinen dieser Unit relativ klein sind und unter
                 Umstnden sehr oft aufgerufen werden, wird von der Ver-
                 wendung der Unit als Overlay abgeraten.
}
{-----------------------------------------------------------------------------}
INTERFACE
uses crt,dos,ifs_def,ifs_win,graph;

(* Mouse-Definitionen und Konstante                                   *)
TYPE  Mouse_Type = RECORD
                     Screen,
                     Mask    : ARRAY[0..15] OF WORD;
                   END;

  TextCursorTyp  = RECORD
		     CASE Typ : WORD OF
		       0 : (Screen,
			    Cursor    : WORD);
		       1 : (ScanStart,
			    ScanStop  : WORD);
		   END;

  GraphCursorTyp = RECORD
		     Mask  : ARRAY[0..1,0..15] of WORD;
		     XSpot,
		     YSpot : WORD;
		   END;

CONST MaxGrCursor = 8;
      MaxSWCursor = 7;
      MaxHWCursor = 105;               { Anzahl der definierten Cursor + 100 }

VAR MouseOK,                           { Mouse vorhanden                     }
    MouseOn,                           { momentaner Mausstatus (aktiv/inaktiv}
    MouseState : BOOLEAN;              { Sicherungsvariable fr              }
                                       { SaveMouseState und RestoreMouseState}
    mx,my,mx0,my0 : integer;

PROCEDURE ResetMouse;
PROCEDURE GetMouseButtonPressed (VAR Status, No, x, y : WORD);
PROCEDURE GetMouseButtonRelease (VAR Status, No, x, y : WORD);
PROCEDURE ReadMouseMotion (VAR Xcounter, Ycounter : Integer);
PROCEDURE SetMouseSubRoutine (CallMask : WORD; UserRtn : POINTER);
PROCEDURE ResetMouseSubRoutine;
PROCEDURE SetMouseMickeys (hor, ver : WORD);
PROCEDURE SetMouseDoubleSpeed (mickeys : WORD);
PROCEDURE SwapMouseSubRoutine (VAR CallMask : WORD; VAR UserRtn : POINTER);
PROCEDURE AllocMouseBuffer (VAR Buffer : POINTER);
PROCEDURE DeAllocMouseBuffer (VAR Buffer : POINTER);
PROCEDURE SaveMouseDriverState (Buffer : POINTER);
PROCEDURE RestoreMouseDriverState (Buffer : POINTER);
PROCEDURE SetMouseCrtPage (Nr : WORD);
PROCEDURE GetMouseCrtPage (VAR Nr : WORD);
PROCEDURE WaitMouse;
PROCEDURE Entprellen;
procedure getvideomodes;

FUNCTION ButtonPressed : BOOLEAN;
FUNCTION WhichButton : INTEGER;
function rightbutton:boolean;
function leftbutton:boolean;
function middlebutton:boolean;

procedure define_cursor;
procedure Exit_mymouse;
procedure Mouse_bewegen;
procedure MouseHer;
procedure MouseWeg;
procedure SetMouseBereich(x1,y1,x2,y2:word);

function Mouse_in_Menue:Boolean;
function Mouse_in_NumWin:Boolean;
function Mouse_in_Buttons:Boolean;
function Mouse_im_Bild:Boolean;
function Mouse_auf_Pfeil : Byte;

{-----------------------------------------------------------------------------}
IMPLEMENTATION
const cs_pfeil : Array[1..7] of PointType =
               ((x: 500; y: 290),
                (x: 515; y: 295),
                (x: 506; y: 296),
                (x: 515; y: 304),
                (x: 514; y: 305),
                (x: 506; y: 296),
                (x: 505; y: 305));

  MouseHGCInit	 : BOOLEAN = FALSE;
  MouseUserSet	 : BOOLEAN = FALSE;
  MouseUserIntr  = $78;                          { MUSS mit der Konstanten in }
                                                 { MOUSEUI.ASM bereinstimmen !! }

VAR MouseR	   : Registers;
    MouseHGCSave   : BYTE;
    MouseExitSave  : POINTER;
    MouseExitSave2 : POINTER;
    MousePtr	   : POINTER;
    MouseBufferPtr : POINTER;
    MouseSaveUser  : POINTER;

var cursors, nocursor : Pointer;
    cursor : Array[0..15] of Pointer;
    cursorsize,
    minmouse_x,minmouse_y,
    maxmouse_x,maxmouse_y : word;
    dx,dy : integer;

{-----------------------------------------------------------------------------}
FUNCTION MouseInstalled : BOOLEAN;
{*
Zweck...............: INTR 33; Function 0: Mouse Reset and Status
Used by.............: MAIN
}
CONST IRET = $CF;
VAR
  Int33Ptr    : POINTER;
  Int33OfsSeg : LongInt absolute Int33Ptr;

BEGIN
  GetIntVec ($33,Int33Ptr);
  IF (BYTE (Int33Ptr^) = IRET) OR (Int33OfsSeg = 0) THEN
     MouseInstalled := FALSE
  ELSE BEGIN
     MouseR.ax := 0;
     Intr ($33,MouseR);
     MouseInstalled := (MouseR.ax=$FFFF);
  END;
END;
{-----------------------------------------------------------------------------}
PROCEDURE ResetMouse;
{*
Zweck...............: INTR 33; Function 0: Mouse Reset
Bemerkung...........: Bringt Mousetreiber in Grundstellung (Hide Mouse)
                      Grafikmodus    : Cursorpfeil
                      Textmodus      : Softwarecursor
                      Mickeys        : 8 hor., 8 ver.
                      Bildschirmseite: 0
                      Callmask       : 0
}
BEGIN
  IF MouseOK THEN BEGIN
     MouseR.ax := 0;
     Intr ($33,MouseR);
  END;
  IF MouseUserSet THEN SetIntVec (MouseUserIntr,MouseSaveUser);
END;
{-----------------------------------------------------------------------------}
PROCEDURE GetMouseButtonPressed (VAR Status, No, x, y : WORD);
{*
Zweck...............: INTR 33; Function 5: Get Button Press Information
Eingangsparameter...: Status: zu prfende Maustaste
                      0 links, 1 rechts
Ausgangsparameter...: Status (wie oben)
                      No     Anzahl wie oft Taste gedrckt
                      x,y    Position beim letzten Tastendruck
Uses................: TextModus
}
BEGIN
  IF MouseOK THEN BEGIN
     MouseR.ax := 5;
     MouseR.bx := Status;                        { zu prfende Maustaste  }
     Intr ($33,MouseR);
     Status := MouseR.ax;                        { aktueller Button Status }
     No := MouseR.bx;                            { Anzahl wie oft Taste gedrckt }
			                         { seit letzten Aufruf	    }
     x := MouseR.cx;                             { Cursorposition bei letzten   }
     y := MouseR.dx;                             { Druck auf geprfte Maustaste }
  END
     ELSE BEGIN
     Status := 0;
     No := 0;
     x := 0;
     y := 0;
  END;
END;
{-----------------------------------------------------------------------------}
PROCEDURE GetMouseButtonRelease (VAR Status, No, x, y : WORD);
{*
Zweck...............: INTR 33; Function 6: Get Button Release Information
Eingangsparameter...: Status: zu prfende Maustaste
                      0 links, 1 rechts
Ausgangsparameter...: Status (wie oben)
                      No     Anzahl wie oft Taste losgelassen
                      x,y    Position beim letzten Tastendruck
Uses................: TextModus
}
BEGIN
  IF MouseOK THEN BEGIN
     MouseR.ax := 6;
     MouseR.bx := Status;                        { zu prfende Maustaste  }
     Intr ($33,MouseR);
     Status := MouseR.ax;                        { aktueller Button Status }
     No := MouseR.bx;                            { Anzahl wie oft Taste losge- }
			                         { lassen seit letzten Aufruf  }
     x := MouseR.cx;                             { Cursorposition bei letzten   }
     y := MouseR.dx;                             { Druck auf geprfte Maustaste }
  END
  ELSE BEGIN
     Status := 0;
     No := 0;
     x := 0;
     y := 0;
  END;
END;
{-----------------------------------------------------------------------------}
FUNCTION ButtonPressed : BOOLEAN;
{*
Zweck...............: Analog KeyPressed; Liefert TRUE wenn Button gedrckt
}
BEGIN
  IF MouseOk THEN BEGIN
     MouseR.AX := 3;
     Intr ($33,MouseR);
     ButtonPressed := ((MouseR.BX AND 7) <> 0);
  END
  ELSE ButtonPressed := FALSE;
END;
{-----------------------------------------------------------------------------}
FUNCTION WhichButton : INTEGER;
{*
Zweck...............: Die Funktionsversion von GetMousePos beschrnkt auf
                      die gedrckten Buttons
}
BEGIN
  IF MouseOk THEN BEGIN
     MouseR.AX := 3;
     Intr ($33,MouseR);
     WhichButton := MouseR.BX;
  END
  ELSE WhichButton := 0;
END;
{-----------------------------------------------------------------------------}
PROCEDURE WaitMouse;
{*
Zweck...............: Wartet (unterbricht Programmablauf !!!) bis die Maus
                      bewegt wird oder eine Taste gedrckt wird.
Uses................: ReadMouseMotion
}
VAR dx,dy : INTEGER;
BEGIN
  IF MouseOk THEN BEGIN
     REPEAT
        ReadMouseMotion (dx,dy);
     UNTIL (dx <> 0) OR (dy <> 0) OR ButtonPressed;
  END;
END;
{-----------------------------------------------------------------------------}
PROCEDURE ReadMouseMotion (VAR Xcounter, Ycounter : Integer);
{*
Zweck...............: INTR 33; Function 11: Read Mouse Motion Counters
Ausgangsparameter...: Xcounter, Ycounter : Angabe in Mickeys (0,127mm)
}
BEGIN
  IF MouseOK THEN BEGIN
     MouseR.ax := 11;
     Intr ($33,MouseR);
     Xcounter := Integer (MouseR.cx);
     Ycounter := Integer (MouseR.dx);
  END
  ELSE BEGIN
     XCounter := 0;
     YCounter := 0;
  END;
END;
{-----------------------------------------------------------------------------}
{$IFNDEF V2 }
PROCEDURE UserInterrupt; external;
{*
Zweck...............: Verbiegt Interrupt zum Zwecke eigener
                      Interruptroutinen
Used by.............: SetMouseSubRoutine
Bemerkung...........: Bentigt zur Compilation PR_MOUSE.OBJ
}
{$L MOUSE.OBJ }

{$ELSE }

{$F+}
PROCEDURE UserInterrupt;
{*
Zweck...............: Verbiegt Interrupt zum Zwecke eigener
                      Interruptroutinen
Used by.............: SetMouseSubRoutine
}
BEGIN
  Inline ($CD/MouseUserIntr);
END;
{$F-}

{$ENDIF }
{-----------------------------------------------------------------------------}
PROCEDURE SetMouseSubRoutine (CallMask: WORD; UserRtn : POINTER);
{*
Zweck...............: INTR 33; Function 12: SetInterrupt SubRoutine
                                        Call Mask and Address
Eingangsparameter...: CallMask : 0 Cursorposition verndern
                                 1 linke Taste drcken
                                 2 linke Taste loslassen
                                 3 rechte Taste drcken
                                 4 rechte Taste loslassen
                      UserRtn  : Prozedurname (siehe iwt Seite 72)
Bemerkung...........: Der Maustreiber soll entsprechend der Callmask
                      eine Benutzerroutine aufrufen:
                      Diese Prozedur installiert eine Routine, die vom
                      Maustreiber immer dann aufgerufen wird, wenn die
                      in der CallMask definierten Bedingungen eintreten.
}
BEGIN
  IF MouseOK THEN BEGIN
     MouseR.ax := 12;
     MouseR.cx := CallMask;
     MouseR.es := Seg (UserInterrupt);
     MouseR.dx := Ofs (UserInterrupt);
     GetIntVec (MouseUserIntr,MouseSaveUser);
     SetIntVec (MouseUserIntr,UserRtn);
     Intr ($33,MouseR);
     MouseUserSet := TRUE;
  END;
END;
{-----------------------------------------------------------------------------}
{$F+}
PROCEDURE ResetMouseSubRoutine;
{*
Zweck...............: Maustreiber soll eine Benutzerroutine nicht mehr
                      ausfhren.
}
CONST CallMask = 0;
BEGIN
  IF MouseOK THEN BEGIN
     SetIntVec (MouseUserIntr,MouseSaveUser);
     MouseR.ax := 12;
     MouseR.cx := CallMask;
     MouseR.es := 0;
     MouseR.dx := 0;
     Intr ($33,MouseR);
     MouseUserSet := FALSE;
  END;
END;
{$F-}
{-----------------------------------------------------------------------------}
PROCEDURE SetMouseMickeys (hor, ver : WORD);
{*
Zweck...............: INTR 33; Function 15: Set Mickey/Pixel Ratio
Eingangsparameter...: hor, ver : Mickey je Pixel (Standard 8,16)
Bemerkung...........: 1 Mickey = 1/200 Zoll = 0,127mm
                      je grer die Werte desto langasmer wird die Maus =
                      Sie mu eine grere Strecke zurcklegen!
}
BEGIN
  IF MouseOK THEN BEGIN
     MouseR.ax := 15;
     MouseR.cx := hor;                           { horizontal }
     MouseR.dx := ver;                           { vertical   }
     Intr ($33,MouseR);
  END;
END;
{-----------------------------------------------------------------------------}
PROCEDURE SetMouseDoubleSpeed (mickeys : WORD);
{*
Zweck...............: INTR 33; Function 19: Set Double-Speed Threshold
Eingangsparameter...: mickeys : mickeys je Sekunde (Standard 64)
Bemerkung...........: Wenn der in Mickeys je Sekunde angegebene Grenzwert
                      berschritten wird, verdoppelt sich die
                      Geschwindigkeit des Mauszeigers am Bildschirm.
}
BEGIN
  IF MouseOK THEN BEGIN
     MouseR.ax := 19;
     MouseR.dx := mickeys;                      { Schwelle in mickeys/Sekunde }
     Intr ($33,MouseR);
  END;
END;
{-----------------------------------------------------------------------------}
PROCEDURE SwapMouseSubRoutine (VAR CallMask : WORD; VAR UserRtn : POINTER);
{*
Zweck...............: INTR 33; Function 20: Swap Interrupt Subroutines
Eingangsparameter...: CallMask , UserRtn wie bei SetMouseSubroutine
Bemerkung...........: Setzt eine neue Interruptroutine, die bei passender
                      CallMask ausgefhrt wird.
}
VAR Save : POINTER;
BEGIN
  IF MouseOK THEN BEGIN
     MouseR.ax := 20;
     MouseR.cx := CallMask;
     MouseR.es := Seg (UserInterrupt);
     MouseR.dx := Ofs (UserInterrupt);
     Intr ($33,MouseR);
     GetIntVec (MouseUserIntr,Save);
     SetIntVec (MouseUserIntr,UserRtn);
     UserRtn := Save;
     CallMask := MouseR.cx;
  END
  ELSE BEGIN
     CallMask := 0;
     UserRtn := nil;
  END;
END;
{-----------------------------------------------------------------------------}
PROCEDURE AllocMouseBuffer (VAR Buffer : POINTER);
{*
Zweck...............: INTR 33; Function 21: Get Mouse Driver State and
                                        Storage Requirements
Eingangsparameter...: Buffer : Speicherbereich
Bemerkung...........: Allokiert freien Speicher um spter Mauszustand
                      vor einem Wechsel zwischenzuspeichern.
                      Nach Verwendung mit DISPOSE(Buffer) freigeben!
}
VAR B : POINTER;
BEGIN
  IF MouseOK THEN BEGIN
     MouseR.ax := 21;
     Intr ($33, MouseR);
     GetMem (B, MouseR.bx);
     Buffer := B;
  END
  ELSE Buffer := NIL;
END;
{-----------------------------------------------------------------------------}
PROCEDURE DeAllocMouseBuffer (VAR Buffer : POINTER);
{*
Zweck...............: INTR 33; Function 21: Get Mouse Driver State and
                                        Storage Requirements
Eingangsparameter...: Buffer : Speicherbereich
Bemerkung...........: Allokiert freien Speicher um spter Mauszustand
                      vor einem Wechsel zwischenzuspeichern.
                      Nach Verwendung mit DISPOSE(Buffer) freigeben!
}
BEGIN
  IF MouseOK THEN BEGIN
     MouseR.ax := 21;
     Intr ($33, MouseR);
     FreeMem (Buffer, MouseR.bx);
  END;
END;
{-----------------------------------------------------------------------------}
PROCEDURE SaveMouseDriverState (Buffer : POINTER);
{*
Zweck...............: INTR 33; Function 22: Save Mouse Driver State
Eingangsparameter...: Buffer : Speicherbereich
Bemerkung...........: Sichert Maustreiber: Position und Aussehen
                      Nicht aber Mouswindow!!
}
BEGIN
  IF MouseOK THEN BEGIN
     MouseR.ax := 22;
     MouseR.es := Seg (Buffer^);
     MouseR.dx := Ofs (Buffer^);
     Intr ($33,MouseR);
  END;
END;
{-----------------------------------------------------------------------------}
PROCEDURE RestoreMouseDriverState (Buffer : POINTER);
{*
Zweck...............: INTR 33; Function 23: Restore Mouse Driver State
Eingangsparameter...: Buffer : Speicherbereich
Bemerkung...........: Restauriert Maustreiber: Position und Aussehen
                      Nicht aber Mouswindow!!
}
BEGIN
  IF MouseOK THEN BEGIN
     MouseR.ax := 23;
     MouseR.es := Seg (Buffer^);
     MouseR.dx := Ofs (Buffer^);
     Intr ($33, MouseR);
  END;
END;
{-----------------------------------------------------------------------------}
PROCEDURE SetMouseCRTPage (Nr : WORD);
{*
Zweck...............: INTR 33; Function 29: Set CRT Page Number
Eingangsparameter...: Nr : Nummer der Bildschirmseite
}
BEGIN
  IF MouseOK THEN BEGIN
     MouseR.ax := 29;
     MouseR.bx := Nr;
     Intr ($33, MouseR);
  END;
END;
{-----------------------------------------------------------------------------}
PROCEDURE GetMouseCRTPage (VAR Nr : WORD);
{*
Zweck...............: INTR 33; Function 30: Get CRT Page Number
Ausgangsparameter...: Nr : Nummer der Bildschirmseite
}
BEGIN
  IF MouseOK THEN BEGIN
     MouseR.ax := 30;
     Intr ($33, MouseR);
     Nr := MouseR.bx;
  END
  ELSE Nr := 0;
END;
{-----------------------------------------------------------------------------}
PROCEDURE Entprellen;
{*
Zweck...............: Verzgert Programm, bis Mausbutton ruhig liegt.
}
BEGIN
  WHILE ButtonPressed DO BEGIN END;
END;
{-----------------------------------------------------------------------------}
procedure getvideomodes;
var i : integer;
    Code : ^string;
    a,b,c,d : string;
    ch : char;
    GraphDriver,Graphmode:integer;
begin
  if MouseOK then begin
    ResetMouse;
    i := 0;
    repeat
    MouseR.cx := i;
    MouseR.ax := 41;
    Intr ($33,MouseR);
{    Write(MouseR.cx,'  ',MouseR.bx,' ',MouseR.dx);}
    str(MouseR.cx,c);
    OutTextxy(50*5*(i div 50),10*(i mod 50),c+'  ');
    MouseR.ax := 40;
    Intr ($33,MouseR);
    MouseR.ax := 38;
    Intr ($33,MouseR);
    str(MouseR.bx,b); str(MouseR.cx,c); str(MouseR.dx,d);
    OutTextxy(50*5*(i div 50)+30,10*(i mod 50),b+' '+c+' '+d+'    ');
{    WriteLn(MouseR.bx,' ',MouseR.cx,' ',MouseR.dx);
    if not((MouseR.dx = 0) and (MouseR.bx = 0)) then begin
    Code := ptr(MouseR.bx,MouseR.dx);
    WriteLn(Code^);
    end
    else begin
    Write (MouseR.ax,' ',MouseR.bx,' ',MouseR.cx,' ',MouseR.dx,'   ');
    WriteLn (MouseR.bp,' ',MouseR.si,' ',MouseR.di,' ',MouseR.ds,' ',MouseR.es);
    end;}
    repeat until KeyPressed;
     ch := ReadKey;
    inc(i);
    until MouseR.cx = 0;
  end;
end;

  function leftbutton:boolean;
  var reg:registers;
  begin
    if not mouseok then begin
      leftbutton:=false;
      exit
    end;
    reg.ax:=3;
    intr(51,reg);
    leftbutton:=reg.bx and 1=1
  end;

  function rightbutton:boolean;
  var reg:registers;
  begin
    if not mouseok then begin
      rightbutton:=false;
      exit
    end;
    reg.ax:=3;
    intr(51,reg);
    rightbutton:=reg.bx and 2=2
  end;

  function middlebutton:boolean;
  var reg:registers;
  begin
    if not mouseok then begin
      middlebutton:=false;
      exit
    end;
    reg.ax:=3;
    intr(51,reg);
    middlebutton:=reg.bx and 4=4
  end;
{-----------------------------------------------------------------------------}
{$F+}
PROCEDURE MouseExit;
{*
Zweck...............: Diese Prozedur wird am Ende eines Programmes
                      automatisch aufgerfuen
Uses................: HideMouse, ResetMouseSubRoutine
}
BEGIN
  MouseWeg;
  IF MouseUserSet THEN ResetMouseSubRoutine;
  ExitProc := MouseExitSave;
END;
{$F-}
{=============================================================================}
procedure define_cursor;
var i : integer;
begin
SetFillStyle(SolidFill,63);
FillPoly(7,cs_pfeil);
cursorsize := 260;
Getmem(nocursor,cursorsize);
GetImage(550,290,565,305,nocursor^);
for i := 0 to 15 do begin
  GetMem(cursor[i],cursorsize-i*16);
  GetImage(500,290,515-i,305,cursor[i]^);
  end;
SetFillstyle(SolidFill,0);
Bar(500,290,520,310);
mx := 500; my := 290;
mx0 := 500; my0 := 290;
PutImage(mx0,my0,cursor[0]^,Trans_copy_put);
end;

procedure SetMouseBereich(x1,y1,x2,y2:word);
begin
minmouse_x := x1;
minmouse_y := y1;
maxmouse_x := x2;
maxmouse_y := y2;
end;

procedure Mouse_bewegen;
begin
ReadMouseMotion(dx,dy);
if (Abs(dx) > 0) or (Abs(dy) > 0) then begin
  Inc(mx,dx); Inc(my,dy);
  if mx > maxmouse_x then mx := maxmouse_x;
  if my > maxmouse_y then my := maxmouse_y;
  if mx < minmouse_x then mx := minmouse_x;
  if my < minmouse_y then my := minmouse_y;
  if VisibleMouse then
    if (mx > x-15) then begin
      PutImage(mx0,my0,nocursor^,copyput);
      GetImage(x-15,my,x,my+15,nocursor^);
      PutImage(mx,my,cursor[mx+15-x]^,Trans_copy_put);
      mx0 := x-15; my0 := my;
      end
    else begin
      PutImage(mx0,my0,nocursor^,copyput);
      GetImage(mx,my,mx+15,my+15,nocursor^);
      PutImage(mx,my,cursor[0]^,Trans_copy_put);
      mx0 := mx; my0 := my;
      end;
  end;
end;

procedure MouseWeg;
begin
if (mx < 0) or (mx > x) or (my < 0) or (my > y) then
  Exit;
VisibleMouse := False;
if mx > x-15 then
  PutImage(x-15,my,nocursor^,copyput)
else
  PutImage(mx,my,nocursor^,copyput);
end;

procedure MouseHer;
begin
if (mx < 0) or (mx > x) or (my < 0) or (my > y) then
  Exit;
VisibleMouse := True;
mx0 := mx; my0 := my;
if (mx > x-15) then begin
  GetImage(x-15,my,x,my+15,nocursor^);
  PutImage(mx,my,cursor[mx+15-x]^,Trans_copy_put);
  mx0 := x-15;
  end
else begin
  GetImage(mx,my,mx+15,my+15,nocursor^);
  PutImage(mx,my,cursor[0]^,Trans_copy_put);
  end;
end;

function Mouse_in_Menue : Boolean;
begin
Mouse_in_Menue := my < Menue_y;
end;

function Mouse_im_Bild : Boolean;
begin
Mouse_im_Bild := (mx > GraphWin_x) and (my > Menue_y) and (my < y-Lineal_b);
end;

function Mouse_in_Buttons : Boolean;
begin
Mouse_in_Buttons := (mx < Bereich_x) and (my > Schaltflaeche_y);
end;

function Mouse_in_NumWin : Boolean;
begin
Mouse_in_NumWin := (mx < Bereich_x) and
                   (my > NumWin_y1) and (my < NumWin_y2);
end;

function Mouse_auf_Pfeil : Byte;
begin
if (mx < Lineal_b) and
   (my > NumWin_y2) and (my < Schaltflaeche_y) then begin
  Mouse_auf_Pfeil := 1;
  Exit;
  end;
if (mx > NumWin_x - Lineal_b) and (mx < NumWin_x) and
   (my > NumWin_y2) and (my < Schaltflaeche_y) then begin
  Mouse_auf_Pfeil := 2;
  Exit;
  end;
if (mx > NumWin_x) and (mx < NumWin_x + Lineal_b) and
   (my > y - Lineal_b) then begin
  if (mx - NumWin_x) < (y - my) then
    Mouse_auf_Pfeil := 6                            { Bildflche nach unten }
  else
    Mouse_auf_Pfeil := 3;                           { Bildflche nach links }
  Exit
  end;
if (mx > x - Lineal_b) and (my > y - Lineal_b) then begin
  Mouse_auf_Pfeil := 4;                            { Bildflche nach rechts }
  Exit;
  end;
if (mx > NumWin_x) and (mx < GraphWin_x) and
   (my > Menue_y) and (my < Menue_y + Lineal_b) then begin
  Mouse_auf_Pfeil := 5;                              { Bildflche nach oben }
  Exit;
  end;
Mouse_auf_Pfeil := 0;
end;

procedure Exit_mymouse;
var i : integer;
begin
for i := 0 to 15 do
  FreeMem(cursor[i],cursorsize-i*16);
FreeMem(nocursor,cursorsize);
end;

BEGIN
  MouseOk := MouseInstalled;
  MouseOn := FALSE;
  IF MouseOK THEN BEGIN
     AllocMouseBuffer (MouseBufferPtr);
     SaveMouseDriverState (MouseBufferPtr);
     MouseExitSave := ExitProc;
     ExitProc := @MouseExit;
     WriteLn ('Maustreiber installiert');
     MouseR.ax := 28;
     MouseR.bx := 8;
     Intr ($33,MouseR);
  END
  ELSE WriteLn ('Achtung:Kein Maustreiber installiert');
END.
{=============================================================================}
