unit ifs_Twin;

INTERFACE
uses graph,ifs_def,xms,mymouse;

const rahmenlos    = 0;
      einfach      = 1;
      extended     = 2;
      pulldown     = 3;

var SaveScreen     : pointer;
    XmsText        : Array[1..5] of word;
    textsavesize   : Array[1..5] of longint;
    textsaveset    : Array[1..5,0..1] of Byte;

procedure Open_Text_Win(nummer: Byte; x1,y1,Breite,Hoehe: word;
                        Farbe,Rahmen : Byte);
procedure Close_Text_Win(nummer: Byte; x1,y1 : word);
procedure HelpMe(ItemNr: Byte);

IMPLEMENTATION

{***************************************************************************}
{*   ffnet ein Fenster zur Ausgabe von Texten                             *}
{***************************************************************************}
procedure Open_Text_Win(nummer: Byte; x1,y1,Breite,Hoehe: word;
                        Farbe,Rahmen : Byte);
var temp : comp;
    anz,i : Byte;
    Blockh,size : integer;
begin
temp := Succ(Breite);
temp := temp * Hoehe;
anz := Succ(trunc(temp / 10000));
if Hoehe mod anz = 0 then
  Blockh := Hoehe div anz
else
  Blockh := Succ(trunc(Hoehe / anz));
textsaveset[nummer,0] := anz;
textsaveset[nummer,1] := Blockh;
textsavesize[nummer] := Succ(Breite) * Blockh + 4;
if MaxAvail < textsavesize[nummer] then begin
  Halt;
  end;
temp := anz;
size := trunc(temp * textsavesize[nummer] / 1024) + 1;
XmsText[nummer] := XmsGetMem(size);
if XmsText[nummer] = 0 then
  Exit;
GetMem(SaveScreen,textsavesize[nummer]);
for i := 0 to Pred(anz) do begin
  GetImage(x1,y1+i*Blockh,x1+Breite,Pred(y1)+(i+1)*Blockh,SaveScreen^);
  XmsCopy(0,longint(SaveScreen),XmsText[nummer],i*Textsavesize[nummer],
          textsavesize[nummer] div 2);
  end;
FreeMem(SaveScreen,textsavesize[nummer]);
Dec(Breite);
Dec(Hoehe);
SetFillStyle(SolidFill,F_Linie);
Bar(x1,y1,x1+Breite,y1+Hoehe);
Inc(x1); Inc(y1);
Dec(Breite,2); Dec(Hoehe,2);
case Rahmen of
  0 : begin
      end;
  1 : begin
      Bar(x1,y1,x1+Breite,y1+Hoehe);
      Inc(x1); Inc(y1);
      Dec(Breite,2); Dec(Hoehe,2);
      end;
  2 : begin
      Bar(x1,y1,x1+Breite,y1+Hoehe);
      Dec(Breite,4); Dec(Hoehe,4);
      Inc(x1); Inc(y1);
      end;
  3 : begin
      Bar(x1,y1,x1+Breite,y1+Hoehe);
      Dec(Breite,3); Dec(Hoehe,1);
      Inc(x1); Dec(y1);
      end;
  end;
SetFillStyle(SolidFill,Farbe);
Bar(x1,y1,x1+Breite,y1+Hoehe);
end;

{***************************************************************************}
{*   schliet ein Fenster, das mit open_Text_Win geffnet wurde            *}
{***************************************************************************}
procedure Close_Text_Win(nummer: Byte; x1,y1 : word);
var Blockh: integer;
    i : Byte;
begin
Blockh := textsaveset[nummer,1];
GetMem(SaveScreen,Textsavesize[nummer]);
for i := 0 to Pred(textsaveset[nummer,0]) do begin
  XmsCopy(XmsText[nummer],i*textsavesize[nummer],0,longint(SaveScreen),
          textsavesize[nummer] div 2);
  PutImage(x1,y1+i*Blockh,SaveScreen^,CopyPut);
  end;
XmsFreeMem(XmsText[nummer]);
FreeMem(SaveScreen,textsavesize[nummer]);
XmsText[nummer] := 0;
end;

procedure HelpMe(ItemNr: Byte);
var f   : Text;
    rec : record
          Nr,Anzahl : Byte;
          end;
    i,j : integer;
    s   : string;
    smx,
    smy : integer;
    Ende: Boolean;
begin
Ende := False;
smx := mx;
smy := my;
MouseWeg;
Open_Text_Win(5,GraphWin_x,Menue_y,549,549,160,einfach);
SetTextStyle(SmallFont,HorizDir,6);
SetTextJustify(CenterText,CenterText);
SetFillStyle(SolidFill,F_Text);
Bar(440,530,600,560);
SetFillStyle(SolidFill,F_Text_rot);
Bar(442,532,595,555);
SetColor(F_Text);
OutTextXY(520,545,'Beenden');
OutTextXY(521,545,'Beenden');
SetTextJustify(LeftText,TopText);
{$I-};
assign(f,'help.hlp');
reset(f);
{$I+};
if IOResult <> 0 then
  Exit;
readln(f,s);
Val(copy(s,0,2),rec.Nr,j);
if j <> 0 then begin
  close(f);
  Close_Text_Win(5,GraphWin_x,Menue_y);
  Exit;
  End;
Val(copy(s,4,2),rec.Anzahl,j);
if (j <> 0) or (rec.Anzahl < 1) then begin
  close(f);
  Close_Text_Win(5,GraphWin_x,Menue_y);
  Exit;
  End;
if rec.Nr <> ItemNr then begin
  repeat                          
    for i := 1 to rec.Anzahl+1 do
      readln(f,s);
    if not eof(f) then begin
      Val(copy(s,0,2),rec.Nr,j);
      if j <> 0 then begin
        close(f);
        Close_Text_Win(5,GraphWin_x,Menue_y);
        Exit;
        End;
      Val(copy(s,4,2),rec.Anzahl,j);
      if (j <> 0) or (rec.Anzahl < 1) then begin
        close(f);
        Close_Text_Win(5,GraphWin_x,Menue_y);
        Exit;
        end;
      end;
  until eof(f) or (rec.Nr = ItemNr);
  if eof(f) then begin
    close(f);
    Close_Text_Win(5,GraphWin_x,Menue_y);
    Exit;
    end;
  end;
readln(f,s);
OutTextXY(260,45,s);
OutTextXY(261,45,s);
for i := 2 to rec.Anzahl do begin
  readln(f,s);
  OutTextXY(260,40+i*20,s);
  OutTextXY(261,40+i*20,s);
  end;
close(f);
mx := 570;
my := 540;
MouseHer;
repeat
  repeat
    Mouse_bewegen;
  until ButtonPressed;
  if (my > 530) and (my < 560) and (mx > 440) and (mx < 600) then
    Ende := True;
until Ende;
Entprellen;
MouseWeg;
Close_Text_Win(5,GraphWin_x,Menue_y);
mx := smx;
my := smy;
MouseHer;
end;

var i : Byte;
begin
SaveScreen := nil;
for i := 1 to 5 do begin
  XmsText[i] := 0;
  end;
end.