{$O+}
unit ifs_rgb;
{**************************************************************************}
{*                                                                        *}
{* diese Unit enthlt angepate Routinen aus der Unit B_RGB_IO aus        *}
{* Fred, the Fractal Editor 1.0, Batchprogramm                 03.02.1991 *}
{* Unit B_RGB_IO                                               Ernst Prix *}
{*                                                                        *}
{* adaptiert fr IFS-Editor II am 17.03.1993 von Martin Schwarzinger      *}
{* als Schnittstelle an das oben genannte Programm                        *}
{* und erweitert auf 256 Farben                                           *}
{*                                                                        *}
{* 1.) rgb_save  - speichert Bild als rgb-Datei                           *}
{* 2.) rgb_load  - ldt ein Bild aus einer rgb-Datei                      *}
{*                                                                        *}
{**************************************************************************}

interface

procedure rgb_load(filename : string);
procedure rgb_save(filename : string);

implementation

uses dos, graph, crt,ifs_def;

const RGBBLOCKLENGTH = 512;
      LENGTHMIN1     = RGBBLOCKLENGTH-1;

      C_UP = 72;              {************************************}
      C_DOWN = 80;            {*                                  *}
      C_LEFT = 75;            {*                                  *}
      C_RIGHT = 77;           {*                                  *}
      C_TAB_L = 15;           {*          S C A N - C O D E       *}
      C_INS = 82;             {*                                  *}
      C_DEL = 83;             {*        erweiterter Ascii-Code    *}
      C_HOME = 71;            {*                                  *}
      C_END = 79;             {*                                  *}
      C_PGUP = 73;            {*                                  *}
      C_PGDN = 81;            {*                                  *}
      C_F1 = 59;              {************************************}

      C_ESC = 27;             {************************************}
      C_CTRLC = 3;            {*                                  *}
      C_ENTER = 13;           {*       A S C I I - C O D E        *}
      C_BACK = 8;             {*                                  *}
      C_TAB_R = 9;            {*                                  *}
      C_SPACE = 32;           {************************************}


type  rgbbyte  = 0..255;
      rgbsatz  = packed array [0..LENGTHMIN1] of rgbbyte;
      rgbfile  = file of rgbsatz;
      rgbdescr = record
                   writemode,
                   singlemode : boolean;
                   rgbposition: integer;
                   rgbcount   : longint;
                   rold,gold,
                   bold       : rgbbyte;
                   rgbzeichen : longint;
                 end;

var  leersatz: rgbsatz;
     f : rgbfile;

procedure ProzentBalken(laenge,lastpos,newpos:longint);
const Startx = 20;
      Endx   = 210;
var dx : real;
    x1,x2 : integer;
    Starty: integer;
begin
Starty := NumWin_y2-20;
SetFillStyle(SolidFill,F_Linie);
dx := (Endx-Startx) / laenge;
x1 := Startx + round(dx * (laenge - lastpos));
x2 := Startx + round(dx * (laenge - newpos));
SetViewPort(0,0,x,y,True);
Bar(x1,Starty,x2,Starty-20);
SetViewPort(GraphWin_x,Menue_y,x,y-Lineal_b,True);
end;

function rgbeof (d: rgbdescr):boolean;
begin
rgbeof:= d.rgbzeichen < 0;
end;

function rgbreset(var s: rgbsatz; var d: rgbdescr; var b,h : longint;
                   var v: real) : boolean;
var ios : word;
begin
repeat
  {$I-}
  reset(f);
  {$I+}
  ios := ioresult;
  if (ios <> 0) then begin
    if ios = 152 then begin
      {erg := message_box('          Laufwerk nicht bereit',
                         '             OK     : neuer Versuch',
                         '             CANCEL : quit', false, 3);
      if erg = C_ESC then begin}
      {$I-}
      close(f);
      {$I+}
      ios := ioresult;
      rgbreset := False;
      exit;
      end
    else begin
      {io_error_message(ios, '          Beim ffnen des Files');}
      {$I-}
      close(f);
      {$I+}
      ios := ioresult;
      rgbreset := False;
      exit;
    end;
  end;
until ios = 0;
if not eof(f) then
  with d do begin
    read(f,s);
    { fileheader: }
    { bildbreite b und -hoehe h stehen als je 2 byte auf dem file        }
    b:=s[0]*256+s[1];
    h:=s[2]*256+s[3];
    { pixelverhaeltnis v steht als fixpoint-real (1 byte vk ; 3 byte nk) }
    { auf dem file }
    v:=s[4]+(s[5]+(s[6]+s[7]/256)/256)/256;
    rgbzeichen:=longint(b+1)*longint(h+1);
    rgbposition:=8;
    rgbcount:=0;
    rold:=0; gold:=0; bold:=0;
    singlemode:=false;
    writemode:=false;
    rgbreset := True;
    end
else
  d.rgbzeichen:=-1;
end;

procedure bytelesen(var s:rgbsatz;var d:rgbdescr;var b:rgbbyte);
begin
with d do begin
  if rgbposition=RGBBLOCKLENGTH then begin
    rgbposition:=0;
    if eof(f) then
       rgbzeichen:=-1
    {wegen einfacheren Bedingung in rgbeof}
    else
       read(f,s);
    end;
  b:=s[rgbposition];
  rgbposition:=rgbposition+1;
end;
end; (* bytelesen *)

procedure readrun (var s: rgbsatz; var d: rgbdescr);
var hlp : rgbbyte;

  procedure readcount (var c: longint);
  var i: integer;
      b: rgbbyte;
  begin
  if c=0 then begin
    for i:=1 to 4 do begin
      bytelesen(s,d,b);
      c:=256*c+b;
      end;
    if c=0 then {eof-marke}
      d.rgbzeichen:=-1;
    end;
  end;

begin {readrun}
with d do begin
  if singlemode then begin
    bytelesen(s,d,rold);
    if rold=1 then begin
      bytelesen(s,d,hlp);
      rgbcount := hlp;
      if rgbcount<>1 then begin
        singlemode:=false;
        readcount(rgbcount);
        bytelesen(s,d,rold);
        end
      end
    else
      rgbcount:=1;
    end
  else begin
    bytelesen(s,d,hlp);
    rgbcount := hlp;
    readcount(rgbcount);
    singlemode := rgbcount=1;
    bytelesen(s,d,rold);
    end;
  bytelesen(s,d,gold);
  bytelesen(s,d,bold);
  end;
end;

procedure rgbread(var s: rgbsatz; var d: rgbdescr; var r,g,b:rgbbyte);
begin
with d do begin
  if rgbcount=0 then
    readrun(s,d);
  r:=rold; g:=gold; b:=bold;
  rgbzeichen:=rgbzeichen-1;
  rgbcount:=rgbcount-1;
  end;
end;

procedure rgbreadrun (var s: rgbsatz; var d: rgbdescr;
                      var r,g,b: rgbbyte; var c: longint);
begin
with d do begin
  if rgbcount=0 then
    readrun(s,d);
  r:=rold; g:=gold; b:=bold;
  c:=rgbcount;
  rgbzeichen:=rgbzeichen-rgbcount;
  rgbcount:=0;
  end;
end;

function rgbrewrite(var s: rgbsatz; var d: rgbdescr; b,h :integer; v: real):
        boolean;
var i,iv: integer;
    ios : word;
    erg : integer;
begin
for i:=0 to LENGTHMIN1 do
  leersatz[i]:=0;
repeat
{$I-}
rewrite(f);
{$I+}
ios := ioresult;
if (ios <> 0) then begin
  if ios = 152 then begin
    {write_mess('Laufwerk nicht bereit.');}
    {$I-}
    close(f);
    {$I+}
    ios := ioresult;
    rgbrewrite := False;
    exit;
  end
else begin
  {write_mess('Fehler beim ffnen der RGB-Datei.');}
  {$I-}
  close(f);
  {$I+}
  ios := ioresult;
  rgbrewrite := False;
  exit;
  end;
end;
until ios = 0;
s:=leersatz;
{ fileheader: vgl. rgbreset }
s[0]:=b div 256; s[1]:=b mod 256;
s[2]:=h div 256; s[3]:=h mod 256;
for i:=4 to 7 do begin
  iv:=trunc(v);
  s[i]:=iv;
  v:=(v-iv)*256
  end;
with d do begin
  rgbzeichen:=longint(h+1)*longint(b+1);
  rgbposition:=8;
  rgbcount:=0;
  rold:=0; gold:=0; bold:=0;
  singlemode:=false;
  writemode:=true;
  end;
rgbrewrite := True;
end;

procedure byteschreiben(var s:rgbsatz;var d:rgbdescr;b:rgbbyte);
begin
with d do begin
  if rgbposition=RGBBLOCKLENGTH then begin
    write(f,s);
    rgbposition:=0;
    s:=leersatz;
  end;
  s[rgbposition]:=b;
  rgbposition:=rgbposition+1;
  end;
end; (* byteschreiben *)

procedure writerun (var s: rgbsatz; var d: rgbdescr);

  procedure writecount (c: longint);
  const q256=256*256;
        k256=q256*256;
  begin
  if c>255 then begin
    byteschreiben(s,d,0);
    byteschreiben(s,d,c div k256);
    byteschreiben(s,d,c div q256 mod 256);
    byteschreiben(s,d,c div  256 mod 256);
    end;
    byteschreiben(s,d,c mod 256);
  end;

begin {writerun}
with d do
  if rgbcount>0 then begin
    if singlemode then begin
      if rgbcount>1 then begin
        byteschreiben(s,d,1);
        singlemode:=false;
        writecount(rgbcount);
        end
      else
        if rold=1 then
          byteschreiben(s,d,1);
      end
    else begin
      writecount(rgbcount);
      singlemode:= rgbcount=1;
      end;
    byteschreiben(s,d,rold);
    byteschreiben(s,d,gold);
    byteschreiben(s,d,bold);
    rgbzeichen:=rgbzeichen-rgbcount;
    end;
end;

procedure rgbwrite(var s: rgbsatz; var d: rgbdescr; r,g,b: rgbbyte);
begin
with d do
  if (r=rold) and (g=gold) and (b=bold) then
    rgbcount:=rgbcount+1
  else begin
    writerun(s,d);
    rgbcount:=1;
    rold:=r; gold:=g; bold:=b;
    end;
end;

procedure rgbwriterun (var s: rgbsatz; var d: rgbdescr;
                               r,g,b: rgbbyte; c: longint);
begin
if c>0 then
  with d do begin
    if (r=rold) and (g=gold) and (b=bold) then
      rgbcount:=rgbcount+c
    else begin
      writerun(s,d);
      rold:=r; gold:=g; bold:=b;
      rgbcount:=c;
      end;
    end;
end;

procedure rgbclose (var s: rgbsatz; var d: rgbdescr);
begin
with d do
  if writemode then begin
    if rgbzeichen>rgbcount then
      rgbcount:=rgbzeichen;
    writerun(s,d);
    write(f,s);
    end;
close(f);
end;

function get_drivenr(drive: char): byte;
{***************************************************************************}
{*                                                                         *}
{*  Ermittelt aus einem Buchstaben die logische Laufwerksnummer            *}
{*    z.B.  A -> 1,  B -> 2, .....                                         *}
{*  Eingabeparameter: drive - Laufwerksbezeichnung (z.B.  A)               *}
{*  Ausgabeparameter: keine                                                *}
{*                                                                         *}
{***************************************************************************}
begin
drive := upcase(drive);
get_drivenr := ord(drive) - ord('A') + 1;
end;

function get_diskspace(filename: string): longint;
{***************************************************************************}
{*                                                                         *}
{*  Falls der Filename 'filename' eine Laufwerksbezeichnung enthlt, wird  *}
{*  berprft, wieviele Bytes noch auf diesem Laufwerk frei sind.          *}
{*  Falls keine Laufwerksbezeichnung enthalten ist, wird das aktuelle      *}
{*  Laufwerk berprft.                                                    *}
{*  Falls Funktionswert -1 zurckgeliefert wird, wurde entweder ein        *}
{*  falsches Laufwerk angegeben, oder das Laufwerk ist nicht bereit        *}
{*  Eingabeparameter: filename - Name eines Files                          *}
{*  Ausgabeparameter: keine                                                *}
{*                                                                         *}
{***************************************************************************}
begin
if filename[2] = ':' then
  get_diskspace := diskfree(get_drivenr(filename[1]))
else
  get_diskspace := diskfree(0);                 {aktuelle Laufwerk}
end;

procedure rgb_save(filename : string);
{***************************************************************************}
{*                                                                         *}
{* Speichert ein Bild im RGB-Format                                        *}
{*                                                                         *}
{* Eingabeparameter: Filename des Picturefiles (incl Pfad)                 *}
{* Ausgabeparameter: keine                                                 *}
{*                                                                         *}
{***************************************************************************}
type rgbrec = record
                    r,g,b,nr : byte;
              end;
var free : longint;
    s : rgbsatz;
    d : rgbdescr;
    rx, ry : integer;
    prz : real;
    p : string[3];
    col, xb, dx, dy : word;
    i : byte;
    zeich, rgbzold : longint;
    z : integer;
    erg : integer;
    r, g, b : byte;
    color    : RGBTable;
    RGBDatei : File of RGBTable;
begin
{$I-};
assign(RGBDatei,'Farben.tab');
reset(RGBDatei);
read(RGBDatei,color);
close(RGBDatei);
{$I+};
erg := C_ENTER;
repeat
  free := get_diskspace(filename);
  if (free = -1) then begin
    {write_mess('Laufwerk nicht bereit.');}
    exit;
  end;
until free >= 0;
assign(f,filename);
dy := 549;
dx := 549;
SetViewPort(GraphWin_x,Menue_y,x,y-Lineal_b,True);
if not rgbrewrite(s,d,dx,dy,1) then begin
  exit;
end;
zeich := d.rgbzeichen;
rgbzold := zeich;
z := 0;
xb := (dx+8) div 8;
ry := 0;
while ry <= dy do begin
  rx := 0;
  while rx <= dx do begin
    col := GetPixel(rx,ry);
    r := color[col].red;
    g := color[col].green;
    b := color[col].blue;
    rgbwriterun(s,d,r,g,b,1);
    if z > zeich div 100 then begin
      ProzentBalken(zeich,rgbzold,d.rgbzeichen-d.rgbcount);
      rgbzold := d.rgbzeichen-d.rgbcount;
      z := 0;
      end;
    inc(z);
    if keypressed and (ord(readkey) = C_ESC) then begin
      rgbzold := d.rgbzeichen;
      rx := dx;
      ry := dy;
      end;
    inc(rx);
    end;
  inc(ry);
  end;
rgbclose(s,d);
SetViewPort(0,0,x,y,True);
end;

procedure rgb_load(filename : string);
{***************************************************************************}
{*                                                                         *}
{* Das Bild wird in das aktuelle Window geladen. Dabei wird die Gre der  *}
{* Windowgre angepat. Die RGBWerte werden auf die mglichen             *}
{* Farbwerte reduziert.                                                    *}
{*                                                                         *}
{* Eingabeparameter : File, das das zu ladende Bild enthlt                *}
{* Ausgabeparameter : keine                                                *}
{*                                                                         *}
{***************************************************************************}
type rgbrec = record
                    r,g,b,nr : byte;
              end;
const  ESC = #27;
var free : longint;
    s : rgbsatz;
    d : rgbdescr;
    px1,py1,px2,py2,dx,dy : integer;
    br,ho,bc,hc : longint;
    v : real;
    rx, ry, xold, yold, rxx, ryy, rx1, ry1 : integer;
    col,xb : word;
    pal : palettetype;
    i : longint;
    r,g,b : rgbbyte;
    count : longint;
    ok, abbr : boolean;
    zeich, rgbzold : longint;
    z : integer;
    diff, best_diff : integer;
    color    : RGBTable;
    RGBDatei : File of RGBTable;
begin
{$I-};
assign(RGBDatei,'Farben.tab');
reset(RGBDatei);
read(RGBDatei,color);
close(RGBDatei);
{$I+};
repeat
  free := get_diskspace(filename);
  if (free = -1) then
     exit;
until free >= 0;
assign(f,filename);
dx := x - GraphWin_x;
dy := y - Menue_y - Lineal_b;
if not rgbreset(s,d,br,ho,v) then begin
  exit;
end;
zeich := d.rgbzeichen;
rgbzold := zeich;
z := 0;
bc := -1;
hc := 0;
xold := -1;
yold := -1;
xb := (x-GraphWin_x+8) div 8;
ok := True;
abbr := False;
while not rgbeof(d) and ok do begin
  rgbreadrun(s,d,r,g,b,count);
  col := 0;
  while (col <= 255) and ((r <> color[col].red) or
        (g <> color[col].green) or (b <> color[col].blue)) do
    inc(col);
  if col > 255 then begin
    col := 0;
    best_diff := 3*256;
    for i := 0 to 255 do begin
      diff := abs(r-color[i].red) + abs(g-color[i].green) +
              abs(b-color[i].blue);
      if diff < best_diff then begin
        best_diff := diff;
        col := i;
        end;
      end;
    end;
  ok := True;
  i := 1;
  while i <= count do begin
    inc(bc);
    if bc > br then begin
      bc := 0;
      inc(hc);
      if hc > ho then
         ok := False;
      end;
    if ok then begin
      if z > zeich div 100 then begin
        ProzentBalken(zeich,rgbzold,zeich-hc*br-bc);
        rgbzold := zeich-hc*br-bc;
        z := 0;
        end;
      inc(z);
      rx := round(bc / br * dx);
      ry := round(hc / ho * dy);
      if dx < round((bc + 1) / br * dx) - 1 then
        rxx := dx
      else
        rxx := round((bc + 1) / br * dx) - 1;
      if rxx < rx then
        rxx := rx;
      if dy < round((hc + 1) / ho * dy) - 1 then
        ryy := dy
      else
        ryy := round((hc + 1) / ho * dy) - 1;
      if ryy < ry then
        ryy := ry;
      if (rx <> xold) or (ry <> yold) then begin
        xold := rx;
        yold := ry;
        for rx1 := rx to rxx do
          for ry1 := ry to ryy do
            PutPixel(rx1,ry1,col);
        end;
      end;
    {if keypressed and (readkey = ESC) then begin
      erg := message_box('','       Laden des Bildes abbrechen?',
                          '',False,3);
      rgbzold := zeich;
      if erg = C_ENTER then begin
        i := count;
        abbr := True;
        ok := False;
        end;
      end;}
    inc(i);
    end;
  end;
  rgbclose(s,d);
end;
{-------------------------------------------------------------------------}

begin
end.
