{$O+}
unit ifs_gedit;

INTERFACE

const E_String = 0;
      E_Integer = 1;
      E_Real = 2;

function ltrim(s:string):string;
function rtrim(s:string):string;
function trim(s:string):string;

procedure Edit(var Wert: string; Typ,Limit: Byte; wox,woy: Word;
               TextCol,BackCol: Byte; var Ecode: integer);
procedure WriteXY(xloc,yloc: word;text: string);

IMPLEMENTATION

uses crt,graph,mymouse,ifs_def;

const TextColor = 63;
      BackColor = 10;

var OldText : TextSettingstype;

function ltrim(s:string):string;
var i:byte;
    len:byte absolute s;
begin
for i:=1 to len do begin
  if s[i]<>#32 then begin
    delete(s,1,pred(i));
    ltrim:=s;
    exit
    end;
  end;
  if s[len]=#32 then len:=0;
  ltrim:=s
end;

function rtrim(s:string):string;
var i:byte;
    len:byte absolute s;
begin
for i:=len downto 1 do begin
  if s[i]<>#32 then begin
    s[0]:=char(i);
    rtrim:=s;
    exit
    end;
  end;
if s[1]=#32 then len:=0;
rtrim:=s
end;

function trim(s:string):string;
var i:byte;
    len:byte absolute s;
    temp:string;
    z:byte absolute temp;
begin
z:=0;
for i:=1 to len do begin
  if s[i]<>#32 then begin
    inc(z);
    temp[z]:=s[i]
    end
  end;
trim:=temp
end;

procedure Voreinstellung;
begin
with OldText do begin
  SetTextStyle(Font,Direction,CharSize);
  SetTextJustify(Horiz,Vert);
  end;
end;

procedure WriteXY(xloc,yloc: word;text: string);
var i,laenge : Byte;
begin
SetTextStyle(Smallfont,HorizDir,6);
SetTextJustify(LeftText,BottomText);
laenge := length(text);
for i := 1 to laenge do begin
  MoveTo(xloc+i*TextWidth('9'),yloc);
  OutText(text[i]);
  end;
end;

procedure Edit(var Wert: string; Typ,Limit: Byte; wox,woy: Word;
               TextCol,BackCol: Byte; var Ecode: integer);
var i,j,
    laenge,Breite    : Byte;
    valcode,valint   : integer;
    valreal          : real;
    raus,AbbruchFlag,
    ignore           : Boolean;
    HelpFlag: Boolean;
    button,mx,my     : word;
    ch               : char;
    text             : string;
begin
HelpFlag := False;
Ecode := 0;
i := 1;
raus := False;
Abbruchflag := False;
GetTextSettings(OldText);
SetTextStyle(Smallfont,HorizDir,6);
SetTextJustify(LeftText,BottomText);
Breite := TextWidth('9');
text := Wert;
laenge := length(text);
for i := laenge to 5 do
  text := text + ' ';
SetColor(TextCol);
{for i := 1 to laenge do begin
  MoveTo(wox+i*Breite,woy);
  OutText(text[i]);
  end;}
WriteXY(wox,woy,text);
i := 1;
Moveto(wox+i*Breite,woy);
OutText('_');
repeat
  MouseHer;
  repeat
    Mouse_bewegen;
  until KeyPressed or ButtonPressed;
  MouseWeg;
  if ButtonPressed then begin
    if KeyPressed then
      repeat
        ch := readKey;
      until not KeyPressed;
    if LeftButton then
      ch := chr(13)
    else
      ch := chr(27);
    end
  else
    ch := Readkey;
  case Ord(ch) of
     8 : begin                         {Backspace}
         if i > 1 then begin
           SetColor(BackCol);
           Moveto(wox+i*Breite,woy);
           OutText('_');
           Dec(i);
           Moveto(wox+i*Breite,woy);
           OutText(text[i]);
           if i > 1 then begin
             for j := i to laenge do begin
               MoveTo(wox+j*Breite,woy);
               OutText(Text[j]);
               end;
             Delete(text,i,1);
             SetColor(TextCol);
             WriteXY(wox,woy,text);
             insert(' ',text,laenge);
             Text[0] := char(laenge);
             end;
           Moveto(wox+i*Breite,woy);
           SetColor(TextCol);
           OutText('_');
           end
         else
           Write(chr(7));
         end;
    13 : begin                          {Return}
         Moveto(wox+i*Breite,woy);
         SetColor(BackCol);
         OutText('_');
         raus := true;
         end;
    27 : begin                          {ESC}
         Moveto(wox+i*Breite,woy);
         SetColor(BackCol);
         OutText('_');
         WriteXY(wox,woy,text);
         SetColor(TextCol);
         WriteXY(wox,woy,Wert);
         text := Wert;
         raus := true;
         AbbruchFlag := True;
         end;
     0 : begin                          {Sonderzeichen}
         ch := ReadKey;
         case Ord(ch) of
           59 : begin
                HelpFlag := True;
                Moveto(wox+i*Breite,woy);
                SetColor(BackCol);
                OutText('_');
                raus := true;
                end;
           71 : begin                   {Home}
                MoveTo(wox+i*Breite,woy);
                SetColor(BackCol);
                OutText('_');
                SetColor(TextCol);
                i := 1;
                MoveTo(wox+i*Breite,woy);
                OutText('_');
                end;
           75 : begin                   {Left_Arrow}
                MoveTo(wox+i*Breite,woy);
                SetColor(BackCol);
                OutText('_');
                SetColor(TextCol);
                if i > 1 then
                  Dec(i);
                MoveTo(wox+i*Breite,woy);
                OutText('_');
                end;
           77 : begin                   {Right_Arrow}
                MoveTo(wox+i*Breite,woy);
                SetColor(BackCol);
                OutText('_');
                SetColor(TextCol);
                if i < Limit then
                  Inc(i);
                MoveTo(wox+i*Breite,woy);
                OutText('_');
                if i = Succ(length(text)) then        {am Textende}
                  SetWriteMode(0);
                end;
           79 : begin                   {End}
                MoveTo(wox+i*Breite,woy);
                SetColor(BackCol);
                OutText('_');
                SetColor(TextCol);
                i := length(trim(text));              {ans Textende}
                if i < Limit then
                  Inc(i);
                SetWriteMode(0);                      {berschreiben}
                MoveTo(wox+i*Breite,woy);
                OutText('_');
                end;
           83 : begin                   {Delete}
                if i >= 1 then begin
                  Moveto(wox+i*Breite,woy);
                  SetColor(BackCol);
                  OutText(text[i]);
                  Moveto(wox+i*Breite,woy);
                  OutText('_');
                  text[i] := ' ';
                  for j := i to laenge do begin
                    MoveTo(wox+j*Breite,woy);
                    OutText(Text[j]);
                    end;
                  Delete(text,i,1);
                  SetColor(TextCol);
                  WriteXY(wox,woy,text);
                  insert(' ',text,laenge);
                  Text[0] := char(laenge);
                  Moveto(wox+i*Breite,woy);
                  OutText('_');
                  end
                else
                  Write(chr(7));
                end;
           end;
         end;
    else begin
         case Typ of
           E_String : begin
                      case ch of
                        'A'..'Z','a'..'z','0'..'9','_','.',',',' ' : begin
                          if i <= Limit then begin
                            MoveTo(wox+i*Breite,woy);
                            SetColor(BackCol);
                            OutText(text[i]);
                            MoveTo(wox+i*Breite,woy);
                            OutText('_');
                            SetColor(TextCol);
                            MoveTo(wox+i*Breite,woy);
                            laenge := integer(text[0]);
                            if (i >= laenge) and (i <= Limit) then
                              Insert(' ',text,i);
                            text[i] := ch;
                            OutText(text[i]);
                            if i <= Limit then begin
                              if i >= laenge then begin
                                Inc(laenge);
                                if (i < laenge) and (i < Limit) then
                                  Text[laenge] := ' ';
                                end;
                              Inc(i);
                              end;
                            Text[0] := char(laenge);
                            end
                          else
                            Write(chr(7));
                          MoveTo(wox+i*Breite,woy);
                          SetWriteMode(XOrput);
                          OutText('_');
                          SetWriteMode(0);
                          end;
                        else
                          Write(CHR(7));
                        end; {case}
                      end;
           E_Integer: begin
                      case ch of
                        '0'..'9','+','-',' ' : begin
                          if i <= Limit then begin
                            MoveTo(wox+i*Breite,woy);
                            SetColor(BackCol);
                            OutText(text[i]);
                            MoveTo(wox+i*Breite,woy);
                            OutText('_');
                            SetColor(TextCol);
                            MoveTo(wox+i*Breite,woy);
                            text[i] := ch;
                            OutText(text[i]);
                            laenge := integer(text[0]);
                            if i < Limit then begin
                              if i = laenge then begin
                                Inc(laenge);
                                text[laenge] := ' ';
                                end;
                              Inc(i);
                              end;
                            Text[0] := char(laenge);
                            end
                          else
                            Write(chr(7));
                          MoveTo(wox+i*Breite,woy);
                          SetWriteMode(XOrput);
                          OutText('_');
                          SetWriteMode(0);
                          end;
                        else
                          Write(CHR(7));
                        end; {case}
                      end;
           E_Real   : begin
                      case ch of
                        '0'..'9','.','+','-',',',' ' : begin
                          if i <= Limit then begin
                            MoveTo(wox+i*Breite,woy);
                            SetColor(BackCol);
                            OutText(text[i]);
                            MoveTo(wox+i*Breite,woy);
                            OutText('_');
                            SetColor(TextCol);
                            MoveTo(wox+i*Breite,woy);
                            ignore := False;
                            if ch = ',' then
                              ch := '.';
                            if (ch = '.') and (i <> pos('.',text)) and
                               (pos('.',text) > 0) then begin
                              ch := text[i];
                              ignore := true;
                              end
                            else
                              text[i] := ch;
                            OutText(text[i]);
                            if i < Limit then begin
                              if i = laenge then begin
                                Inc(laenge);
                                Text[laenge] := ' ';
                                end;
                              if not ignore then
                                Inc(i);
                              end;
                            Text[0] := char(laenge);
                            end
                          else
                            Write(chr(7));
                          MoveTo(wox+i*Breite,woy);
                          SetWriteMode(XOrput);
                          OutText('_');
                          SetWriteMode(0);
                          end;
                        else
                          Write(CHR(7));
                        end; {case}
                      end;
                    end;
           end;
    end;
until raus;
if AbbruchFlag then begin
  Ecode := -1;
  Voreinstellung;
  Exit;
  end;
case Typ of
  E_String : Wert := text;
  E_Integer: begin
             Val(Trim(text),valreal,valcode);
             if valcode <> 0 then begin              {Fehler in Umwandlung}
               Ecode := valcode;
               Voreinstellung;
               if HelpFlag then
                 Ecode := 255;
               Exit;
               end
             else
               Wert := Trim(text);
             end;
  E_Real   : begin
             Val(Trim(text),valreal,valcode);
             if valcode <> 0 then begin
               Ecode := valcode;
               Voreinstellung;
               if HelpFlag then
                 Ecode := 255;
               Exit;
               end
             else
               Wert := Trim(text);
             end;
  end;
Voreinstellung;
if HelpFlag then
  Ecode := 255;
end;

{-------------------------------------------------------------------------}
begin
end.