unit ifs_def;
INTERFACE
uses graph,dos;

const Ende             : Boolean = False;
      VisibleMouse     : Boolean = True;
      Funktionswitch   : Boolean = False;           { Funktion oder Bereich }
      Funktionsanzeige : Boolean = True;             { Funktionen oder MRFS }
      AttraktorFlag    : Boolean = False;         { Attraktor dargestellt ? }
      Skalierung       : Real = 1.0;
      Max_LR_laenge  = 40;
      Max_Bereiche   = 15;
      Max_Funktionen = 15;
      Menueschrift   = 7;
      Headline       = 5;
      Wertezeile     = 4;
      MenueName1     = 'Ansicht';
      MenueName2     = 'Funktionen';
      MenueName3     = 'Spezielles';

      F_Text     =  63;
      F_Text_rot =  69;
      F_Bereich  = 170;
      F_Funktion = 165;
      F_Fenster  =  15;
      F_Menue    =   5;
      F_Linie    =  63;
      F_B_Poly   = 185;
      F_F_Poly   =  69;

type RGBRec = record Red,Green,Blue : integer; end;
     RGBTable = Array[0..255] of RGBRec;
     Namenstring = string[12];
     RPunkttyp = record
                 x,y : double;
                 end;
     Punkttyp = record
                x,y : longint;
                end;
     Lineare_Funktion = record
                        a,b,c,
                        d,e,f : real;
                        end;
     NonLin_Funktion  = record
                        Anzahl_x,                          { Anzahl Unter-}
                        Anzahl_y : Byte;                   { teilungen,   }
                        Punkt : Array[0..16] of RPunkttyp; { Abweichungen }
                        dummy : word;                      { v. Normpunkt }
                        end;
     LRTable          = record
                        LR : Array[1..Max_LR_laenge] of char;
                        end;
     LFunkptr         = ^Lineare_Funktion;
     NLFunkptr        = ^NonLin_Funktion;
     LRptr            = ^LRTable;
     Funktionstyp     = record
                        Nummer : Byte;
                        Art    : Boolean;               {linear oder nicht}
                        Bereich: char;
                        LFunk  : LFunkptr;
                        NFunk  : NLFunkptr;
                        Winkel : double;
                        Wahrscheinlichkeit : real;
                        Farbe : Byte;
                        Restriction : LRptr;
                        end;
     B_Koordinaten    = record
                        a,b,c,
                        d,e,f  : real;
                        Winkel : double;
                        end;
     Funktionsptr     = ^Funktionstyp;
     Single_IFS       = record
                        Bereichsnummer : char;
                        Name           : Namenstring;
                        Linearitaet    : Boolean;
                        Form           : B_Koordinaten;
                        Anzahl_Fkt     : Byte;
                        Funktion       : Array[1..15] of Funktionsptr;
                        end;
     IFSptr           = ^Single_IFS;

     Defaultwerte     = record
                        _Form : B_Koordinaten;
                        _LFunk : Lineare_Funktion;
                        _Funktionsart : Boolean;
                        _Winkel : double;
                        end;

var x,y,Menue_y, Bereich_x, Bereich_y,
    NumWin_x, NumWin_y1,NumWin_y2,
    Lineal_l, Lineal_b, GraphWin_x,
    Menuetext_y, Schaltflaeche_y,
    Bereichtext_x, Bereichtext_y,
    Numtext_x, NumText_y, Numtext_abstand,
    NumHead_x, NumHead_y, NumHead_abstand,
    Leerfeld, Button_b,Button_h,Button_rand   : integer;
    B_size, F_size, LF_size, NF_size, LR_size : word;
    MRFSName : string[12];

    Defaults : Defaultwerte;
    DefFile : FILE of Defaultwerte;

IMPLEMENTATION

begin
B_size := sizeof(Single_IFS);
F_size := sizeof(Funktionstyp);
LF_size := sizeof(Lineare_Funktion);
NF_size := sizeof(NonLin_Funktion);
LR_size := sizeof(LRTable);
MRFSName := 'Noname.mfs';
{$I-};
assign(DefFile,'Defaults.def');
reset(DefFile);
{$I+};
if IOResult = 0 then
  read(DefFile,Defaults)
else begin
  with Defaults do begin
    with _Form do begin
      a := 0.5;
      b := 0;
      c := 0;
      d := 0.5;
      e := 0.1;
      f := 0.1;
      Winkel := 0;
      end;
    with _LFunk do begin
      a := 0.3;
      b := 0;
      c := 0;
      d := 0.3;
      e := 0;
      f := 0;
      end;
    _Funktionsart := True;        {linerare Funktion}
    _Winkel := 0.0;
    end;
  end;
{$I-};
close(DefFile);
{$I+};
end.