{$O+}
unit ifs_algo;
INTERFACE
uses crt,graph,ifs_def,mymouse,ifs_item,ifs_win,xms;

var Attraktormode : Array[1..15] of Byte;

procedure Bild_rechnen;

IMPLEMENTATION

var Bereich    : Array[1..15] of IFSPtr;
    Wahrscheinlichkeitsintervall : Array[1..15,0..15] of real;
var Startpunkt : Array[1..15] of RPunktTyp;
    LastFkt,
    Fcount     : Array[1..15] of Byte;
    CF         : Array[1..15,1..8] of Byte;

procedure Clean_Up;
var i,j : Byte;
    V : Array[1..15] of VisiRec;
begin
for i := 1 to 15 do
  V[i] := Visible[i];
for i := 1 to Anzahl_Bereiche do begin
  ArbeitsBereich := Bereich[i];
  insert_B_Poly(i);
  recalc_B_Poly(i,ArbeitsBereich^);
  with ArbeitsBereich^do
    for j := 1 to Anzahl_Fkt do
      if Funktion[j]^.Art then begin
        insert_F_Poly(i,j);
        recalc_F_Poly(i,j,Form,Funktion[j]^.LFunk^);
        end
      else begin
        insert_NF_Poly(i,j);
        recalc_NF_Poly(i,j,Form,Funktion[j]^.NFunk^);
        end;
  Bereich_auslagern(i,XmsListe);
  end;
Bereich_einlagern(Aktiver_Bereich,XmsListe);
for i := 1 to 15 do
  Visible[i] := V[i];
end;

procedure Abbilden(Ber: Byte; bx,by: double; var ax,ay: integer);
var xh,yh : double;
begin
with Bereich[Ber]^.Form do begin
  xh := (sx(bx * a + by * b + e));
  yh := (ry(sy(bx * c + by * d + f)));
  if (Abs(xh) < 32000) and (Abs(yh) < 32000) then begin
    ax := round(xh);
    ay := round(yh);
    end;
  end;
end;

procedure Feld_ermitteln(Punkt: RPunktTyp; var No: Byte; var fx,fy:double);
var i,j : Byte;
begin
if Punkt.x >= 1 then
  i := 2
else
  i := trunc(Punkt.x * 3);
if Punkt.y >= 1 then
  j := 2
else
  j := trunc(Punkt.y * 3);
No := i + 3 * j;
fx := Punkt.x - (i / 3);
fy := Punkt.y - (j / 3);
end;

procedure Get_Schnitt(Bnr,Nr,lu: Byte; dx,dy: double; var Sp: RPunktTyp);
const s = 10000;
var gp1,gp2,
    gp3,gp4,
    Tp1,tp2,
    tp3,tp4 : RPunktTyp;
    k1,k2,x,
    t1,t2,t3,
    xmin,xmax : double;
begin
dx := 3 * dx;
dy := 3 * dy;
with Bereich[Bnr]^.Funktion[nr]^ do begin
  Tp1.x := NFunk^.Punkt[lu].x;
  Tp1.y := NFunk^.Punkt[lu].y;
  Tp2.x := (NFunk^.Punkt[lu+1].x-tp1.x) * cos(Winkel) +
           (NFunk^.Punkt[lu+1].y-tp1.y) * sin(Winkel);
  Tp2.y := (NFunk^.Punkt[lu+1].x-tp1.x) * (-sin(Winkel)) +
           (NFunk^.Punkt[lu+1].y-tp1.y) * cos(Winkel);
  Tp3.x := (NFunk^.Punkt[lu+5].x-tp1.x) * cos(Winkel) +
           (NFunk^.Punkt[lu+5].y-tp1.y) * sin(Winkel);
  Tp3.y := (NFunk^.Punkt[lu+5].x-tp1.x) * (-sin(Winkel)) +
           (NFunk^.Punkt[lu+5].y-tp1.y) * cos(Winkel);
  Tp4.x := (NFunk^.Punkt[lu+4].x-tp1.x) * cos(Winkel) +
           (NFunk^.Punkt[lu+4].y-tp1.y) * sin(Winkel);
  Tp4.y := (NFunk^.Punkt[lu+4].x-tp1.x) * (-sin(Winkel)) +
           (NFunk^.Punkt[lu+4].y-tp1.y) * cos(Winkel);
  tp1.x := 0;
  tp1.y := 0;
  xmin := tp4.x - tp1.x;
  if xmin > 0 then
    xmin := 0;
  if tp3.x < tp2.x then
    xmax := tp2.x - tp1.x
  else
    xmax := tp3.x - tp1.x;
  if Abs(tp4.x - tp1.x) < 0.001 then begin
    gp1.x := tp1.x + dx * (tp4.x - tp1.x);
    gp1.y := tp1.y + dy * (tp4.y - tp1.y);
    end
  else begin
    k1 := (tp4.y - tp1.y) / (tp4.x - tp1.x);
    gp1.x := tp1.x + dy * (tp4.x - tp1.x);
    gp1.y := tp1.y + dy * (tp4.y - tp1.y);
    end;
  if Abs(tp3.x - tp2.x) < 0.001 then begin
    gp2.x := tp2.x + dx * (tp3.x - tp2.x);
    gp2.y := tp2.y + dy * (tp3.y - tp2.y);
    end
  else begin
    gp2.x := tp2.x + dy * (tp3.x - tp2.x);
    gp2.y := tp2.y + dy * (tp3.y - tp2.y);
    end;
  if Abs(tp2.y - tp1.y) < 0.001 then begin
    gp3.x := tp1.x + dx * (tp2.x - tp1.x);
    gp3.y := tp1.y + dy * (tp2.y - tp1.y);
    end
  else begin
    gp3.x := tp1.x + dx * (tp2.x - tp1.x);
    gp3.y := tp1.y + dx * (tp2.y - tp1.y);
    end;
  if Abs(tp3.y - tp4.y) < 0.001 then begin
    gp4.x := tp4.x + dx * (tp3.x - tp4.x);
    gp4.y := tp4.y + dy * (tp3.y - tp4.y);
    end
  else begin
    gp4.x := tp4.x + dx * (tp3.x - tp4.x);
    gp4.y := tp4.y + dx * (tp3.y - tp4.y);
    end;
  if lu = 2 then begin
    dx := dx;
    end;
  if (Abs(tp1.y-tp4.y) < 0.001) and (Abs(tp2.y-tp3.y) < 0.001) then begin
    k2 := (gp4.y - gp3.y) / (gp4.x - gp3.x);
    tp4.x := gp1.x - tp1.x;
    tp4.y := gp3.y + k2 * (gp1.x - gp3.x) - tp1.y;
    Sp.x := tp4.x * cos(Winkel) + tp4.y * (-sin(Winkel));
    Sp.y := tp4.x * sin(Winkel) + tp4.y * cos(Winkel);
    Exit;
    end;
  if Abs(gp2.y-gp1.y) < 0.001 then
    k1 := 0
  else
    k1 := (gp2.y*s - gp1.y*s) / (gp2.x*s - gp1.x*s);
  if (Abs(tp1.x-tp4.x) < 0.001) and (Abs(tp2.x-tp3.x) < 0.001) then begin
    tp4.x := gp3.x - tp1.x;
    tp4.y := gp1.y + k1 * (gp3.x - gp1.x) - tp1.y;
    Sp.x := tp4.x * cos(Winkel) + tp4.y * (-sin(Winkel));
    Sp.y := tp4.x * sin(Winkel) + tp4.y * cos(Winkel);
    Exit;
    end;
  if Abs(gp4.y - gp3.y) < 0.001 then
    k2 := 0
  else
    k2 := (gp4.y*s - gp3.y*s) / (gp4.x*s - gp3.x*s);
  t3 := gp3.y + k2 * (-(gp3.x-gp1.x));
  t1 := gp1.y - t3;
  t2 := k2 - k1;
  if Abs(t2) < 0.01 then
    x:= 0
  else
    x := t1 / t2;
  if (x < xmin) or (x > xmax) then begin
    tp4.x := gp1.x+(gp2.x-gp1.x)*dx{-tp1.x};
    tp4.y := gp3.y+(gp4.y-gp3.y)*dy{-tp1.y};
    end
  else begin
    tp4.x := gp1.x {- tp1.x} + x;
    tp4.y := gp1.y {- tp1.y} + k1 * x;
    end;
  Sp.x := tp4.x * cos(Winkel) + tp4.y * (-sin(Winkel));
  Sp.y := tp4.x * sin(Winkel) + tp4.y * cos(Winkel);
  end;
end;

procedure Get_Startpunkt(Ber: Byte);
var i,j,
    No  : Byte;
    x,y : double;
    Spkt: RPunktTyp;
begin
with Bereich[Ber]^.Funktion[1]^.NFunk^ do begin
  Startpunkt[Ber].x := Punkt[0].x;
  Startpunkt[Ber].y := Punkt[0].x;
  for i := 1 to 5 do begin
    Feld_ermitteln(Startpunkt[Ber],No,x,y);
    j := (No div 3) * 4 + No mod 3;
    Get_Schnitt(Ber,1,j,x,y,Spkt);
    Startpunkt[Ber].x := Punkt[j].x + Spkt.x;
    Startpunkt[Ber].y := Punkt[j].y + Spkt.y;
    end;
  end;
end;

procedure Init_Algo(var Ok: Boolean);
var i,j : Byte;
    undef : Boolean;
    temp1,
    temp2 : double;
begin
if Anzahl_Bereiche = 0 then
  Exit;
randomize;
for i := 1 to 15 do begin
  Fcount[i] := 0;
  LastFkt[i] := 0;
  end;
Ok := True;
Gib_mir_PSpeicher;
Bereich_auslagern(Aktiver_Bereich,XmsListe);
for i := 1 to Anzahl_Bereiche do begin
  Bereich_einlagern(i,XmsListe);
  Bereich[i] := ArbeitsBereich;
  j := 1;
  undef := True;
  with Bereich[i]^ do begin
    while (j < Anzahl_Fkt) and undef do begin
      if Funktion[j]^.Art then begin
        with Funktion[j]^.LFunk^ do begin
          temp1 := b * f - e * (d-1);
          temp2 := (a-1) * (d-1) - c * b;
          Startpunkt[i].x := temp1 / temp2;
          temp1 := c * e - f * (a-1);
          Startpunkt[i].y := temp1 / temp2;
          end;
        undef := False;
        end;
      Inc(j);
      end;
    end;
  if undef and (j < Bereich[i]^.Anzahl_Fkt) then begin                          { nur nichtlineare Funktionen }
    Get_Startpunkt(i);
    end;
  end;
end;

procedure Init_Wahrscheinlichkeiten;
var i,j : Byte;
begin
for i := 1 to Anzahl_Bereiche do begin
  with Bereich[i]^ do begin
    Wahrscheinlichkeitsintervall[i,0] := 0;
    for j := 1 to Anzahl_Fkt do begin
      Wahrscheinlichkeitsintervall[i,j] := Wahrscheinlichkeitsintervall[i,Pred(j)] +
                                           Funktion[j]^.Wahrscheinlichkeit;
      end;
    end;
  end;
end;

function Fkt_ok(Ber,Nr: Byte):Boolean;
var search,s1 : string;
    loc       : Byte;
    SNr,Code  : integer;
  function trim(s:string):string;
  var i:byte;
      len:byte absolute s;
      temp:string;
      z:byte absolute temp;
  begin
  z:=0;
  for i:=1 to len do begin
    if s[i]<>#32 then begin
      inc(z);
      temp[z]:=s[i]
      end
    end;
  trim:=temp
  end;
begin
if LastFkt[Ber] = 0 then begin
  Fkt_ok := True;
  LastFkt[Ber] := Nr;
  Exit;
  end;
loc := Get_Bereichspointernummer(Bereich[Ber]^.Funktion[Nr]^.Bereich);
if Bereich[loc]^.Anzahl_Fkt = 0 then begin
  Fkt_ok := False;
  Exit;
  end;
s1 := Bereich[Ber]^.Funktion[LastFkt[Ber]]^.Restriction^.LR;
search := trim(copy(s1,1,Max_LR_laenge-3));
repeat
  loc := pos(',',search);
  while loc = 1 do begin
    Delete(search,1,1);
    loc := pos(',',search);
    end;
  if loc = 0 then
    Val(search,Snr,Code)
  else
    Val(copy(search,1,Pred(loc)),Snr,Code);
  if Snr = Nr then begin
    Fkt_ok := True;
    LastFkt[Ber] := Nr;
    Exit;
    end;
  if loc = 0 then
    search := ''
  else
    Delete(search,1,loc);
until length(search) = 0;
Fkt_ok := False;
end;

function which(Ber : Byte):Byte;
var Fkt  : Byte;
    such : real;
begin
repeat
  Fkt := 1;
  such := random;
  while Wahrscheinlichkeitsintervall[Ber,Fkt] < such do
    Inc(Fkt);
  if Fkt > Bereich[Ber]^.Anzahl_Fkt then
    Fkt := Bereich[Ber]^.Anzahl_Fkt;
  which := Fkt;
until Fkt_ok(Ber,Fkt);
end;

procedure Get_Next(Ber: Byte; Fkt: Byte);
var SPunkt : RPunktTyp;
    temp1,
    temp2  : double;
    which,
    No,j   : Byte;
begin
which := Get_Bereichspointernummer(Bereich[Ber]^.Funktion[Fkt]^.Bereich);
with Startpunkt[which] do begin
  with Bereich[Ber]^.Funktion[Fkt]^ do begin
    if Art then begin
      with LFunk^ do begin
        temp1 := x*a + y*b + e;
        temp2 := x*c + y*d + f;
      end;
      if (temp1 < 32000) and (temp2 < 32000) then begin
        Startpunkt[Ber].x := temp1;
        Startpunkt[Ber].y := temp2;
        end;
      end
    else begin
      with NFunk^ do begin
        Feld_ermitteln(Startpunkt[which],No,temp1,temp2);
        j := (No div 3)*4 + No mod 3;
        Get_Schnitt(Ber,Fkt,j,temp1,temp2,SPunkt);
        Startpunkt[Ber].x := Punkt[j].x + SPunkt.x;
        Startpunkt[Ber].y := Punkt[j].y + SPunkt.y;
        end;
      end;
    end;
  end;
end;

function Get_Farbe(Ber,Fkt: Byte): Byte;
var i,j : Byte;
    Farbe,
    gewicht : real;
    temp : integer;
begin
if Fcount[Ber] < 8 then begin
  Inc(Fcount[Ber]);
  CF[Ber,Fcount[Ber]] := Bereich[Ber]^.Funktion[Fkt]^.Farbe - 64;
  end
else begin
  for i := 1 to 7 do
    CF[Ber,i] := CF[Ber,Succ(i)];
  CF[Ber,8] := Bereich[Ber]^.Funktion[Fkt]^.Farbe - 64;
  end;
gewicht := 0;
Farbe := 0;
for i := 1 to Fcount[Ber] do begin
  temp := CF[Ber,i]-CF[Ber,Fcount[Ber]];
  if temp >= 96 then
    temp := - 192 + temp;
  if temp <= -96 then
    temp := 192 + temp;
  Farbe := Farbe + temp * exp(Pred(i)*ln(2));
  gewicht := gewicht + exp(Pred(i)*ln(2));
  end;
temp := round(Farbe / gewicht);
j := 64+(192+CF[Ber,Fcount[Ber]]+round(Farbe/gewicht)) mod 192;
Get_Farbe := 64+(192+CF[Ber,Fcount[Ber]]+round(Farbe/gewicht)) mod 192;
end;

procedure Bild_rechnen;
var ok  : Boolean;
    i,j : Byte;
    Bildx,
    Bildy : integer;
begin
if Anzahl_Bereiche = 0 then
  Exit;
if not AttraktorFlag then begin
  Init_Algo(ok);
  if not ok then
    Exit;
  Init_Wahrscheinlichkeiten;
  AttraktorFlag := True;
  end
else begin
  Gib_mir_PSpeicher;
  Bereich_auslagern(Aktiver_Bereich,XmsListe);
  for i := 1 to Anzahl_Bereiche do begin
    Bereich_einlagern(i,XmsListe);
    Bereich[i] := ArbeitsBereich;
    end;
  end;
i := 0;
j := 0;
repeat
  Inc(j);
  Inc(i,Bereich[j]^.Anzahl_Fkt);
until (i <> 0) or (j = Anzahl_Bereiche);
if i <= 1 then begin
  Clean_Up;
  Exit;
  end;
repeat
  Mouse_bewegen;
  for i := 1 to Anzahl_Bereiche do begin
    if Bereich[i]^.Anzahl_Fkt > 0 then begin
      j := which(i);
      Get_Next(i,j);
      with Startpunkt[i] do
        Abbilden(i,x,y,Bildx,Bildy);
      SetViewPort(GraphWin_x,Menue_y,x,y-Lineal_b,True);
      case Attraktormode[i] of
        0 : begin {nicht anzeigen} end;
        1 : PutPixel(Bildx-scroll_x,Bildy+scroll_y,
                     Bereich[i]^.Funktion[j]^.Farbe);
        2 : PutPixel(Bildx-scroll_x,Bildy+scroll_y,Get_Farbe(i,j));
        end;
      SetViewPort(0,0,x,y,True);
      end;
    end;
until ButtonPressed;
Clean_Up;
end;

var i : Byte;
begin
for i := 1 to 15 do
  Attraktormode[i] := 2;
end.