#include "init.h"

void  InitAll(notAll)
int notAll;
/*
ͻ
 Initalisierung aller globalen Variablen.                               
͹
                                                                        
 Eingabeparameter:     notAll ..  0 normal, 1 Datei nicht initialisieren
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    alle (Initialisierung)                           
                                                                        
ͼ
*/
{
	int i;

	// Attraktorstruktur wird mit Defaultwerten gefllt
	Attraktor.anz_stpkte=1;
	Attraktor.n=1000;
	for(i=0; i<10; i++) {
		Attraktor.min[i]=-1;
		Attraktor.max[i]=+1;
	}
	InitMemory();
	Koordinaten[KOORMAX].index = FORMELMAX;
	Koordinaten[KOORMAX].var = ' ';
	Koordinaten[KOORMAX].tree = NULL;
	for(i=0;i<10;i++) {
		 Koordinaten[i].index=-1;
		 Koordinaten[i].tree=NULL;
	}
	InitAlleFormeln();
	AlleFormeln[FORMELMAX][0]=0;
	Direkt = 1;
	Orbit2 = 0;
	Orbit3 = 0;
	Quelle = FORMEL;
	Kreuz=1;
	InitList();
	error_code=0;
	anzKoor=0;
	Slow = 50;
	RelMulFaktor = 0.1;
	AchsenRot = 75;
	cx=0; cy=0;
	inserttoggle=0;
	c_up_down=0;
	cursorindex=0;
	editindex=0;
	editfield1=0;
	strcpy(editstring,"");

	/******** Fenster und Status */
	AktivFenster=1;
	for(i=1; i<6; i++) {      // HALT, nicht nulltes Fenster freigeben!!!
		 switch(Fenster[i].what) { /* vorherigen Speicher wieder frei geben */
				case NOTHING:			break;
				case K_BIFURKATION: 	if(Fenster[i].bif)
												free(Fenster[i].bif);
												Fenster[i].bif = NULL;
											break;
				case K_2DATTR:
				case K_2DATTRZ:  		if(Fenster[i].attr2D)
												free(Fenster[i].attr2D);
												Fenster[i].attr2D = NULL;
											break;
				case K_3DATTR:
				case K_3DATTRZ:  		if(Fenster[i].attr3D)
												free(Fenster[i].attr3D);
												Fenster[i].attr3D = NULL;
											break;
				case K_POINCAREZ:
				case K_POINCARE: 		if(Fenster[i].poinc)
												free(Fenster[i].poinc);
												Fenster[i].poinc = NULL;
											break;
		 }
		 Fenster[i].what=NOTHING;
	}
	// Fensterbeschriftung entfernen, Buttons zurcksetzen
	strcpy(Fenster1[1].name, "");
	for(i=0; i<2; i++)  strcpy(Fenster2[i+2].name, "");
	for(i=0; i<3; i++) {
		 strcpy(Fenster3[i+3].name, "");
		 M_Fenster[i].pressed=0;
		 M_Orbit2[i].pressed=0;
	}
	// Orbiteinstellung lschen
	for(i=0; i<4; i++) {
			 M_Orbit3[i].pressed=0;
	}
	// Defaultwerte einstellen
	WindowStatus=2;
	M_Fenster[WindowStatus-1].pressed= 1;
	Fenster2[2].pressed = 1;
	Fenster2[3].pressed = 0;
	for(i=4; i<6; i++) Fenster3[i].pressed = 0;
	Fenster3[3].pressed = 1;
	M_Orbit2[Orbit2].pressed       = 1;
	M_Orbit3[Orbit3].pressed       = 1;
	DLG_Formel[30].pressed         = !Direkt;
	K_3DAttr[9].pressed            = Kreuz;
	OldStatus = Status = MENUELEISTE|FENSTER2;

	/******** Formel modifizieren */
	Modi.topformel=0;
	Modi.akt_stpkt=1;

	/******** Datei handling */
	if(!notAll) {
		for(i=0; i<4; i++) {
			 DLG_Datei[9+i].pressed=0;
		}
		for(i=0; i<DATEIANZ; i++) Datei.filelist[i][0]=0;
		strcpy(Datei.filename, "");
		Datei.path[0]=0;
		Datei.what=SPZ;
		DLG_Datei[10].pressed = 1;
	}
}

int  NewStatus(what)
int what;
/*
ͻ
 Liefert nach einer Vernderung den neuen Status zurck.                
͹
                                                                        
 Eingabeparameter:     what    (alter Status)                           
 Ausgabeparameter:     keine                                            
 Returnwerte:          neuer Status des Programmes                      
 globale Variablen:    WindowStatus (Status der Fenster)                
                                                                        
ͼ
*/
{
	int stat;

	stat = MENUELEISTE|what;
	switch(WindowStatus) {
		case 1: stat|=FENSTER1; break;
		case 2: stat|=FENSTER2; break;
		case 3: stat|=FENSTER3; break;
	}
	return(stat);
}


int  CheckKey(key)
int key;
/*
ͻ
 berprft ob eine gltige Taste bettigt wurde. Gltige Tasten sind    
 alle alphanumerischen Zeichen, sowie Zeichen, die fr die Formeldar-   
 stellung und Dateipfadangaben (z.B. "\") notwendig sind.               
͹
                                                                        
 Eingabeparameter:     key   (zu berprfendes Zeichen)                 
 Ausgabeparameter:     keine                                            
 Returnwerte:          TRUE  (Zeichen ist gltig)                       
                       FALSE (Zeichen ist ungltig)                     
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{
	if(isalnum(key)) return(TRUE);
	switch(key)
	{
		case '_':
		case '(':
		case ')':
		case 94 :
		case ' ':
		case ':':
		case '\\':
		case '?':
		case '.':
		case ',':
		case '+':
		case '-':
		case '*':
		case '/':
		case '=':
		case '\'': return(TRUE);
		default: return(FALSE);
	}
}

void  EditField(key, pos, string, max, min_id, max_id, minindex)
int key, max,min_id, max_id, minindex;
struct box *pos;
char *string;
/*
ͻ
  Funktion zum editieren der Eingabefelder mit Bercksichtigung der     
  Cursortasten, des Tabulators, Backspace, Delete, Pos1 und Ende.       
  Auerdem wird bei Bedarf der Inhalt des Feldes nach links bzw.rechts  
  gescrollt.                                                            
͹
                                                                        
 Eingabeparameter:     key       (zu verarbeitendes Zeichen)            
                       pos       (Zeiger auf ein Eingabefeld)           
                       string    (zu editierender String)               
                       max       (                                      
 Ausgabeparameter:     keine                                            
 Returnwerte:          TRUE  (Zeichen ist gltig)                       
                       FALSE (Zeichen ist ungltig)                     
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{
	int len, dummy;
	char *newstring=0;

	len=((pos->x2-1) - (pos->x1+4))/8 +1;
	// Auswertung des Tastendrucks
	switch(key)
	{                  // Cursor links
			case C_LEFT: if(((editindex-minindex)==cursorindex) && cursorindex) cursorindex-=1;
								 if(editindex>minindex) editindex-=1;
							 break;
							 // Cursor rechts
			case C_RIGHT:if(editindex<max && editindex<strlen(string)) editindex+=1;
								 if((editindex==(cursorindex+len)) && cursorindex<max) cursorindex+=1;
							 break;
							 // Cursor rauf
			case C_UP:   if(editfield1==min_id) c_up_down=max_id;
								 else c_up_down=editfield1-1;
								 if(Status==DLG_DATEI) InitDatei(0);
							 break;
							 // Enter bzw. Return
			case ENTER:  editfield1=0;
								 if(Status==DLG_DATEI) InitDatei(0);
							 break;
							 // Cursor runter und Tabultor
			case TAB:
			case C_DOWN: if(editfield1==max_id) c_up_down=min_id;
								 else c_up_down=editfield1+1;
							 if(Status==DLG_DATEI) InitDatei(0);
							 break;
							 // Pos1 .. Sprung zum Zeilenanfang
			case POS1:   editindex=minindex;
							 cursorindex=0;
							 break;
							 // Ende .. Sprung zum Zeilenende
			case END:    editindex=strlen(string);
							 cursorindex=strlen(string)-len+1;
							 if(cursorindex<0) cursorindex=0;
							 break;
							 // Backspace
			case BS:     strcpy(newstring,&string[editindex]);
							 if((editindex-minindex)==cursorindex && cursorindex) cursorindex-=1;
							 if(editindex>minindex) editindex-=1;
							 strcpy(&string[editindex],newstring);
							 break;
							 // Delete
			case DEL:    strcpy(newstring,&string[editindex+1]);
							 strcpy(&string[editindex],newstring);
							 break;
							 // Insert .. Insertmode ein bzw. aus
			case INS:    if(inserttoggle) inserttoggle=FALSE;
							 else inserttoggle=TRUE;
							 PrintStatus("");
							 break;
							 // Escape .. Restaurieren des Feldinhaltes
			case ESCAPE: strcpy(string,editstring);
							 editindex=cursorindex=0;
							 editfield1=0;
							 break;
							 // Sonst irgendein Buchstabe
			default:     key&=0xff;
							 if(CheckKey(key))
							 {
								 if(editindex<max)
								 {
										// Grobuchstaben klein machen
										if(isalnum(key)) key=tolower(key);
										// Insertmode bercksichtigen
										if(inserttoggle && ((editindex+1+strlen(newstring))<FORMELLEN-10))
										{
											strcpy(newstring,&string[editindex]);
											strcpy(&string[editindex+1], newstring);
										}
										dummy=strlen(string)+1;
										editindex+=1;
										string[editindex-1]=key;
										if(dummy==editindex) string[editindex]=0;
								 }
								 if((editindex==(cursorindex+len)) && cursorindex<max) cursorindex+=1;
							 }
							 break;
	} /* switch */
	// Neuen Inhalt ausgeben
	DrawStr(pos, &string[cursorindex], 0);
	if(editfield1) DrawCursor(pos->x1+2+(editindex-cursorindex)*8,pos->y1+4, EGA_LIGHTRED);
	Attraktor.modified=1;
}


// Zeichnen des Cursors an der angegeben Position und Farbe
// Globale Variablen: cx, cy .. enthalten die aktuelle Cursorposition
void  DrawCursor(x,y,color)
int x,y,color;
{
	// Cursor an alten Position lschen
	setcolor(EGA_WHITE);
	line(cx+2,cy,cx+2,cy+12);
	// Cursor an neuen Position zeichnen
	setcolor(color);
	line(x+2,y,x+2,y+12);
	cx=x; cy=y;
}

// Berechnen neuer Formelbume. Zuvor wird der dafr notwendige
// Speicherbereich neu initialisiert. Die Konstantenbelegung wird
// gelscht.
// Globale Variablen: Koordinaten .. nimmt neuen Bume auf
int  NewTrees()
{
		int i, bool=0;
		InitList();
		InitMemory();       /* Formelspeicher initialisieren */
		for(i=0;i<anzKoor;i++) {
				if((Koordinaten[i].tree=MakeTree(AlleFormeln[Koordinaten[i].index]))==0)
					bool=1;
		}
		return(bool);
}


// Die globale Variable AlleFormeln wird mit einigen interessanten
// Formeln initialisiert.

void  InitAlleFormeln()
{
	 strcpy(AlleFormeln[0],"x=x*(1+k*(1-x))");
	 strcpy(AlleFormeln[1],"x=y+1-a*x^2");
	 strcpy(AlleFormeln[2],"y=x*b");
	 strcpy(AlleFormeln[3],"x'=-y-z");
	 strcpy(AlleFormeln[4],"y'=x+a*y");
	 strcpy(AlleFormeln[5],"z'=b+z*(x-c)");
}



// Interaktiver Wechsel der Koordinatenbelegung
// Automatisches bernehmen einer neuen Formel nach Angabe des
// ersten Zeichens (=Variable)
void  CheckFormel(key,koor,box)
int key, *koor;
struct box *box;
{
	 int dummy;
	 char s[2];

	 s[1]=0;
	 // Keine nderung, wenn nicht erstes Zeichen editiert wird,
	 // bzw. wenn im Insertmode gearbeitet wird.
	 if(editindex==1 && inserttoggle==FALSE) {
			if(is_var(key)) AlleFormeln[Koordinaten[*koor].index][0]=Koordinaten[*koor].var;
			else {
				// Formelarray erneuern und neue Formel ausgeben
				AlleFormeln[Koordinaten[*koor].index][0]=editstring[0];
				DrawStr(box, AlleFormeln[Koordinaten[*koor].index],1);
			}
			if((dummy=GetIndex(key))>=0) {
				 //Schreibe andere Formel in Editfield
				 DrawStr(box, AlleFormeln[Koordinaten[dummy].index],1);
				 *koor=dummy;
				 strcpy(editstring, AlleFormeln[Koordinaten[dummy].index]);
				 // Korrigiere Startwertbeschriftung
				 DrawStartwert(Fenster[AktivFenster].what);
				 // Korrigiere Translationsbuttonbeschriftung 2D-Attr
				 if(Fenster[AktivFenster].what==K_2DATTR) {
					s[0] = editstring[0];
					strcpy(K_2DAttr[editfield1-36].name, s);
					Dbutton(&K_2DAttr[editfield1-36]);
				 }
				 // Korrigiere Translationsbuttonbeschriftung Bifurkation
				 if(Fenster[AktivFenster].what==K_BIFURKATION) {
					s[0] = editstring[0];
					strcpy(K_Bifurkation[14].name, s);
					Dbutton(&K_Bifurkation[14]);
				 }

			}
		}
}


// Namen des Darstellungsmodes feststellen

char  *WhatTable(what)
int what;
{
	// Entsprechende Bezeichnung wird zurckgegeben
	switch(what) {
		case K_BIFURKATION: return("Bifurkation");
		case K_2DATTR:
		case K_2DATTRZ:     return("2D-Attraktor");
		case K_3DATTR:
		case K_3DATTRZ:     return("3D-Attraktor");
		case K_POINCAREZ:
		case K_POINCARE:    return("Poincare");
		default: return("");
	}
}


// Berechnung der neuen Grenzen bei der Auswahl eines Teilbereches mit
// der Maus. Die neuen Werte werden direkt in die korrespondierenden
// Strukturen eingetragen.

void  NeueGrenzen(mp,box,kmin,kmax,ymin,ymax)
int *mp;            // ausgewhlte Rechteck in Bildschirmkoordinaten
struct box *box;    // Fensterkoordinaten in dem gearbeitet wird
double *kmin, *kmax, *ymin, *ymax;   // alten Werte
{
		double stepx, stepy;
		int dummy;

		// vertikale Spiegelung - oben soll es nach positiv unendlich gehen
		dummy = mp[3];
		mp[3] = box->y2 - (mp[1]-box->y1);
		mp[1] = box->y1 + (box->y2-dummy);

		// Berechnung des Ausschnitts
		stepx=(*kmax-*kmin)/(box->x2-box->x1);
		*kmin=*kmin+(mp[0]-box->x1)*stepx;
		*kmax=*kmin+(mp[2]-mp[0])*stepx;    /**kmax-(box->x2-7-mp[2])*stepx; */
		stepy=(*ymax-*ymin)/(box->y2-box->y1);
		*ymin=*ymin+(mp[1]-box->y1)*stepy;
		*ymax=*ymin+(mp[3]-mp[1])*stepy;    /*ymax-(box->y2-7-mp[3])*stepy;*/
}


// Restaurieren eines Bildschirmbereiches, der aufgrund eines
// Pulldownmenues oder einer Dialogbox zuvor berzeichnet worden
// ist.

void  PutPicture(bufx, bufy)
int bufx, bufy;
{
		// Ist der alte Inhalt gespeichert worden?
		if(menuebuffer) {
			 putimage(bufx, bufy, menuebuffer, COPY_PUT);
			 free((char *) menuebuffer);
			 menuebuffer=NULL;
		}
		// Nein, also leere Fenster drbermalen
		else {
			 Window(WindowStatus);
			 DrawButtons(MENUELEISTE);
		}
}

int Hotkey(key)
int key;
/*
ͻ
 berprft, ob der bergebene Tastendruck ein Hotkey war. Falls es ein  
 Hotkey war, wird der dem Hotkey entsprechende Mausclick simuliert,     
 indem der Button zurckgeliefert wird.                                 
͹
                                                                        
 Eingabeparameter:     key  (bettigte Taste)                           
 Ausgabeparameter:     keine                                            
 Returnwerte:          dem Hotkey entsprechender Button                 
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{

	switch(key)
	{
		case ALT_l:
		case ALT_s:
			return(6);	/* Datei laden/speichern */
		case ALT_f:
			return(2);  /* Formeldialogbox       */
		case ALT_x:    /* Programm beenden      */
			return(10);
		default:
			break;
	}
	return(FALSE);
}


void ClipLine(x1,y1,x2,y2,box)
int x1,y1,x2,y2;
struct box *box;
/*
ͻ
 Fhrt Clipping einer Linie innerhalb eines vorgegebenen rechteckigen   
 Bereiches durch.                                                       
͹
                                                                        
 Eingabeparameter:     x1 (x-Koordinate des Anfangspunktes der Linie)   
                       y1 (y-Koordinate des Anfangspunktes der Linie)   
                       x2 (x-Koordinate des Endpunktes der Linie)       
                       y2 (y-Koordinate des Endpunktes der Linie)       
								box (Zeiger auf rechteckigen Bereich)            
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{
	char c1=0,c2=0;
	int x, y;
	int x11=box->x1+7;
	int y11=box->y1+7;
	int x22=box->x2-7;
	int y22=box->y2-7;

	if(((x1-x2)==1) || ((x2-x1)==1)) x1=x2;
	if(((y1-y2)==1) || ((y2-y1)==1)) y1=y2;
	if(x1<x11) c1=1; else if(x1>x22) c1=4;
	if(y1<y11) c1=c1|8; else if(y1>y22) c1=c1|2;
	if(x2<x11) c2=1; else if(x2>x22) c2=4;
	if(y2<y11) c2=c2|8; else if(y2>y22) c2=c2|2;
	if((c1||c2)&&!(c1&c2))
	{
		  x = (x1+x2) >> 1;
		  y = (y1+y2) >> 1;
		  ClipLine(x1, y1, x, y, box);
		  ClipLine(x, y, x2, y2, box);
	 }
	 else
		if(!(c1&c2))
			line(x1, y1, x2, y2);
}

int Berechne(Punkte)
double *Punkte;
/*
ͻ
 Berechnet einen 'anzKoor'-dimensionalen Punkt, wobei 'anzKoor' die     
 Anzahl der aktuell verwendeten Koordinaten ist.                        
͹
                                                                        
 Eingabeparameter:     Punkte (Zeiger auf ein Array von Punkten)        
 Ausgabeparameter:     keine                                            
 Returnwerte:          1  Fehler in der Berechnung                      
                       0  kein Fehler bei der Berechnung                
 globale Variablen:    Koordinaten (verwendete Koordinaten + Bume)     
                       anzKoor (Anzahl der verwendeten Koordinaten)     
                       var_const_list (Liste der verwendeten Koor-      
                                       dinaten und Konstanten)          
                       AlleFormeln (verfgbare Formeln)                 
                       error_code (globales Fehlerflag)                 
                       RelMulFaktor (relativer Multiplikationsfaktor    
                                     bei Iterationsschritt)             
                                                                        
ͼ
*/
{
	 int i;

	 for(i=0; i<anzKoor; i++)
		  var_const_list[Koordinaten[i].var-97].fvalue=Punkte[i];

	 if(AlleFormeln[Koordinaten[0].index][1]!='\'') {
		// absolute Formelberechnung (x=..)
		for(i=0; i<anzKoor; i++) {
			Punkte[i]=Eval(Koordinaten[i].tree);
			if(error_code) break;
		}
	 }
	 else {
		// relative Formelberechnung (x'=..)
		for(i=0; i<anzKoor; i++) {
			Punkte[i]=Punkte[i]+RelMulFaktor*Eval(Koordinaten[i].tree);
			if(error_code) break;
		}
	 }

	 // Sollte ein Fehler aufgetreten sein abrechen!
	 if(error_code)
	 {
		error_code=0;
		return(1);
	 }
	 else
		return(0);
}


void AddStartwert()
/*
ͻ
 Fgt einen Startwert zur Liste der bisherigen Startwerte dazu, bei     
 mehr als acht Startwerten erfolgt eine Fehlermeldung.                  
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:                                                     
                                                                        
ͼ
*/
{
	 int i;
	 int anz;

	 if(Status==DLG_FORMEL) {
		// Befinden uns in der Formeldialogbox
		anz = Modi.anz_stpkte;
		if(anz==8) PrintStatus("Kann keine weiteren Startwerte aufnehmen!");
		else {
			Modi.anz_stpkte+=1;
			Modi.akt_stpkt = Modi.anz_stpkte;
			for(i=anz*10; i<(anz+1)*10; i++) Modi.stpkte[i]=0.0;
		}
	 }
	 else {
		// Abarbeitung der Startwertfelder in einer Kommandozeilen.
		anz = Attraktor.anz_stpkte;
		if (anz==8) PrintStatus("Kann keine weiteren Startwerte aufnehmen!");
		else {
			Attraktor.anz_stpkte+=1;
			Attraktor.modified = 1;
			if(Fenster[AktivFenster].what==K_2DATTR) Fenster[AktivFenster].attr2D->akt_stpkt=Attraktor.anz_stpkte;
			if(Fenster[AktivFenster].what==K_3DATTR) Fenster[AktivFenster].attr3D->akt_stpkt=Attraktor.anz_stpkte;
			for(i=anz*anzKoor; i<(anz+1)*anzKoor; i++) Attraktor.stpkte[i]=0.0;
		}
	 }
}

void  DelStartwert(num)       /* num in [1..8] */
/*
ͻ
  Entferne den Startwert num.		                                     
  Fehlermeldung, wenn keine Startwerte vorhanden.                   	 
ͼ
*/
int num;
{
		int i;
		int anz;
		if(Status==DLG_FORMEL) anz = Modi.anz_stpkte;
		else anz = Attraktor.anz_stpkte;

		if (anz<2) PrintStatus("Kein Startwert entfernt!");
		else {
				if(Status==DLG_FORMEL) {
					if(Modi.akt_stpkt==anz)  Modi.akt_stpkt-=1;}
				else {
					if(Fenster[AktivFenster].what==K_2DATTR)
							if(Fenster[AktivFenster].attr2D->akt_stpkt==anz) Fenster[AktivFenster].attr2D->akt_stpkt-=1;
					if(Fenster[AktivFenster].what==K_3DATTR)
							if(Fenster[AktivFenster].attr3D->akt_stpkt==anz) Fenster[AktivFenster].attr3D->akt_stpkt-=1;
				}
				if(Status==DLG_FORMEL) {
					// Startwert aus Formeldialogbox entfernen
					Modi.anz_stpkte-=1;
					for(i=num*10; i<anz*10; i++)
						 Modi.stpkte[i-10]=Modi.stpkte[i];
				}
				else {
					// Startwert aus einer Kommandozentrale entfernen
					Attraktor.anz_stpkte-=1;
					Attraktor.modified = 1;
					for(i=num*anzKoor;  i<anz*anzKoor ; i++)
						 Attraktor.stpkte[i-anzKoor]=Attraktor.stpkte[i];
				}
	 }
}


// Mit dieser Funktion wird das aktive Formelfeld in der
// Formeldialogbox gelscht.
void  DelFormel()
{
		// Variable mit Formel und Editierfeld lschen
		NewAlleFormeln[editfield1-106+Modi.topformel][0]=0;
		Rechteck(&DLG_Formel[editfield1-105].box);
		DrawCursor(cx, cy, EGA_LIGHTRED);
}


// Suche in der Liste aller Formeln (AlleFormeln[][]) einen
// leeren Platz zum Hinzufgen einer neuen Formel, und positioniere
// dort den Cursor.

void AddFormel()
{
		int i=0;

		while(NewAlleFormeln[i++][0]);
		Modi.topformel=i-1;
		DrawFormel();
		DrawCursor(cx, cy, EGA_LIGHTRED);
		c_up_down=106;
}


// Lsche den Inhalt des angegebenen Fenster und setze die Inhalte
// der dazugehrigen Variablen zurck.

void  KillFenster(number)
int number;
{
	int old;
	struct button *button;

		// Speicher fr die Fensterstruktur wieder freigeben
		switch(Fenster[number].what) {
			case K_BIFURKATION: 	free(Fenster[number].bif);
										Fenster[number].bif = NULL;
										break;
			case K_2DATTR:
			case K_2DATTRZ:     	free(Fenster[number].attr2D);
										Fenster[number].attr2D = NULL;
										break;
			case K_3DATTR:
			case K_3DATTRZ:     	free(Fenster[number].attr3D);
										Fenster[number].attr3D = NULL;
										break;
			case K_POINCAREZ:
			case K_POINCARE:    	free(Fenster[number].poinc);
										Fenster[number].poinc = NULL;
										break;
			default: break;
		}
		old = AktivFenster;
		AktivFenster=number;
		button = WhatWindowButton();
		AktivFenster = old;
		strcpy(button->name, "");           // Beschriftung
		Fenster[number].what=NOTHING;       // als leer deklarieren
}



int  CheckModi()
/*
ͻ
 berprfung aller Eintrge in der Formeldialogbox und Ausgabe einer    
 Fehlermeldung bei inkorrekten Angaben.                                 
͹
                                                                        
 Eingabeparameter:    keine                                             
 Ausgabeparameter:    keine                                             
 Returnwerte:         TRUE, wenn alles in Ordnung                       
							  FALSE, mindestens ein Eintrag ist falsch          
 globale Variablen:   anzKoor  ..  wird neu gesetzt                     
                      NewKoordinaten .. Baumstruktur wird neu berechnet 
                                                                        
ͼ
*/
{
	int anz=0, i,j , aus=0, stop=0, absolut=0;

	InitList();     /* Variablenliste initialisieren */
	InitMemory();   /* Formelspeicher initialisieren */

	// berprfen aller markierten Formeln
	for(i=0;i<10;i++) {
		if(NewKoordinaten[i].index!=-1) {
			 anz++;
			 // Berechnung der Trees
			 if(!(NewKoordinaten[i].tree = MakeTree(NewAlleFormeln[NewKoordinaten[i].index])))
					stop=2;
			 NewKoordinaten[i].var=NewAlleFormeln[NewKoordinaten[i].index][0];
			 if(aus) stop=1;
		}
		else aus=1;
	}

	anzKoor = anz;

	// Prfe, ob nur unterschiedliche Koordinaten .
	if(stop==0 && anz>1)
			for(i=1; i<anz; i++)
					for(j=0; j<i; j++)
							if(NewKoordinaten[i].var==NewKoordinaten[j].var) stop=4;

	// Prfe, ob einheitlich absolut bzw. relativ
	for(i=0; i<anz && stop==0; i++)
			if(NewAlleFormeln[NewKoordinaten[i].index][1]=='=') {
				 if(absolut==-1) stop=5;
				 else absolut=1;
			}
			else {
				if(absolut==1) stop=5;
				else absolut=-1;
			}

	// Lschen jener Fensterinhalte, die aufgrund einer neuen Koordinaten-
	// belegung nicht mehr aktuell sind.
	if(stop==0) for(i=1; i<6; i++) {
		switch(Fenster[i].what) {
			case K_BIFURKATION: if(anz<1) {KillFenster(i); stop=3;}
									  break;
			case K_2DATTR:      if(anz<2) {KillFenster(i); stop=3;}
									  else Fenster[i].attr2D->akt_stpkt=1;
									  break;
			case K_3DATTR:      Fenster[i].attr3D->akt_stpkt=1;
			case K_POINCARE:    if(anz<3) {KillFenster(i); stop=3;}
									  break;
		}
	}

	// Ausgeben einer Fehlermeldung, fall notwendig
	switch(stop) {
		case 1: PrintStatus("Koordinatenbelegung ist nicht richtig !");
				  return(FALSE);
		case 2: PrintStatus("Formelsyntax inkorrekt!");
				  return(FALSE);
		case 3: PrintStatus("Fensterinhalte korrespondierten nicht mit Formelbelegung");
				  return(TRUE);
		case 4: PrintStatus("Bitte verwenden Sie nur Formeln mit unterschiedlichen Variablen!");
				  return(FALSE);
		case 5: PrintStatus("Bitte entscheiden Sie sich fr absolute bzw. relative Formeln!");
				  return(FALSE);
		default:return(TRUE);
	}
}


// Initialisierung der Grafikkarte und Ausgabe einer Fehlermeldung,
// wenn kein Grafiktreiber gefunden werden konnte.

void  Initialize1(void)
{
	int GraphDriver;
	int GraphMode;		/* The Graphics mode value		*/
	int ErrorCode;		/* Reports any graphics errors		*/

  GraphDriver = DETECT; 		/* Request auto-detection	*/
  initgraph( &GraphDriver, &GraphMode, "" );
  ErrorCode = graphresult();		/* Read result of initialization*/
  if( ErrorCode != grOk ){		/* Error occured during init	*/
	 printf(" Graphics System Error: %s\n", grapherrormsg( ErrorCode ) );
	 exit( 1 );
	}
}
