#include "init.h"

/***************************************************************/
/*                                                             */
/*       3-dimensionale Darstellung eines Attraktors           */
/*                                                             */
/***************************************************************/

struct attraktor3D  *Init3DAttraktor()
{
	 int i;
	 struct attraktor3D *attr3D;

	 if(Quelle==FORMEL && anzKoor<3) return(0L);
	 attr3D=malloc(sizeof(struct attraktor3D));
	 attr3D->init   = 1;
	 for(i=0; i<16; i++)  attr3D->Matrix[i]=0.0;
	 for(i=0; i<16; i+=5) attr3D->Matrix[i]=1.0;
	 attr3D->transx = 0.0;
	 attr3D->transy = 0.0;
	 attr3D->transz = 0.0;
	 attr3D->skal   = 1.0;
	 attr3D->koor1  = 0;
	 attr3D->koor2  = 1;
	 attr3D->koor3  = 2;
	 attr3D->top    = 0;
	 attr3D->akt_stpkt = 1;
	 attr3D->modified = 1;
	 attr3D->stwertx = 0;
	 attr3D->stwerty = 1;
	 attr3D->stwertz = 2;
	 attr3D->sweite  = 3;
	 Skalierung(attr3D, 11.0);
	 Rotation(attr3D, 'y', 3.1415926);
	 Rotation(attr3D, 'z', 3.1415926);
	 return(attr3D);
}

void  Perspektive(attr3D)
struct attraktor3D *attr3D;
{
	 int i;
	 double *Matrix;
	 Matrix = attr3D->Matrix;

	 for(i=0; i<16; i++)  PMatrix[i] =  Matrix[i];
	 for(i=3; i<16; i+=4) PMatrix[i] =  Matrix[i-1]/2500 + Matrix[i];
}

void  Transform(x, y, z, x1, y1)
double x, y, z, *x1, *y1;
{
	 double rest;
	 rest=x*PMatrix[3]+y*PMatrix[7]+z*PMatrix[11]+PMatrix[15];
	 if(rest==0.0) {
		 PrintStatus("Division durch Null!! - Arbeite weiter.");
		 rest=1.0;
	 }
	 *x1=(x*PMatrix[0]+y*PMatrix[4]+z*PMatrix[8]+PMatrix[12])/rest;
	 *y1=(x*PMatrix[1]+y*PMatrix[5]+z*PMatrix[9]+PMatrix[13])/rest;
}

void  KoordinatenKreuz(attr3D, color, box)
int color;
struct box *box;
struct attraktor3D *attr3D;
{
	 double x1,y1,x2,y2;
	 int i, xa,ya,xb,yb;
	 int xoffs = (box->x2+box->x1)/2;
	 int yoffs = (box->y2+box->y1)/2;
	 char s[6];

	 if(Quelle==FORMEL) {
		s[0] = Koordinaten[attr3D->koor1].var; s[1] = 0;
		s[2] = Koordinaten[attr3D->koor2].var; s[3] = 0;
		s[4] = Koordinaten[attr3D->koor3].var; s[5] = 0;
	 }
	 else {
		s[0] = 'x';
		s[1] = 0;
		s[2] = 'y';
		s[3] = 0;
		s[4] = 'z';
		s[5] = 0;
	 }

	 if(Kreuz) {   /* Kein Koordinatenkreuz ! */
		Perspektive(attr3D);
		setcolor(color);
		for(i=0;i<18;i+=6) {
		  Transform(WKPunkte[i], WKPunkte[i+1], WKPunkte[i+2], &x1, &y1);
		  xa=(int)(x1)+xoffs; ya=(int)(y1)+yoffs;
		  Transform(WKPunkte[i+3], WKPunkte[i+4], WKPunkte[i+5], &x2, &y2);
		  xb=(int)(x2)+xoffs; yb=(int)(y2)+yoffs;
		  ClipLine(xa, ya, xb, yb, box);
		  if( (xb>box->x1+15) && (xb<box->x2-15) &&
				(yb>box->y1+15) && (yb<box->y2-15))
				outtextxy(xb, yb, s+i/3);
		}
	 }
}


void  Rotation(attr3D, richtung, winkel)
struct attraktor3D *attr3D;
char richtung;
double winkel;
{
	 double s=sin(winkel),c=cos(winkel),m1,m2,m3,m4;
	 double tx = attr3D->transx;
	 double ty = attr3D->transy;
	 double tz = attr3D->transz;
	 double *Matrix;
	 Matrix = attr3D->Matrix;

	 Translation(attr3D, -tx, -ty, -tz);
	 switch(richtung) {
		  case 'x': m1=Matrix[1]; m2=Matrix[5];
						m3=Matrix[9]; m4=Matrix[13];
						Matrix[1]  = c * m1 - s * Matrix[2];
						Matrix[5]  = c * m2 - s * Matrix[6];
						Matrix[9]  = c * m3 - s * Matrix[10];
						Matrix[13] = c * m4 - s * Matrix[14];
						Matrix[2]  = c * Matrix[2]  + s * m1;
						Matrix[6]  = c * Matrix[6]  + s * m2;
						Matrix[10] = c * Matrix[10] + s * m3;
						Matrix[14] = c * Matrix[14] + s * m4;
						break;
		  case 'y': m1=Matrix[0]; m2=Matrix[4];
						m3=Matrix[8]; m4=Matrix[12];
						Matrix[0]  = c * m1 + s * Matrix[2];
						Matrix[4]  = c * m2 + s * Matrix[6];
						Matrix[8]  = c * m3 + s * Matrix[10];
						Matrix[12] = c * m4 + s * Matrix[14];
						Matrix[2]  = c * Matrix[2] - s * m1;
						Matrix[6]  = c * Matrix[6] - s * m2;
						Matrix[10] = c * Matrix[10] - s * m3;
						Matrix[14] = c * Matrix[14] - s * m4;
						break;
		  case 'z': m1=Matrix[0]; m2=Matrix[4];
						m3=Matrix[8]; m4=Matrix[12];
						Matrix[0]  = c * m1 - s * Matrix[1];
						Matrix[4]  = c * m2 - s * Matrix[5];
						Matrix[8]  = c * m3 - s * Matrix[9];
						Matrix[12] = c * m4 - s * Matrix[13];
						Matrix[1]  = c * Matrix[1]  + s * m1;
						Matrix[5]  = c * Matrix[5]  + s * m2;
						Matrix[9]  = c * Matrix[9]  + s * m3;
						Matrix[13] = c * Matrix[13] + s * m4;
						break;
	 }
	 Translation(attr3D, tx, ty, tz);
}

void  Skalierung(attr3D, s)
struct attraktor3D *attr3D;
double s;
{
	 int i;
	 double *Matrix;
	 Matrix = attr3D->Matrix;

	 for(i=0;i<16;i+=4) {
		  Matrix[i]   *= s;
		  Matrix[i+1] *= s;
		  Matrix[i+2] *= s;
	 }
	 attr3D->skal*=s;
}

void  Translation(attr3D,dx,dy,dz)
struct attraktor3D *attr3D;
double dx,dy,dz;
{
	 int i;
	 double *Matrix;
	 Matrix = attr3D->Matrix;

	 for(i=0;i<16;i+=4) {
		  Matrix[i]   += Matrix[i+3] * dx;
		  Matrix[i+1] += Matrix[i+3] * dy;
		  Matrix[i+2] += Matrix[i+3] * dz;
	 }
	 attr3D->transx+=dx;
	 attr3D->transy+=dy;
	 attr3D->transz+=dz;
}

int  Attr3DZ(attr3D,box)
struct attraktor3D *attr3D;
struct box *box;
{
	 FILE *file;
	 char string[20];
	 int x1=0,y1=0,x2=0,y2=0;
	 double x,y;
	 int xoffs = (box->x2+box->x1)/2;
	 int yoffs = (box->y2+box->y1)/2;
	 unsigned long i, s = sizeof(double), n ;
	 int sx = attr3D->stwertx, sx1=sx;
	 int sy = attr3D->stwerty, sy1=sy;
	 int sz = attr3D->stwertz, sz1=sz;
	 int sw = attr3D->sweite, s0, notfirst = 0;

	 if(!(file = fopen(Datei.filename,"rb"))) return(1);
	 fread(string, 1, 6, file);
	 fread(&(Zahlen.min), sizeof(double), 1, file);
	 fread(&(Zahlen.max), sizeof(double), 1, file);
	 fread(&(Zahlen.n), 4, 1, file);
	 if(Zahlen.n<10) {
		 fclose(file);
		 return(1);
	 }

	 Perspektive(attr3D);
	 if(sx>sy) {s0=sx; sx=sy; sy=s0; }  /* Der Groesse nach sortieren */
	 if(sx>sz) {s0=sz; sz=sx; sx=s0; }
	 if(sy>sz) {s0=sy; sy=sz; sz=s0; }
	 n = (Zahlen.n-sz)/sw;
	 s0 = sz - sx;

	 if(Kreuz) KoordinatenKreuz(attr3D, EGA_RED, box);
	 setcolor(EGA_YELLOW);
	 for(i=0; i<n ;i++) {
		  if(ms_leftb()) {
			 fclose(file);
			 return(0);
		  }
		  while(ms_rightb());
		  fseek(file, (long) (26+(sx+i*sw)*s), 0);
		  fread(Punkte, sizeof(double), s0+1, file);
		  if(Orbit3==0) {    /* nur Punkte zeichnen */
				Transform(Punkte[sx1-sx], Punkte[sy1-sx], Punkte[sz1-sx], &x, &y);
				x1=(int)(x)+xoffs;
				y1=(int)(y)+yoffs;
				if(x1>box->x1+7&&x1<box->x2-7&&y1>box->y1+7&&y1<box->y2-7)
					 putpixel(x1, y1, EGA_YELLOW);
		  }
		  else {            /* Linien */
				Transform(Punkte[sx1-sx], Punkte[sy1-sx], Punkte[sz1-sx], &x, &y);
				x1=(int)(x)+xoffs;
				y1=(int)(y)+yoffs;
				if (notfirst) ClipLine(x2, y2, x1, y1, box);
				x2 = x1; y2 = y1;
				notfirst=1;
		  }
	 }
	 fclose(file);
	 return(0);
}


int  Attr3D(attr3D,box)
struct attraktor3D *attr3D;
struct box *box;
{
	 int x1,y1;
	 int xoffs = (box->x2+box->x1)/2;
	 int yoffs = (box->y2+box->y1)/2;
	 double x,y;
	 double alt[10];
	 unsigned long i;
	 int j;
	 FILE *file;
	 int k1 = attr3D->koor1;
	 int k2 = attr3D->koor2;
	 int k3 = attr3D->koor3;
	 int s = sizeof(double);
	 int anz = Attraktor.anz_stpkte*anzKoor;
	 int pkt_alt[80], notfirst = 0;
	 int points[16];
	 int *Line, anz_lines;
	 int err=0;

	 Perspektive(attr3D);
	 if(Orbit3>1) {
		  Line = Object[Orbit3-2].line;
		  anz_lines = Object[Orbit3-2].anz_lines;
		  switch(Orbit3) {
			case 2:
				if(Attraktor.anz_stpkte<2) {
					PrintStatus("Zu wenige Punkte fr die Darstellung eines Polygons!");
					return(0);
				}
				anz_lines = Attraktor.anz_stpkte;
				for(j=0; j<2*anz_lines; j+=2) {Line[j] = j/2; Line[j+1] = j/2+1;}
				Line[anz_lines*2-1] = 0;
				break;
			case 3:
				if(Attraktor.anz_stpkte<8) {
					PrintStatus("Zu wenige Punkte fr die Darstellung eines Wrfels!");
					return(0);
				}
				break;
			case 4: if(Attraktor.anz_stpkte<5) {
					PrintStatus("Zu wenige Punkte fr die Darstellung einer Pyramide!");
					return(0);
				}
				break;
		  }
	 }

	 if(!Direkt) {
		file = fopen("ESA.tmp","rb");
	 }
	 else {
		for(j=0; j<anz; j++) Punkte[j]=Attraktor.stpkte[j];
		for(j=0; j<anzKoor; j++)
			alt[j] = var_const_list[Koordinaten[j].var-97].fvalue;
	 }

	 KoordinatenKreuz(attr3D, EGA_RED, box);
	 for(i=0; i<Attraktor.n ;i++) {
		if(ms_leftb()) return(0);
		while(ms_rightb());
		if(Direkt)
			for(j=0; j<anz; j+=anzKoor) {
				err=Berechne(&Punkte[j]);
				if(err)
					break;
			}
		else fread(Punkte, s, anz, file);
		if(err) break;
		switch(Orbit3) {
			case 0: /* nur Punkte zeichnen */
				for(j=0; j<anz; j+=anzKoor) {
					Transform(Punkte[k1+j], Punkte[k2+j], Punkte[k3+j], &x, &y);
					x1=(int)(x)+xoffs;
					y1=(int)(y)+yoffs;
					if(x1>box->x1+7&&x1<box->x2-7&&y1>box->y1+7&&y1<box->y2-7)
						putpixel(x1, y1, ColorTable[j/anzKoor]);
				}
				break;
			case 1: /* Linien */
				for(j=0; j<anz; j+=anzKoor) {
					setcolor(ColorTable[j/anzKoor]);
					Transform( Punkte[k1+j], Punkte[k2+j], Punkte[k3+j], &x, &y);
					x1=(int)(x)+xoffs;
					y1=(int)(y)+yoffs;
					if (notfirst) ClipLine(pkt_alt[k1+j], pkt_alt[k2+j], x1, y1, box);
					pkt_alt[k1+j] = x1;
					pkt_alt[k2+j] = y1;
				}
				notfirst=1;
				break;
			case 2: /* Polygone */
			case 3: /* Wuerfel (Alea jacta est!) */
			case 4: /* Pyramidenzauber */
				for(j=0; j<anz; j+=anzKoor) {
					  Transform(Punkte[k1+j], Punkte[k2+j], Punkte[k3+j], &x, &y);
					  points[2*j/anzKoor]=(int)(x)+xoffs;
					  points[2*j/anzKoor+1]=(int)(y)+yoffs;
				}
				setfillstyle(SOLID_FILL, EGA_BLACK);
				bar(box->x1+7, box->y1+7, box->x2-7, box->y2-7);
				if(Kreuz) KoordinatenKreuz(attr3D, EGA_RED, box);
				setcolor(YELLOW);
				for(j=0;j<2*anz_lines; j+=2)
					ClipLine(points[2*Line[j]], points[2*Line[j]+1],
				points[2*Line[j+1]], points[2*Line[j+1]+1], box);
				delay((unsigned) Slow);
				break;
		}
	 }
	 if(Direkt)
		  for(j=0; j<anzKoor; j++)
				var_const_list[Koordinaten[j].var-97].fvalue = alt[j];
	 else fclose(file);
	 return(0);
}
