#include "init.h"

// Initialisierung einer 2D-Attraktorstruktur mit Defaultwerten.
// Reservierung des dazu ntigen Speichers.

struct attraktor2D  *Init2DAttraktor()
{
	 struct attraktor2D *attr2D;

	 if(Quelle==FORMEL && anzKoor<2) return(0L);
	 attr2D = malloc(sizeof(struct attraktor2D));
	 attr2D->init      = 1;
	 attr2D->k1_min    = Attraktor.min[0];
	 attr2D->k1_max    = Attraktor.max[0];
	 attr2D->k2_min    = Attraktor.min[1];
	 attr2D->k2_max    = Attraktor.max[1];
	 attr2D->koor1     = 0;
	 attr2D->koor2     = 1;
	 attr2D->top       = 0;
	 attr2D->akt_stpkt = 1;
	 attr2D->modified  = 1;
	 attr2D->stwertx   = 0;
	 attr2D->stwerty   = 1;
	 attr2D->sweite    = 2;
	 return(attr2D);
}

// Darstellung eines Zahlenreihenattraktors mit 2 Dimensionen
// Parameter: 2D-Attraktorstruktur und Bildschirmfenster

int  Attr2DZ(attr2D,size)
struct attraktor2D *attr2D;
struct box *size;
{
	 int x1, y1;
	 int sx = attr2D->stwertx;
	 int sy = attr2D->stwerty, diff, s0;
	 unsigned long n;
	 int x_alt=0, y_alt=0;
	 double stepX, stepY;
	 double consX, consY;
	 unsigned long i, s=sizeof(double);
	 FILE *file;
	 char buffer[4096], string[10];
	 int notfirst = 0;

	 file = fopen(Datei.filename,"rb");
	 setvbuf(file, buffer, _IOFBF, sizeof(buffer));
	 fread(string, 1, 6, file);
	 fread(&(Zahlen.min), sizeof(double), 1, file);
	 fread(&(Zahlen.max), sizeof(double), 1, file);
	 fread(&(Zahlen.n), 4, 1, file);

	 if((attr2D->k1_min-attr2D->k1_max)==0.0) {
		  attr2D->k1_min=Zahlen.min;
		  attr2D->k1_max=Zahlen.max;
	 }
	 if((attr2D->k2_min-attr2D->k2_max)==0.0) {
		  attr2D->k2_min=Zahlen.min;
		  attr2D->k2_max=Zahlen.max;
	 }

	 if(WindowStatus!=1) {
		DrawDouble(&K_2DAttrZ[0].box,attr2D->k1_min,"");
		DrawDouble(&K_2DAttrZ[1].box,attr2D->k1_max,"");
		DrawDouble(&K_2DAttrZ[2].box,attr2D->k2_min,"");
		DrawDouble(&K_2DAttrZ[3].box,attr2D->k2_max,"");
	 }

	 if(sy>sx) { diff=sy-sx; s0=sx;} else {diff=sx-sy; s0=sy;}
	 n=(Zahlen.n-s0-diff)/attr2D->sweite;
	 stepX=(attr2D->k1_max-attr2D->k1_min)/(size->x2-size->x1);
	 stepY=(attr2D->k2_max-attr2D->k2_min)/(size->y2-size->y1);
	 consX=size->x1-attr2D->k1_min/stepX;
	 consY=size->y1-attr2D->k2_min/stepY;
	 setcolor(EGA_YELLOW);

	 for(i=0; i<n; i++) {
		  if(ms_leftb()) {
			  fclose(file);
			  return(0);
		  }
		  while(ms_rightb());
		  fseek(file, (long) (26+(s0+i*attr2D->sweite)*s), 0);
		  fread(Punkte, sizeof(double), diff+1, file);
		  switch(Orbit2) {
				 case 1:  /* Linien zeichnen */
					  x1=Punkte[sx-s0]/stepX+consX;
					  y1=Punkte[sy-s0]/stepY+consY;
					  y1=size->y1 + (size->y2-y1);
					  if (notfirst)
							ClipLine(x_alt, y_alt, x1, y1, size);
					  x_alt = x1;
					  y_alt = y1;
					  notfirst=1;
					  break;
				 default:  /* nur Punkte zeichnen */
					  x1=Punkte[sx-s0]/stepX+consX;
					  y1=Punkte[sy-s0]/stepY+consY;
					  y1=size->y1 + (size->y2-y1);
					  if(x1>size->x1+7 && x1<size->x2-7 && y1>size->y1+7 && y1<size->y2-7)
										 putpixel(x1, y1, EGA_YELLOW);
					  break;
		  }
	 }
	 fclose(file);
	 return(0);
}

// Berechnung und Darstellung des Attraktors in 2 Dimensionen
// Parameter: 2D.Attraktorstruktur und Bildschirmfenster

int  Attr2D(attr2D,size)
struct attraktor2D *attr2D;
struct box *size;
{
	 int x1, y1 ,x2 ,y2, x3, y3;
	 double stepX, stepY;
	 double consX, consY;
	 double alt[10];
	 unsigned long i;
	 FILE *file;
	 char buffer[4096];
	 int k1 = attr2D->koor1;
	 int k2 = attr2D->koor2;
	 int s = sizeof(double), j;
	 int anz = Attraktor.anz_stpkte*anzKoor;
	 int pkt_alt[80], notfirst = 0;
	 int err=0;

	 if((attr2D->k1_max-attr2D->k1_min)==0.0) return(0);
	 if((attr2D->k2_max-attr2D->k2_min)==0.0) return(0);
	 if(Attraktor.anz_stpkte<2 && Orbit2==2) {
		 PrintStatus("Zuwenig Startpunkte fr Polygondarstellung!");
		 return(1);
	 }

	 if(WindowStatus!=1) {
		DrawDouble(&K_2DAttr[2].box,attr2D->k1_min,"");
		DrawDouble(&K_2DAttr[3].box,attr2D->k1_max,"");
		DrawDouble(&K_2DAttr[4].box,attr2D->k2_min,"");
		DrawDouble(&K_2DAttr[5].box,attr2D->k2_max,"");
	 }
	 stepX=(attr2D->k1_max-attr2D->k1_min)/(size->x2-size->x1-14);
	 stepY=(attr2D->k2_max-attr2D->k2_min)/(size->y2-size->y1-14);
	 consX=size->x1+7-attr2D->k1_min/stepX;
	 consY=size->y1+7-attr2D->k2_min/stepY;

	 if(!Direkt) {
		  file = fopen("ESA.tmp","rb");
		  setvbuf(file, buffer, _IOFBF, sizeof(buffer));
	 }
	 else {
			for(j=0; j<anz; j++) Punkte[j]=Attraktor.stpkte[j];
			for(j=0; j<anzKoor; j++)
				alt[j] = var_const_list[Koordinaten[j].var-97].fvalue;
	 }

	 /* n Punkte grafisch ausgeben */
		setcolor(EGA_YELLOW);
		setfillstyle(SOLID_FILL, EGA_BLACK);
		for(i=0; i<Attraktor.n; i++) {
				if(ms_leftb()) return(0);
				while(ms_rightb());
				if(Direkt)
					for(j=0; j<anz; j+=anzKoor)
					{ err=Berechne(&Punkte[j]);
					  if(err) break;}
				else fread(Punkte, s, anz, file);
				if(err) break;
				switch(Orbit2) {
				case 0:  /* nur Punkte zeichnen */
					 for(j=0; j<anz; j+=anzKoor) {
						  x1=Punkte[k1+j]/stepX+consX;
						  y1=Punkte[k2+j]/stepY+consY;
						  y1=size->y1 + (size->y2-y1);
						  if((x1>size->x1+7) && (x1<size->x2-7) &&
							 (y1>size->y1+7) && (y1<size->y2-7))
								putpixel(x1, y1, ColorTable[j/anzKoor]);
					 }
					 break;
				case 1:  /* Linien zeichnen */
					 for(j=0; j<anz; j+=anzKoor) {
						  setcolor(ColorTable[j/anzKoor]);
						  x1=Punkte[j+k1]/stepX+consX;
						  y1=Punkte[j+k2]/stepY+consY;
						  y1=size->y1 + (size->y2-y1);
						  if (notfirst)
							  ClipLine(pkt_alt[j+k1], pkt_alt[j+k2], x1, y1, size);
						  pkt_alt[j+k1] = x1;
						  pkt_alt[j+k2] = y1;
					 }
					 notfirst=1;
					 break;
				case 2:  /* Polygone darstellen */
					 x1=x2=Punkte[k1]/stepX+consX;
					 y1=y2=Punkte[k2]/stepY+consY;
					 y1=size->y1 + (size->y2-y1);
					 y2=size->y1 + (size->y2-y2);
					 setcolor(EGA_BLACK);
					 bar(size->x1+7, size->y1+7, size->x2-7, size->y2-7);
					 setcolor(EGA_YELLOW);
					 for(j=anzKoor; j<anz; j+=anzKoor) {
						  x3=Punkte[j+k1]/stepX+consX;
						  y3=Punkte[j+k2]/stepY+consY;
						  y3=size->y1 + (size->y2-y3);
						  ClipLine(x2, y2, x3, y3, size);
						  x2 = x3; y2 = y3;
					 }
					 ClipLine(x3, y3, x1, y1, size);
					 delay((unsigned) Slow);
					 break;
		  }
	 }
	 if(Direkt) {
		  for(j=0; j<anzKoor; j++)
				var_const_list[Koordinaten[j].var-97].fvalue=alt[j];
	 } else fclose(file);
	 return(0);
}
