#include "init.h"

struct bifurkation  *InitBifurkation()
{
		struct bifurkation *bif;
		char konst[26];
		int anz;

		if(Quelle==FORMEL && anzKoor<1) return(0L);
		bif = malloc(sizeof(struct bifurkation));
		bif->init   = 1;
		bif->koor   = 0;
		anz=GetCL(konst);
		if (anz) {
			bif->konstante=konst[0];
			bif->kon_min=var_const_list[konst[0]-97].fvalue-2.0;
			bif->kon_max=var_const_list[konst[0]-97].fvalue+2.0;
		}
		else {
			bif->konstante=' ';
			bif->kon_min=1.9;
			bif->kon_max=3.0;
		}
		bif->var_min=0;
		bif->var_max=0;
		bif->n0=100;
		bif->n1=100;
		if(anz>0) bif->top=0;
		else bif->top=-1;
		return(bif);
}

void  Bifurkation(bif,size)
struct bifurkation *bif;
struct box *size;
{
      int   koor = bif->koor;
      char  cons = bif->konstante;
      double kmin = bif->kon_min;
      double kmax = bif->kon_max;
      double ymin = bif->var_min;
      double ymax = bif->var_max;
      unsigned long   n0   = bif->n0;
      unsigned long   n1   = bif->n1;
      unsigned long   n;
      int offsetX = size->x1+7;
      int offsetY = size->y1+7;
      int width   = size->x2 - offsetX-7;
      int height  = size->y2 - offsetY-7;
      int x_koor, y_koor, i,j;
      double c_alt,alt[10];
      double k,step;
      double y_ampli=ymax-ymin;
      int err=0;
//      char msg[100];

      if(!isalpha(cons)) {
	 PrintStatus("Gib Du mir eine Konstante und ich gebe Dir ein Bifurkationsdiagramm?");
	 return;
      }
      if(kmin!=kmax) {
      PrintStatus("Unterbrechen mit Maustaste");
      c_alt=var_const_list[cons-97].fvalue;   /* Wert der Konstanten retten */
      for(i=0; i<anzKoor; i++) {
	    alt[i]=var_const_list[Koordinaten[i].var-97].fvalue;
	    Punkte[i] = Attraktor.stpkte[i];
      }

      /***** ymin & ymax selbst berechnen *******************/
      if(y_ampli==0.0) {
	  ymin=1000000.0;ymax=-1000000.0;
	  step=(kmax-kmin)/5;
	  for (k=kmin,j=0;j<6;k=k+step,j++) {
	       var_const_list[cons-97].fvalue=k;
	       for(i=0; i<anzKoor; i++)  Punkte[i] = Attraktor.stpkte[i];
		      for(n=0;n<(n0+n1);n++) {
			     err=Berechne(&Punkte[0]); if(err) break;
			     if(Punkte[koor]>ymax) ymax = Punkte[koor];
			     if(Punkte[koor]<ymin) ymin = Punkte[koor];
		      }
		      y_ampli=ymax-ymin;
		      if(err) {
			   ymin=-2.0;
			   ymax= 2.0;
			   break;
		      }
	       }
	  }
	  bif->var_min = ymin;
	  bif->var_max = ymax;
	  if(WindowStatus!=1) {
		DrawDouble(&K_Bifurkation[1].box,kmin,"");
		DrawDouble(&K_Bifurkation[2].box,kmax,"");
		DrawDouble(&K_Bifurkation[3].box,ymin,"");
		DrawDouble(&K_Bifurkation[4].box,ymax,"");
	  }
	  /*******************************************************/
	  step=(kmax-kmin)/width;
	  for(k=kmin;k<kmax;k+=step)
	  {
		if(ms_leftb()) break;
		while(ms_rightb());
		var_const_list[cons-97].fvalue=k;
		for(i=0; i<anzKoor; i++)  Punkte[i] = Attraktor.stpkte[i];
		x_koor=(k-kmin)/step;
		for(n=0;n<(n0+n1);++n)
		{
			if(Berechne(&Punkte[0])) {
				 break;
			}
			if(n>=n0)
			{
				y_koor=height*((Punkte[koor]-ymin)/y_ampli);
				if(y_koor<height&&y_koor>0)
					putpixel(x_koor+offsetX,size->y2-y_koor-7, EGA_YELLOW);
					// Vertikale Spiegelung: offsetY+y_koor
			}
		}
	  }
	}
	var_const_list[cons-97].fvalue=c_alt;  /* Konstantenwert restaurieren */
	for(i=0; i<anzKoor; i++)
		 var_const_list[Koordinaten[i].var-97].fvalue = alt[i];
	PrintStatus("");
}