#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <graphics.h>
#include <ctype.h>
#include <math.h>
#include <signal.h>
#include <string.h>
#include <bios.h>
#include <alloc.h>
#include <float.h>

/* Definition aller Zustnde im Menue */
#define MAX_NODES 100

#define FALSE 0
#define TRUE !FALSE

#define X1 165
#define Y1 40     /* Position der DLG-Box */
#define X0 65
#define Y0 40    /* Position der DLG-Box */
#define X2 190
#define Y2 40
#define X3 186   /* Dlgbox Info */
#define Y3 40

#define SPZ 1
#define FOR 2
#define ZRH 3
#define RGB 0

#define NOTHING       0x0000
#define MENUELEISTE   0x0001
#define FENSTER1      0x0002
#define FENSTER2      0x0200
#define FENSTER3      0x0004
#define M_FILE        0x0008
#define M_GRAFIK      0x0010
#define M_ORBIT2      0x0020
#define M_ORBIT3      0x0040
#define M_FENSTER     0x8000
#define K_BIFURKATION 0x0080
#define K_2DATTR      0x0100
#define K_2DATTRZ     0x2000
#define K_3DATTR      0x0400
#define K_3DATTRZ     0x4000
#define K_POINCARE    0x1000
#define K_POINCAREZ   0x0800  // Konflikt mit DLG_INFO sollte nict auftreten
#define DLG_FORMEL    0x4400  /* special */
#define DLG_DATEI     0x2100  /* special */
#define DLG_INFO      0x0800
#define DLG_SETUP     0x1200

#define WindowOffs 7

#define Xmax 639
#define Ymax 479

#define ESCAPE  0x011b			/* Define the escape key	*/
#define C_LEFT  0x4b00
#define C_RIGHT 0x4d00
#define C_UP    0x4800
#define C_DOWN  0x5000
#define TAB     0x0f09
#define POS1    0x4700
#define END     0x4f00
#define ENTER   0x1c0d
#define BS      0x0e08
#define DEL     0x5300
#define INS     0x5200

/* Definitionen fuer Hotkeys */

#define ALT_a	0x1e00
#define ALT_b	0x3000
#define ALT_c	0x2e00
#define ALT_d	0x2000
#define ALT_e	0x1200
#define ALT_f	0x2100
#define ALT_g	0x2200
#define ALT_h	0x2300
#define ALT_i	0x1700
#define ALT_j	0x2400
#define ALT_k	0x2500
#define ALT_l	0x2600
#define ALT_m	0x3200
#define ALT_n	0x3100
#define ALT_o	0x1800
#define ALT_p	0x1900
#define ALT_q	0x1000
#define ALT_r	0x1300
#define ALT_s	0x1f00
#define ALT_t  0x1400
#define ALT_u	0x1600
#define ALT_v	0x2f00
#define ALT_w	0x1100
#define ALT_x	0x2d00
#define ALT_y	0x1500
#define ALT_z	0x2c00
#define ALT_2	0x7900
#define ALT_3	0x7a00



/************************************************************/
/*                                                          */
/*  Datenstrukturen fr den Editor fr seltsame Attraktoren */
/*                                                          */
/************************************************************/


/* Bifurkationsdiagramm  (nur im Zusammenhang mit Formeln) */

extern struct bifurkation {
	 int init;                 /* Ist diese Struktur schon initialisiert?   */
	 int koor;                 /* 0-9                                       */
	 char konstante;           /* a bis z                                   */
	 double var_min, var_max;  /* darzustellender Bereich der Variable      */
	 double kon_min, kon_max;  /* darzustellender Bereich der Konstante     */
	 unsigned long n0, n1;     /* Unterdrckungsfaktor n0, Anz. der Pkte n1 */
	 int top;                  /* fuer Konstantenliste                      */
};

/* Der globale Attraktor -> 1-10 dimensional */

extern struct attraktor {
	 double min[10];
	 double max[10];
	 int anz_stpkte;           /* Anzahl der Startpunkte */
	 double stpkte[80];        /* nicht mehr als 8       */
	 unsigned long n;          /* Anzahl der Punkte      */
	 int modified;
};

/* 2D-Attraktor bei Verwendung von Formeln */

extern struct attraktor2D {
	 int init;               /* (FZ)  schon initialisiert? */
	 double k1_min, k1_max;  /* (FZ)  Darstellungsbereich der 1.Koordinate */
	 double k2_min, k2_max;  /* (FZ)  Darstellungsbereich der 2.Koordinate */
	 int koor1;              /* (F )  1.Koordinate 0-10 */
	 int koor2;              /* (F )  2.Koordinate 0-10 */
	 int top;                /* (F )  */
	 int akt_stpkt;          /* (F )  sichtbare Startpunkt in der KZentrale */
	 int modified;           /* (F )  */
	 int stwertx, stwerty;   /* ( Z)  Startwerte in der Zahlenreihe */
	 int sweite;             /* ( Z)  Schrittweiten in der Zahlenrehe */
};


/* 3D-Attraktor bei Verwendung von Formeln */

extern struct attraktor3D {
	 int init;                     /* (FZ) schon initialisiert? */
	 double Matrix[16];             /* (FZ) bisherigen Bewegungen */
	 double transx,transy,transz;   /* (FZ) interne Berechnungen  */
	 double skal;                   /* (FZ) interne Berechnungen  */
	 int koor1;                    /* (F ) 1.Koordinate x, y oder z */
	 int koor2;                    /* (F ) 2.Koordinate x, y oder z */
	 int koor3;                    /* (F ) 3.Koordinate x, y oder z */
	 int top;                      /* (F ) oberste der angezeigten Konstanten */
	 int akt_stpkt;                /* (F ) angezeigte Startwert */
	 int modified;                 /* (F ) */
	 int stwertx, stwerty, stwertz;/* ( Z) Startwerte in der Zahlenreihe */
	 int sweite;                   /* ( Z) Schrittweiten in der Zahlenrehe */
};

/* Poincare -> Zahlenreihe oder Formeln */

extern struct poincare {
	 int init;
	 int koor1;						  /* 1.Koordinate */
	 int koor2;                  /* 2.Koordinate */
	 int koor3;                  /* 3.Koordinate */
	 double x1 ,y1 ,z1;          /* P1 */
	 double x2 ,y2 ,z2;          /* P2 */
	 double x3 ,y3 ,z3;          /* P3 */
	 double d12, d23;            /* Abstand P1,P2 und Abstand P2,P3 */
	 int modified;
	 int stwertx, stwerty, stwertz;/* ( Z) Startwerte in der Zahlenreihe */
	 int sweite;                   /* ( Z) Schrittweiten in der Zahlenrehe */
};



/* ein am Bildschirm dargestelltes Fenster */

extern struct window {
		int what;    /* NOTHING, K_BIFURKATION, K_2DATTR, K_2DATTRZ,
						  K_3DATTR, K_3DATTRZ oder K_POINCARE */
		struct bifurkation  *bif;
		struct attraktor2D  *attr2D;
		struct attraktor3D  *attr3D;
		struct poincare     *poinc;
};

#define KOORMAX 10
#define FORMELMAX 50
#define FORMELLEN 200

extern struct formelmod {
		int topformel;         /* oberste sichtbare Formel */
		int akt_stpkt;         /* aktuelle Startpunkt */
		double stpkte[80];     /* 10 Startpunkte */
		int anz_stpkte;        /* Anzahl der Startpunkte */
		};

extern struct formel {                 /* nur fuer Amiga */
	 char formel[FORMELLEN];     /* Variable -> formel[0]    */
	 struct node *tree;          /* formel[1]=''' -> relativ */
	 };

extern struct koordinate {
	 int index;
	 char var;             /* zwar ueberfluessig, aber wirksam! */
	 struct node *tree;
	 };

#define DATEIANZ 25

extern struct dateistuff {
		char path[100];
		char filename[15];
		char filelist[DATEIANZ][15];    /* Namen der Files */
		int what;           /* save oder load */
		int top;            /* oberstes sichtbare File       */
		int anz;            /* Anzahl der eingelesenen Files */
	};

/****************** ORBIT ***********************/

extern struct object {
	 int line[24];   /* 12 Linien mit Anfang und Ende */
	 int anz_lines;
	 };


#define FORMEL 0
#define ZAHLEN 1

/*************** ZAHLENREIHE ********************/

extern struct zahlen {
	 double min, max;
	 unsigned long n;                    /* Anzahl der Zahlen */
};

extern struct box
{
		int x1;
		int y1;
		int x2;
		int y2;
};

extern struct button
{
	struct box box;
	char name[20];
	int pressed;
	int id;
};

extern struct value {      /* Variablen und Konstanten */
	 char exist;
	 double fvalue;
	 };

extern struct node {       /* Knoten des Baum */
	 int info;
	 struct node *left;
	 struct node *right;
	 };


/************************************************************/
/*                                                          */
/*                   Prozedurkoepfe                         */
/*                                                          */
/************************************************************/

/* mouse.h */

extern int   ms_leftb(void);
extern int   ms_rightb(void);
extern void  ms_pos(int* ,int*);
extern void  ms_setXY(int, int);
extern void  ms_off(void);
extern int   ms_reset(int*);
extern void  ms_visible(void);
extern void  ms_hide(void);
extern int   ms_range(struct box*);

/* bd.h */

extern struct bifurkation *  InitBifurkation(void);
extern void  Bifurkation(struct bifurkation*, struct box*);



/* formel.h */
extern int    is_var(char);
extern struct node  *Malloc(void);
extern void   InitMemory(void);
extern void   KillSpaces(char *);
extern void   InitList(void);
extern int    GetIndex(char);
extern int    GetCL(char *);
extern void   FreeTree(struct node*);
extern struct node  *MakeTree(char *);
extern struct node  *Term1(char *);
extern struct node  *Term2(char *);
extern struct node  *Faktor(char *);
extern struct node  *Number(char *);
extern struct node  *Function(char *);
extern struct node  *VarConst(char *);
extern void   FloatingError(int, int);
extern int    matherr(struct exception*);
extern double Eval(struct node*);
extern int    Functionname(char *, int *);
extern struct node  *Ausdruck(char *);
extern int    Increment(char *);
extern int    InsertNumber(double);

/* d2.h */

extern struct attraktor2D  *Init2DAttraktor(void);
extern int  Attr2DZ(struct attraktor2D *, struct box *);
extern int  Attr2D(struct attraktor2D *, struct box *);

/* d3.h */

extern struct attraktor3D  *Init3DAttraktor(void);
extern void   KoordinatenKreuz(struct attraktor3D*, int, struct box*);
extern void   Rotation(struct attraktor3D*, char, double);
extern void   Skalierung(struct attraktor3D*, double);
extern void   Translation(struct attraktor3D*, double, double, double);
extern void   Perspektive(struct attraktor3D*);
extern void   Transform(double, double, double, double*, double*);
extern int    Attr3DZ(struct attraktor3D*, struct box*);
extern int    Attr3D(struct attraktor3D*, struct box*);

/* esaio.h */

extern void  AttrTemp(void);
extern int   SaveZR(void);
extern int   LoadZR(void);
extern int   InitDatei(int);
extern int   LoadSave(int);
extern int   LoadSPZ(void);
extern int   SaveSPZ(void);
extern int   LoadFOR(void);
extern int   SaveFOR(void);
extern void  ReadFiles(void);
extern void  LoadScreen(struct box*);
extern int   LoadTempScreen(struct box*, int);
extern int   SaveScreen(struct box*);
extern int   SaveTempScreen(struct box*, int);
extern int   SaveBackground(void);
extern int   RestoreBackground(void);


/* esaproc.h */

extern void  InitAll(int);
extern void  InitScreen(void);
extern int   NewStatus(int);
extern int   CheckKey(int);
extern void  EditField(int, struct box*, char*, int, int, int, int);
extern void  DrawCursor(int, int, int);
extern void  CreateTrees(int *);
extern int   NewTrees(void);
extern void  InitAlleFormeln(void);
extern void  CheckFormel(int, int*, struct box*);
extern char  *WhatTable(int);
extern void  NeueGrenzen(int*, struct box*, double*, double*, double*, double*);
extern void  PutPicture(int, int);
extern int   Hotkey(int);
extern void  DrawMeasure(int);
extern void  ClipLine(int, int ,int ,int, struct box*);
extern int   Berechne(double*);
extern void  AddStartwert(void);
extern void  DelStartwert(int);
extern int   CheckModi(void);
extern void  KillFenster(int);
extern void  DelFormel(void);
extern void  AddFormel(void);
extern void  Initialize1(void);


/* design.h */

extern void  DrawFormel(void);
extern void  DrawDLG(int);
extern void  DrawScreen(void);
extern void  DrawDouble(struct box*, double, char *);
extern void  DrawStr(struct box*, char*, int);
extern void  DrawInt(struct box*, int, int);
extern void  DrawLong(struct box*, unsigned long, int);
extern void  DrawKonst(struct button*, int, int);
extern void  DrawStartwert(int);
extern void  DrawK_3DAttrZ(void);
extern void  DrawK_Poincare(void);
extern void  DrawK_PoincareZ(void);
extern int   DrawDlgInfo(char*, char[]);
extern void  DrawEmptyWindow(void);
extern void   draw_string(struct box*, char*, int);
extern void   button_off(struct box*, char*);
extern void   button_on(struct box*, char*);
extern void   Dbutton(struct button *);
extern void   DrawWindow(struct box*);
extern void   Window(int);
extern struct box  *WhatWindow(void);
extern struct button  *WhatWindowButton(void);
extern void   DrawButtons(int);
extern void   DrawDLGButtons(int);
extern void   DrawStatuszeile(struct box *);
extern void   PrintStatus(char *);
extern void   DrawBorder(int, int, int, int);
extern void   Rechteck(struct box*);
extern void   DrawK_Bifurk(void);
extern void   DrawK_2DAttr(void);
extern void   DrawK_2DAttrZ(void);
extern void   DrawK_3DAttr(void);
extern void   DrawKommandozentrale(struct box*);
extern void   Kommando(int);
extern int    WhatButton(int);
extern int    WhatDLGButton(int);



/* poinc.h */

extern void		NeuerPoincareAusschnitt(int*, struct poincare*, struct box*);
extern void    BerechneDrittenPunkt(struct poincare*);
extern int	   Poincare(struct poincare*, struct box*);
extern int	   PoincareZ(struct poincare*, struct box*);
extern int 		IstPunktInnerhalb(struct poincare*, double*);
extern double  P_P_Abstand(double, double, double, double, double, double);
extern double  P_G_Abstand(double, double, double, double, double, double, double, double, double);
extern struct  poincare *InitPoincare();
extern void    ComputePoincare(struct poincare*, double, double, double, double, double, double, struct box*);
extern double  fmax(double, double);
extern double  max2d(double, double);
extern int     max2(double, double);
extern int     max3(double, double, double);
extern int     Pivot(double m[][4], double sp[]);



////////////////////////////////////////////////
// EXTERN Deklaration der globalen Variablen  //
////////////////////////////////////////////////

extern struct node Memory[MAX_NODES];
extern struct node *MemoryPointer;
extern double WKPunkte[];
extern double PMatrix[];
extern struct dateistuff Datei;
extern char   DateifilenameAlt[];
extern struct formelmod Modi;
extern struct window Fenster[];
extern int    AktivFenster;
extern char   AlleFormeln[FORMELMAX+1][FORMELLEN];
extern struct koordinate Koordinaten[KOORMAX+1];
extern int    anzKoor;
extern double Punkte[];
extern int    cx,cy;
extern int    inserttoggle;
extern int    c_up_down;
extern int    cursorindex;
extern int    editindex;
extern int    editfield1;
extern int	  oldeditfield1;
extern char   editstring[FORMELLEN];
extern char   *menuebuffer;
extern char   ErrorMessage[];
extern unsigned int Status;
extern unsigned int OldStatus;
extern unsigned int WindowStatus;
extern struct attraktor Attraktor;
extern struct object Object[];
extern int    Orbit2;
extern int    Orbit3;
extern double RelMulFaktor;
extern unsigned long Slow;
extern double NewRelMulFaktor;
extern unsigned long NewSlow;
extern int    AchsenRot;
extern int    NewAchsenRot;
extern double NewWKP1;
extern double NewWKP2;
extern int    Kreuz;
extern int    ColorTable[];
extern int    Direkt;
extern int    Quelle;
extern struct zahlen Zahlen;
extern int    error_code;
extern struct value var_const_list[126];
extern char   NewAlleFormeln[][FORMELLEN];
extern struct koordinate NewKoordinaten[];
extern int    NewDirekt;
extern char far *picture;
extern int    tempsave;
extern struct button Menueleiste[];
extern struct button M_File[];
extern struct button M_Grafik[];
extern struct button M_Orbit2[];
extern struct button M_Orbit3[];
extern struct button M_Fenster[];
extern struct button Fenster1[];
extern struct button Fenster2[];
extern struct button Fenster3[];
extern struct button K_Bifurkation[];
extern struct button K_2DAttr[];
extern struct button K_3DAttr[];
extern struct button DLG_Formel[];
extern struct button DLG_Datei[];
extern struct button K_2DAttrZ[];
extern struct button K_3DAttrZ[];
extern struct button DLG_Setup[];
extern struct button DLG_Info[];
extern struct button K_Poincare[];
extern struct button K_PoincareZ[];
extern struct box Kommandozentrale;
extern struct box Statuszeile;

// RGB.h

extern void SaveRGBScreen(struct box*);
extern void GimmeRGB(unsigned, int*);