#include <dir.h>
#include "init.h"

void  AttrTemp()
/*
ͻ
 Berechnet Punkte eines Attraktors und schreibt diese auf ein tempo-    
 rres File.                                                            
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    Attraktor (globale Attraktorstruktur)            
                       anzKoor   (Anzahl der verwendeten Koordinaten)   
                       var_const_list (verwendete Var. & Konstanten)    
                       Punkte (verwendete Startpunkte)                  
                                                                        
ͼ
*/
{
  FILE *file;
  unsigned long i;
  int j, k;
  int s = sizeof(double);
  int anz = Attraktor.anz_stpkte*anzKoor; /* Anzahl der Zahlen pro Paket */
  double alt[10], min[10], max[10];

  if (Attraktor.modified) {

	 PrintStatus("Berechne temporres File ...");
	 /* Koordinatenwerte retten und Initialisierungen */
	 for(j=0; j<anzKoor; j++) {
		  min[j] = 1000000.0;
		  max[j] = -1000000.0;
		  alt[j] = var_const_list[Koordinaten[j].var-97].fvalue;
	 }

	 /* File vorbereiten */
	 file = fopen("ESA.tmp","wb");

	 /* Punkte berechnen und auf Tempfile schreiben */
	 for(j=0;j<anz;j++) Punkte[j]=Attraktor.stpkte[j];
	 fwrite(Punkte, s, anz, file);
		for(i=1; i<Attraktor.n; i++) {
		  for(j=0; j<anz; j+=anzKoor) {
				Berechne(&Punkte[j]);
				for(k=0; k<anzKoor; k++) {
					if(Punkte[j+k]<min[k]) min[k]=Punkte[j+k];
					if(Punkte[j+k]>max[k]) max[k]=Punkte[j+k];
				}
				}
				fwrite(Punkte, s, anz, file);
		}

	 /* Alte Werte wieder zurueck und MinMax speichern */
	 for(j=0; j<anzKoor; j++) {
		  Attraktor.min[j] = min[j];
		  Attraktor.max[j] = max[j];
		  var_const_list[Koordinaten[j].var-97].fvalue=alt[j];
	 }
	 Attraktor.modified=0;
	 fclose(file);
  }
}

int  SaveZR()  /* Ein Formel-TempFile als Zahlenreihe speichern */
/*
ͻ
 Speichert ein temporres Formelfile als Zahlenreihe.                   
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          1 (wenn File nicht angelegt werden konnte)       
                       0 (File konnte erfolgreich gespeichert werden)   
 globale Variablen:    Datei     (Dateistruktur)                        
                       Attraktor (globaler Attraktor)                   
                       anzKoor   (verwendete globale Koordinaten)       
                                                                        
ͼ
*/
{
	 FILE *rfile, *wfile;
	 double p[80], min = 1000000.0, max=-100000.0;
	 unsigned long anz, i, paket;
	 unsigned long s = sizeof(double);
	 int j;

	 AttrTemp();

	 if(!(rfile = fopen("ESA.tmp","rb"))) return(1);
	 if(!(wfile = fopen(Datei.filename,"wb"))) {
		fclose(rfile);
		return(1);
	 }

	 PrintStatus("Erzeuge Zahlenreihenfile... ");
	 for(j=0; j<anzKoor; j++) {
		  if(Attraktor.min[j]<min) min=Attraktor.min[j];
		  if(Attraktor.max[j]>max) max=Attraktor.max[j];
	 }
	 paket = anzKoor*Attraktor.anz_stpkte;
	 anz = paket*Attraktor.n;
	 fwrite("ESAZHR", 1, 6, wfile);            /* ESA-Anfangskennung */
	 fwrite(&min, sizeof(double), 1, wfile);   /* Kleinste Zahl      */
	 fwrite(&max, sizeof(double), 1, wfile);   /* Grte Zahl        */
	 fwrite(&anz, 4, 1, wfile);                /* Anzahl der Zahlen  */
	 paket=paket-anzKoor;
	 for(j=0; j<Attraktor.anz_stpkte; j++) {
		  fseek(rfile, (long) anzKoor*j*s, 0);
		  for(i=0; i<Attraktor.n; i++) {
				fread(p, sizeof(double), anzKoor, rfile);
				fwrite(p, sizeof(double), anzKoor, wfile);
				fseek(rfile, (long) paket*s, 1);   /* long !! */
		  }
	 }
	 fclose(rfile);
	 fclose(wfile);
	 return(0);
}

int  LoadZR()       /* max. 10 Punkte pro Zeile (=max. Dimension) */
/*
ͻ
 Ladet ein als Zahlenreihe abgespeichertes Formelfile.                  
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          1 (wenn File nicht geladen werden konnte)        
                       0 (File konnte erfolgreich geladen werden)       
 globale Variablen:    Datei (Dateistruktur)                            
                       Zahlen (Anzahl der gespeicherten Zahlen)         
                                                                        
ͼ
*/
{
	 FILE *rfile, *wfile;
	 char string[300];
	 double p[10], min=10000.0, max=-10000.0;
	 unsigned long anz=0;
	 int s = sizeof(double), i ,n;

	 Quelle=ZAHLEN;
	 if(!(rfile = fopen(Datei.filename ,"rb"))) return(1);
	 if(!(wfile = fopen("ESAZHR.tmp","wb"))) return(1);

	 strcpy(DateifilenameAlt, Datei.filename);
	 // Checke, ob File bereits richtiges Formet hat
	 fread(string, 1, 6, rfile); string[6]=0;
	 if(!strcmp(string, "ESAZHR")) {
							 fclose(rfile);
							 fclose(wfile);
							 return(0);
	 }
	 // Nein, erzeuge es.
	 PrintStatus("Lade Zahlenreihenfile und erzeuge temporres File. ");
	 strcpy(Datei.filename, "esazhr.tmp");
	 fseek(rfile,  0L, SEEK_SET);
	 fseek(wfile, 26L, SEEK_SET);
	 while(fgets(string, 256, rfile))
	 {
		  n = sscanf(string,"%lf,%lf,%lf,%lf,%lf,%lf,%lf,%lf,%lf,%lf",
			 &p[0],&p[1],&p[2],&p[3],&p[4],&p[5],&p[6],&p[7],&p[8],&p[9]);
		  if(n>0) {
				fwrite(p, sizeof(double), n, wfile);
				anz=anz+n;
				for(i=0;i<n;i++) {
					 if(p[i]>max) max=p[i];
					 if(p[i]<min) min=p[i];
				}
		  }
	 }
	 Zahlen.n = anz;
	 Zahlen.min = min;
	 Zahlen.max = max;
	 fseek(wfile, 0L, SEEK_SET);
	 fwrite("ESAZHR", 1, 6, wfile);         /* ESA-Anfangskennung */
	 fwrite(&min, s, 1, wfile);             /* Kleinste Zahl */
	 fwrite(&max, s, 1, wfile);             /* Grte Zahl */
	 fwrite(&anz, 4, 1, wfile);             /* Anzahl der Zahlen */
	 fclose(rfile);
	 fclose(wfile);
	 return(0);
}

void  ReadFiles()
/*
ͻ
 Liest bis zu fnfzig Dateien in ein dafr vorgesehenes Feld.           
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    Datei (globale Dateistruktur)                    
                                                                        
ͼ
*/
{
	char file[50];
	struct ffblk ffblk;
	int i;

	for (i=0;i<50;i++) file[i]=0;
	i=0;
	Datei.path[strlen(Datei.path)]=0;
	strcpy(file, Datei.path);
	file[strlen(file)]='\\';
	strcat(file, Datei.filename);
	file[strlen(file)]=0;

	if (findfirst(file, &ffblk, FA_RDONLY)!=-1) {
		 strcpy(Datei.filelist[0], ffblk.ff_name);
		 i++;

		 while(findnext(&ffblk)!=-1 && i<DATEIANZ) {
				strcpy(Datei.filelist[i], ffblk.ff_name); i++;
				}
	}
	Datei.anz=i;
	if(Datei.anz<4) Datei.top=0;
	else if(Datei.top>Datei.anz-4) Datei.top=0;
}


int  InitDatei(losa)
int losa;               /* hat berhaupt keine Wirkung ... */
/*
ͻ
 Initialisiert die Datei laden/speichern Dialogbox mit Defaultwerten.   
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          FALSE (Probleme beim Lesen der Dateien)          
                       TRUE  (Dialogbox konnte initialisiert werden)    
 globale Variablen:    Datei (globale Dateistruktur)                    
                       DLG_Datei (Ausmae und Buttonpositionen der      
                                  Datei - Dialogbox)                    
                                                                        
ͼ
*/
{
	int disk, i;

	losa++; /* Warning... */
	if(Datei.path[0]==0) {
		 disk = getdisk();
		 if(getcurdir(0,&Datei.path[3])==-1) {
				 PrintStatus("Laufwerk nicht bereit!");
				 return(FALSE);
		 }
		 Datei.path[0]= (char) (disk+65);
		 Datei.path[1]=':';
		 Datei.path[2]='\\';
		 Datei.path[strlen(Datei.path)]=0;
	}
	DrawStr(&DLG_Datei[1].box, Datei.path, 0);
	if(Datei.filename[0]==0) {
		switch(Datei.what) {
			case ZRH: strcpy(Datei.filename, "*.zhr");
								break;
			case FOR: strcpy(Datei.filename, "*.for");
								break;
			case RGB: strcpy(Datei.filename, "*.rgb");
								break;
			case SPZ:
			default:  strcpy(Datei.filename, "*.spz");
								break;
		}   /* switch */
		Datei.filename[5]=0;
	}  /* if */
	DrawStr(&DLG_Datei[2].box, Datei.filename, 0);
	DLG_Datei[9+Datei.what].pressed=1;
	Dbutton(&DLG_Datei[9+Datei.what]);
	ReadFiles();
	for(i=0; i<4; i++)
		 if((i+Datei.top)<Datei.anz) DrawStr(&DLG_Datei[3+i].box, Datei.filelist[i+Datei.top], 0);
		 else Rechteck(&DLG_Datei[3+i].box);
	return(TRUE);
}

int  SaveFOR()
/*
ͻ
 Speichert nur die Formeln in ein vorgesehenes File.    					 
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    Datei (globale Dateistruktur)                    
                       AlleFormeln (Anzahl aller sich in der Formel-    
                                    Dialogbox befindenden Formeln)      
                                                                        
ͼ
*/
{
		FILE *file;
		int size = (FORMELMAX+1)*FORMELLEN;
		if (!(file = fopen(Datei.filename ,"wb"))) {
			PrintStatus("Datei kann nicht geffnet werden!");
			return(1);
		}
		fwrite("ESAFOR", 1, 6, file);
		fwrite(AlleFormeln[0], 1, size, file);
		fclose(file);
		return(0);
}

int  LoadFOR()
/*
ͻ
 Ladet Formeln aus einem File in die Formeldialogboxfelder.             
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          1 (Datei konnte nicht geffnet werden oder       
                          kein formelspezifisches File)                 
                       0 (Datei konnte erfolgreich geladen werden)      
 globale Variablen:    Datei (globale Dateistruktur)                    
                       AlleFormeln (Anzahl aller sich in der Formel-    
                                    Dialogbox befindenden Formeln)      
                       Quelle (gibt an ob Berechnungsbasis Formel oder  
                               Zahlenreihe ist)                         
                                                                        
ͼ
*/
{
		FILE *file;
		char string[15];
		int size = (FORMELMAX+1)*FORMELLEN;

		Quelle=FORMEL;
		Modi.topformel=0;
		if (!(file = fopen(Datei.filename ,"rb"))) {
			PrintStatus("Datei kann nicht geffnet werden!");
			return(1);
		}

		fread(string, 1, 6, file); string[6]=0;
		if(strcmp(string, "ESAFOR")) {
			PrintStatus("Dateifehler: Kein FORMEL-File!!");
			return(1);
		}

		fread(AlleFormeln[0], 1, size, file);
		fclose(file);
		return(0);
}

int  SaveSPZ()
/*
ͻ
 Speichert quasi den Editorstatus in ein sog. Spezifikationsfile.       
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          1 (File kann nicht angelegt werden)              
                       0 (Spezifikationsfile erfolgreich abgespeichert) 
 globale Variablen:    alle Variablen die zur Herstellung des Editor-   
                       status notwendig sind (s. initglob.h)            
                                                                        
ͼ
*/
{
		FILE *file;
		int i;

		if (!(file = fopen(Datei.filename ,"wb"))) {
			PrintStatus("Datei kann nicht geffnet werden!");
			return(1);
		}
		fwrite("ESASPZ", 1, 6, file);

		fwrite(Koordinaten,        1, sizeof(Koordinaten),     file);
		fwrite(&AktivFenster,      1, sizeof(AktivFenster),    file);
		fwrite(&OldStatus,         1, sizeof(OldStatus),       file);
		fwrite(&WindowStatus,      1, sizeof(WindowStatus),    file);
		fwrite(&anzKoor,           1, sizeof(anzKoor),         file);
		fwrite(&cx,                1, sizeof(cx),              file);
		fwrite(&cy,                1, sizeof(cy),              file);
		fwrite(&inserttoggle,      1, sizeof(inserttoggle),    file);
		fwrite(&cursorindex,       1, sizeof(cursorindex),     file);
		fwrite(&editindex,         1, sizeof(editindex),       file);
		fwrite(&Orbit2,            1, sizeof(Orbit2),          file);
		fwrite(&Orbit3,            1, sizeof(Orbit3),          file);
		fwrite(&Slow,              1, sizeof(Slow),            file);
		fwrite(&Kreuz,             1, sizeof(Kreuz),           file);
		fwrite(&Direkt,            1, sizeof(Direkt),          file);
		fwrite(&Quelle,            1, sizeof(Quelle),          file);
		fwrite(&error_code,        1, sizeof(error_code),      file);
		fwrite(&Fenster2[2],       2, sizeof(struct button),   file);
		fwrite(&Fenster3[3],       3, sizeof(struct button),   file);
		fwrite(&Modi,              1, sizeof(Modi),            file);
		fwrite(AlleFormeln[0],     1, sizeof(AlleFormeln),     file);
		fwrite(editstring,         1, sizeof(editstring),      file);
		fwrite(&Attraktor,         1, sizeof(Attraktor),       file);
		fwrite(&Zahlen,            1, sizeof(Zahlen),          file);
		fwrite(var_const_list,     1, sizeof(var_const_list),  file);
		for(i=0; i<6; i++) {
			fwrite(&(Fenster[i].what), 1, sizeof(int), file);
			switch(Fenster[i].what) {
				case NOTHING:
								break;
				case K_BIFURKATION:
								fwrite(Fenster[i].bif, 1, sizeof(struct bifurkation), file);
								break;
				case K_2DATTR:
				case K_2DATTRZ:
								fwrite(Fenster[i].attr2D, 1, sizeof(struct attraktor2D), file);
								break;
				case K_3DATTR:
				case K_3DATTRZ:
								fwrite(Fenster[i].attr3D, 1, sizeof(struct attraktor3D), file);
								break;
				case K_POINCARE:
				case K_POINCAREZ:
								fwrite(Fenster[i].poinc, 1, sizeof(struct poincare), file);
								break;
			}
		}
		fwrite(DateifilenameAlt,     1, 30,  file);
		fclose(file);
		strcpy(Datei.filename, DateifilenameAlt);
		return(0);
}


int  LoadSPZ()
/*
ͻ
 Ladet ein Spezifikationsfile.                                          
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          1 (File konnte nicht geffnet werden oder ist    
                          kein Spezifikationsfile)                      
                       0 (File konnte erfolgreich geladen werden)       
 globale Variablen:    alle zur Wiederherstellung des Editorstatus      
                       erforderlichen Variablen                         
                                                                        
ͼ
*/
{
		FILE *file;
		char string[15];
		int i;

		if (!(file = fopen(Datei.filename ,"rb"))) {
			PrintStatus("Datei kann nicht geffnet werden!");
			return(1);
		}
		fread(string, 1, 6, file); string[6]=0;
		if(strcmp(string, "ESASPZ")) {
				PrintStatus("Dateifehler: Kein SPEZIFIKATIONS-File!!");
				fclose(file);
				return(1);
		}

		fread(Koordinaten,        1, sizeof(Koordinaten),     file);
		fread(&AktivFenster,      1, sizeof(AktivFenster),    file);
		fread(&OldStatus,         1, sizeof(OldStatus),       file);
		fread(&WindowStatus,      1, sizeof(WindowStatus),    file);
		fread(&anzKoor,           1, sizeof(anzKoor),         file);
		fread(&cx,                1, sizeof(cx),              file);
		fread(&cy,                1, sizeof(cy),              file);
		fread(&inserttoggle,      1, sizeof(inserttoggle),    file);
		fread(&cursorindex,       1, sizeof(cursorindex),     file);
		fread(&editindex,         1, sizeof(editindex),       file);
		fread(&Orbit2,            1, sizeof(Orbit2),          file);
		fread(&Orbit3,            1, sizeof(Orbit3),          file);
		fread(&Slow,              1, sizeof(Slow),            file);
		fread(&Kreuz,             1, sizeof(Kreuz),           file);
		fread(&Direkt,            1, sizeof(Direkt),          file);
		fread(&Quelle,            1, sizeof(Quelle),          file);
		fread(&error_code,        1, sizeof(error_code),      file);
		fread(&Fenster2[2],       2, sizeof(struct button),   file);
		fread(&Fenster3[3],       3, sizeof(struct button),   file);
		fread(&Modi,              1, sizeof(Modi),            file);
		fread(AlleFormeln[0],     1, sizeof(AlleFormeln),     file);
		fread(editstring,         1, sizeof(editstring),      file);
		fread(&Attraktor,         1, sizeof(Attraktor),       file);
		fread(&Zahlen,            1, sizeof(Zahlen),          file);
		fread(var_const_list,     1, sizeof(var_const_list),  file);
		for(i=0; i<6; i++) {
			fread(&(Fenster[i].what), 1, sizeof(int), file);
			switch(Fenster[i].what) {
				case NOTHING:
								break;
				case K_BIFURKATION:
								if(Fenster[i].bif && i>0)
									free(Fenster[i].bif);
								Fenster[i].bif = malloc(sizeof(struct bifurkation));
								fread(Fenster[i].bif, 1, sizeof(struct bifurkation), file);
								break;
				case K_2DATTR:
				case K_2DATTRZ:
								if(Fenster[i].attr2D && i>0)
									free(Fenster[i].bif);
								Fenster[i].attr2D = malloc(sizeof(struct attraktor2D));
								fread(Fenster[i].attr2D, 1, sizeof(struct attraktor2D), file);
								break;
				case K_3DATTR:
				case K_3DATTRZ:
								if(Fenster[i].attr3D && i>0)
									free(Fenster[i].bif);
								Fenster[i].attr3D = malloc(sizeof(struct attraktor3D));
								fread(Fenster[i].attr3D, 1, sizeof(struct attraktor3D),file);
								break;
				case K_POINCARE:
				case K_POINCAREZ:
								if(Fenster[i].poinc && i>0)
									free(Fenster[i].bif);
								Fenster[i].poinc = malloc(sizeof(struct poincare));
								fread(Fenster[i].poinc, 1, sizeof(struct poincare), file);
								break;
			}
		}
		fread(DateifilenameAlt,     1, 30,  file);
		fclose(file);
		for(i=0; i<10; i++) { if(i<anzKoor) DLG_Formel[6+i].pressed=1;
													else DLG_Formel[6+i].pressed=0; }
		DrawButtons(MENUELEISTE);
		if(WindowStatus==1) {
			 WindowStatus=2;
			 M_Fenster[0].pressed=0;
			 M_Fenster[1].pressed=1;
			 AktivFenster=1;
			 OldStatus=Fenster[AktivFenster].what|MENUELEISTE|FENSTER2;
		}
		Window(WindowStatus);
		for(i=0; i<3; i++) M_Fenster[i].pressed=0;
		M_Fenster[WindowStatus-1].pressed=1;
		Kommando(Fenster[AktivFenster].what);
		if(Quelle==ZAHLEN) {
			strcpy(Datei.filename, DateifilenameAlt);
			LoadZR();
		}
		PrintStatus("                ESA - Editor fr seltsame Attraktoren");
		return(0);
}

int  LoadSave(loadsave)
int loadsave;
/*
ͻ
 Speichert oder lader Dateien von der Festplatte.                       
͹
                                                                        
 Eingabeparameter:     loadsave (0 ... laden, !=0 ... speichern)        
 Ausgabeparameter:     keine                                            
 Returnwerte:          0 (Aktion erfolgreich)                           
                       1 (Aktion milungen)                             
 globale Variablen:    Datei (globale Dateistruktur)                    
                       Quelle (gibt an ob Berechnungsbasis Formel oder  
                               Zahlenreihe ist)                         
                                                                        
ͼ
*/
{
		switch(Datei.what) {
			case FOR:
					if(loadsave) return(LoadFOR());
					else         return(SaveFOR());
			case SPZ:
					if(loadsave) { InitAll(1); return(LoadSPZ()); }
					else         return(SaveSPZ());
			case RGB:
					if(loadsave) {
						PrintStatus("RGB-Files knnen mit diesem Editor nicht geladen werden!");
						return(1);
					}
					else {
						PrintStatus("Aktives Fenster wird im RGB-Format gesichert..");
						SaveRGBScreen(WhatWindow());
						PrintStatus("");
						return(1);
					}
			case ZRH:
					if(loadsave) {
						 InitAll(1);
						 DrawScreen();
						 return(LoadZR());
					}
					else {
						 if(Quelle==ZAHLEN) {
							PrintStatus("Kann keine Zahlereihen speichern");
							DrawScreen();
						 }
						 else {
							DrawScreen();
							return(SaveZR());
						 }
					}
					break;
		}
		return(1);
}

int SaveTempScreen(pos, gran)
struct box *pos;
int gran;
/*
ͻ
 Speichert einen durch pos angegebenen Bildschirmausschnitt auf ein     
 temporres File.                                                       
͹
                                                                        
 Eingabeparameter:     pos (rechteckiger Bildschirmausschnitt)          
                       gran (gibt die x bzw. y - Rasterung des zu       
                             speichernden Bereiches an)                 
 Ausgabeparameter:     keine                                            
 Returnwerte:          FALSE (File konnte nicht angelegt werden oder    
                              zu wenig Speicher zum Retten des Hinter-  
                              grundes)                                  
                       TRUE (Hintergrund erfolgreich gerettet)          
 globale Variablen:    keine                                            
                                                                        
ͼ
*/

{
  FILE *output;
  int x,y,stepx,stepy;
  unsigned size;
  char far *pic;

  pic = (char far*)NULL;
  stepx = ((pos->x2 - pos->x1)/gran)+1;
  stepy = ((pos->y2 - pos->y1)/gran)+1;

  if((output = fopen("screen.tmp", "wb")) == NULL)
  {
	 PrintStatus("Probleme beim Retten des Hintergrundes (fopen) !");
	 return(FALSE);
  }
  else {
	 x=pos->x1;
	 y=pos->y1;
	 size = imagesize(x, y, x+stepx, y+stepy);
	 fwrite(&size, sizeof(unsigned), 1, output);
	 ms_hide();
	 for (y=pos->y1;y<pos->y2;y+=stepy) {
		for (x=pos->x1;x<pos->x2;x+=stepx)   {
			size = (unsigned)imagesize(x, y, x+stepx, y+stepy);
			pic = (char far *) farmalloc(size);
			if (pic == NULL)
			{
			  PrintStatus("Probleme beim Retten des Hintergrundes (malloc) !");
			  fclose(output);
			  ms_visible();
			  return(FALSE);
			}
			getimage(x, y, x+stepx, y+stepy, pic);
			fwrite(pic, size, 1, output);
			farfree(pic);
			pic = NULL;
		}
	 }
	 fclose(output);
	 ms_visible();
	 return(TRUE);
  }
}

int LoadTempScreen(pos, gran)
struct box *pos;
int gran;
/*
ͻ
 Ladet einen rechteckigen Bildschirmbereich von einem File.             
͹
                                                                        
 Eingabeparameter:     pos (Position des rechteckigen Bereiches)        
                       gran (gibt die x bzw. y - Rasterung des zu       
                             ladenden Bereiches an)                     
 Ausgabeparameter:     keine                                            
 Returnwerte:          FALSE (File konnte nicht geffnet werden oder    
                              zu wenig Speicher)                        
                       TRUE  (Hintergrund erfolgreich restauriert)      
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{
  FILE *output;
  int x,y,stepx,stepy;
  unsigned size;
  char far *pic;

  pic = (char far*)NULL;
  stepx = ((pos->x2 - pos->x1)/gran)+1;
  stepy = ((pos->y2 - pos->y1)/gran)+1;

  if((output = fopen("screen.tmp", "rb")) == NULL)
  {
	 PrintStatus("Probleme beim Restaurieren des Hintergrundes (fopen) !");
	 return (FALSE);
  }
  ms_hide();
  fread(&size, sizeof(unsigned), 1, output);
  for (y=pos->y1;y<pos->y2;y+=stepy) {
	 for (x=pos->x1;x<pos->x2;x+=stepx)   {
		 pic=(char far *)farmalloc(size);
		 if (pic ==NULL)
		 {
			PrintStatus("Probleme beim Restaurieren des Hintergrundes (malloc) !");
			fclose(output);
			ms_visible();
			return(FALSE);
		 }
		 fread(pic, size, 1, output);
		 putimage(x,y,pic,COPY_PUT);
		 farfree(pic);
		 pic = NULL;
	 }
  }
  fclose(output);
  ms_visible();
  return(TRUE);
}

int SaveScreen(pos)
struct box *pos;
/*
ͻ
 Speichert rechteckigen Bildschirmausschnitt in einen Buffer des        
 Arbeitsspeichers.                                                      
͹
                                                                        
 Eingabeparameter:     pos (rechteckiger Bildschirmausschnitt)          
 Ausgabeparameter:     keine                                            
 Returnwerte:          FALSE (zu wenig Speicher zum Sichern des Hinter- 
                              grundes)                                  
                       TRUE  (Hintergrund erfolgreich gesichert)        
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{
  unsigned size;

  picture = (char far*)NULL;
  size = (unsigned)imagesize(pos->x1,pos->y1,pos->x2,pos->y2);
  ms_hide();
  if ((picture = (char *) farmalloc(size)) == NULL)
  {
		PrintStatus("Zu wenig Speicher zum Retten des Hintergrundes !");
		ms_visible();
		return(FALSE);
  }
  getimage(pos->x1,pos->y1,pos->x2,pos->y2,picture);
  ms_visible();
  return(TRUE);
}

void LoadScreen(pos)
struct box *pos;
/*
ͻ
 Ladet einen rechteckigen Bildschirmausschnitt aus einem Buffer des     
 Arbeitsspeichers.                                                      
͹
                                                                        
 Eingabeparameter:     pos (rechteckiger Bildschirmausschnitt)          
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{

  ms_hide();
  putimage(pos->x1,pos->y1,picture,COPY_PUT);
  farfree(picture);
  picture = NULL;
  ms_visible();
}

int SaveBackground(void)
/*
ͻ
 Speichert die Inhalte aller Fenster (bis auf das groe) auf ent-       
 sprechende temporre Files auf die Platte.                             
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          FALSE (zu wenig Speicher zum Sichern des Hinter- 
                              grundes)                                  
                       TRUE  (Hintergrund erfolgreich gesichert)        
 globale Variablen:    alle bentigten Fensterkoordinaten               
                                                                        
ͼ
*/
{
	int i;
	FILE *output;
	char far *windowtmp;
	char string[25];
	char name[10]="window.";
	unsigned size;

	windowtmp = (char far*) NULL;
	if (WindowStatus == 2)
	{
		for (i=1;i<3;i++)
		{
		  if (Fenster[i].what != 0)
		  {
				itoa(i, string, 10);
				strcat(name, string);
				output = fopen(name, "wb");
				if (output == NULL)
				{
					PrintStatus("File kann nicht geffnet werden (SaveBackground) !");
					return(FALSE);
				}
				size = imagesize(Fenster2[i-1].box.x1,Fenster2[i-1].box.y1,
									  Fenster2[i-1].box.x2,Fenster2[i-1].box.y2);
				fwrite(&size, sizeof(size), 1, output);
				ms_hide();
				windowtmp = (char far *) farmalloc(size);
				if (windowtmp == NULL)
				{
					PrintStatus("Speicher futsch (SaveBackground) !");
					fclose(output);
					ms_visible();
					return(FALSE);
				}
				getimage(Fenster2[i-1].box.x1,Fenster2[i-1].box.y1,
							Fenster2[i-1].box.x2,Fenster2[i-1].box.y2, windowtmp);
				fwrite(windowtmp, size, 1, output);
				farfree(windowtmp);
				windowtmp = NULL;
				fclose(output);
				name[strlen("window.")]=0;
				ms_visible();
		  }	// if
		}	 // for
	}	// if
	if (WindowStatus == 3)
	{
		for (i=3;i<6;i++)
		{
		  if (Fenster[i].what != 0)
		  {
				itoa(i, string, 10);
				strcat(name, string);
				output = fopen(name, "wb");
				if (output == NULL)
				{
					PrintStatus("File kann nicht geffnet werden (SaveBackground) !");
					return(FALSE);
				}
				size = imagesize(Fenster3[i-3].box.x1,Fenster3[i-3].box.y1,
									  Fenster3[i-3].box.x2,Fenster3[i-3].box.y2);
				fwrite(&size, sizeof(size), 1, output);
				ms_hide();
				windowtmp = (char far *) farmalloc(size);
				if (windowtmp == NULL)
				{
					PrintStatus("Speicher futsch (SaveBackground) !");
					fclose(output);
					ms_visible();
					return(FALSE);
				}
				getimage(Fenster3[i-3].box.x1,Fenster3[i-3].box.y1,
							Fenster3[i-3].box.x2,Fenster3[i-3].box.y2, windowtmp);
				fwrite(windowtmp, size, 1, output);
				farfree(windowtmp);
				windowtmp = NULL;
				fclose(output);
				name[strlen("window.")]=0;
				ms_visible();
		  }	// if
		}	 // for
	}	// if
	return (TRUE);
}


int RestoreBackground(void)
/*
ͻ
 Ladet die Inhalte der Fenster aus einem File.                          
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          FALSE (File konnte nicht geffnet werden oder    
                              zu wenig Speicher frei)                   
                       TRUE  (Fensterinhalte erfolgreich restauriert)   
 globale Variablen:    alle bentigten Fensterkoordinaten               
                                                                        
ͼ
*/
{
	int i;
	FILE *output;
	char far *windowtmp;
	char string[25];
	char name[10]="window.";
	unsigned size;

	windowtmp = (char far *) NULL;
	if (WindowStatus == 2)
	{
		for (i=1;i<3;i++)
		{
		  if (Fenster[i].what != 0)
		  {
				itoa(i, string, 10);
				strcat(name, string);
				output = fopen(name, "rb");
				if (output==NULL)
				{
					PrintStatus("File konnte nicht geffnet werden (RestoreBackground) !");
					return(FALSE);
				}
				fread(&size, sizeof(size), 1, output);
				ms_hide();
				windowtmp = (char far *) farmalloc(size);
				if (windowtmp == NULL)
				{
					PrintStatus("Speicher futsch (RestoreBackground) !");
					fclose(output);
					ms_visible();
					return(FALSE);
				}
				fread(windowtmp, size, 1, output);
				putimage(Fenster2[i-1].box.x1,Fenster2[i-1].box.y1,
							windowtmp,COPY_PUT);
				farfree(windowtmp);
				windowtmp = NULL;
				fclose(output);
				name[strlen("window.")]=0;
				ms_visible();
		  }	// if
		}	 // for
	}	// if
	if (WindowStatus == 3)
	{
		for (i=3;i<6;i++)
		{
		  if (Fenster[i].what != 0)
		  {
				itoa(i, string, 10);
				strcat(name, string);
				output = fopen(name, "rb");
				if (output==NULL)
				{
					PrintStatus("File konnte nicht geffnet werden (RestoreBackground) !");
					return(FALSE);
				}
				fread(&size, sizeof(size), 1, output);
				ms_hide();
				windowtmp = (char far *) farmalloc(size);
				if (windowtmp == NULL)
				{
					PrintStatus("Speicher futsch (RestoreBackground) !");
					fclose(output);
					ms_visible();
					return(FALSE);
				}
				fread(windowtmp, size, 1, output);
				putimage(Fenster3[i-3].box.x1,Fenster3[i-3].box.y1,
							windowtmp, COPY_PUT);
				farfree(windowtmp);
				windowtmp = NULL;
				fclose(output);
				name[strlen("window.")]=0;
				ms_visible();
		  }	// if
		}	 // for
	}	// if
	return(TRUE);
}


