#include "init.h"

void DrawFormel()
/*
ͻ
 Zeichnet beim Aufruf der Formeldialogbox die zur Verfgung stehenden   
 Formeln in die Eingabefelder.                                          
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    Modi (wichtige Parameter fr Formeldst.)         
                       DlgFormel[] (Positionen der Eingabefelder)       
                                                                        
ͼ
*/
{
	int i, index, j, bool;

	for(i=1; i<6; i++) {
		bool=-1;
		index=Modi.topformel+i-1;
		DrawStr(&DLG_Formel[i].box, NewAlleFormeln[index], 0);
		for(j=0; j<10; j++)
			if(index==NewKoordinaten[j].index) bool=j;
		if(bool!=-1) DrawInt(&DLG_Formel[i+5].box, bool, 0);
		else Rechteck(&DLG_Formel[i+5].box);
	}
}

void DrawDLG(status)
int status;
/*
ͻ
 Zeichnet je nach bergebenem Parameter die entsprechende Dialog-       
 box.                                                                   
͹
                                                                        
 Eingabeparameter:     status (Code fr die Dialogboxen)                
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    alle fr die Dialogboxen relevanten              
                       Parameter                                        
                                                                        
ͼ
*/
{
	int i;

	switch(status){
		case DLG_FORMEL:
			DrawKommandozentrale(&DLG_Formel[0].box);
			setcolor(EGA_BLACK);
			outtextxy(X0+150, Y0+15, "Formeln modifizieren");
			outtextxy(X0+150, Y0+17,"____________________");
			outtextxy(X0+10 , Y0+40, "Formelsammlung:");
			outtextxy(X0+320, Y0+40, "Startpunkte:");
			for (i=1;i<21;i++) Rechteck(&DLG_Formel[i].box);
			DrawFormel();
			DrawStartwert(DLG_FORMEL);
			for(i=0;i<10;i++) if(Koordinaten[i].index==-1) DLG_Formel[32+i].pressed=0;
									else DLG_Formel[32+i].pressed=1;
			break;
		case DLG_DATEI:
			DrawKommandozentrale(&DLG_Datei[0].box);
			setcolor(EGA_BLACK);
			outtextxy(X1+10, Y1+19, "Verzeichnis");
			outtextxy(X1+10, Y1+59, "Datei");
			outtextxy(X1+10, Y1+99, "Dateiliste:");
			for (i=1;i<7;i++) Rechteck(&DLG_Datei[i].box);
			break;
		case DLG_SETUP:
			DrawKommandozentrale(&DLG_Setup[0].box);
			setcolor(EGA_BLACK);
			outtextxy(X2+50, Y2+16, "Allgemeine Parameter");
			outtextxy(X2+10, Y2+56, "Multiplikationsfaktor:");
			outtextxy(X2+10, Y2+76, "Animationstempo:");
			outtextxy(X2+10, Y2+96, "Achsen-Rotations-Tempo:");
			outtextxy(X2+10, Y2+116, "Achsengre:");
			outtextxy(X2+187,Y2+116, ",");
			for (i=1;i<7;i++) Rechteck(&DLG_Setup[i].box);
			DrawDouble(&DLG_Setup[1].box, RelMulFaktor, "");
			DrawLong(&DLG_Setup[2].box, Slow, 0);
			DrawInt(&DLG_Setup[3].box, AchsenRot, 0);
			DrawDouble(&DLG_Setup[4].box, WKPunkte[0], "");
			DrawDouble(&DLG_Setup[5].box, WKPunkte[3], "");
			break;
		default:
			break;
	}
	DrawDLGButtons(status);
}


void DrawK_Bifurk()
/*
ͻ
 Zeichnet die Kommandozentrale fr die Bifurkationmanipulation.         
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    alle fr die Bifurkationsdarstellung relevanten  
                       Parameter                                        
                       K_Bifurkation (Positionen der Buttons und        
                                      Eingabefelder)                    
                                                                        
ͼ
*/
{
	char string[2];
	struct bifurkation *bifurk;
	string[1]=0;

	// Hervorhebungen des Bedienfeldes zeichnen
	DrawBorder(13,336,325,440);
	DrawBorder(329,336,429,440);
	DrawBorder(433,336,517,440);
	DrawBorder(521,336,625,440);

	// Texte am Bedienfeld ausgeben
	setcolor(EGA_BLACK);
	outtextxy(145,344,"Formel");
	outtextxy(94,384,"Darstellungsbereich");
	outtextxy(339,344,"Konstanten");
	outtextxy(439,344,"Startwert");
	outtextxy(439,384,"UF/Punkte");
	outtextxy(529,344,"Verschieben");
	outtextxy(15,404," :[");
	outtextxy(172,404,",");
	outtextxy(315,404,"]");
	outtextxy(15,424," :[");
	outtextxy(172,424,",");
	outtextxy(315,424,"]");

	// Buttons zeichnen
	DrawButtons(K_BIFURKATION);
	bifurk = Fenster[AktivFenster].bif;

	// Formel ausgeben
	DrawStr(&K_Bifurkation[0].box, AlleFormeln[Koordinaten[bifurk->koor].index], 0);

	// abhngige Beschriftungen ausgeben
	string[0]=bifurk->konstante;
	outtextxy(17,404,string);
	strcpy(K_Bifurkation[15].name, string);
	Dbutton(&K_Bifurkation[15]);
	string[0]=Koordinaten[bifurk->koor].var;
	outtextxy(17,424,string);
	strcpy(K_Bifurkation[14].name, string);
	Dbutton(&K_Bifurkation[14]);

	// Darstellungsintervalle ausgeben
	DrawDouble(&K_Bifurkation[1].box, bifurk->kon_min, "");
	DrawDouble(&K_Bifurkation[2].box, bifurk->kon_max, "");
	DrawDouble(&K_Bifurkation[3].box, bifurk->var_min, "");
	DrawDouble(&K_Bifurkation[4].box, bifurk->var_max, "");

	// Konstantenliste ausgeben
	DrawKonst(&K_Bifurkation[5], bifurk->top,4);

	// Startwert ausgeben
	DrawDouble(&K_Bifurkation[9].box,Attraktor.stpkte[bifurk->koor],"");

	// Unterdrckungfaktor und Berechnungstiefe ausgeben
	DrawLong(&K_Bifurkation[10].box, bifurk->n0, 0);
	DrawLong(&K_Bifurkation[11].box, bifurk->n1, 0);
}

void  DrawK_2DAttr()
/*
ͻ
 Zeichnet die Kommandozentrale fr die 2D-Attraktormanipulation.        
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    alle fr die 2D-Attraktordarstellung relevanten  
                       Parameter (Formeldarstellung)                    
                       K_2DAttr[] (Positionen der Buttons und           
                                    Eingabefelder)                      
                                                                        
ͼ
*/
{
	struct attraktor2D *attr2D;
	char s[2];
	int i;

	// Hintergrund der Bedienflche
	DrawKommandozentrale(&Kommandozentrale);

	// Hervorhebungen auf der Bedienflche
	DrawBorder(13,336,310,440);
	DrawBorder(314,336,414,440);
	DrawBorder(418,336,517,440);
	DrawBorder(521,336,625,440);
	setcolor(EGA_BLACK);

	// Texte innerhalb der Bedienflche ausgeben
	outtextxy(59,344,"Formel/Darstellungsbereich");
	outtextxy(324,344,"Konstanten");
	outtextxy(428,344,"St.W./Pkte");
	outtextxy(529,344,"Verschieben");
	outtextxy(15,404," :[");
	outtextxy(166,404,",");
	outtextxy(300,404,"]");
	outtextxy(15,424," :[");
	outtextxy(166,424,",");
	outtextxy(300,424,"]");

	// leeren Editierfelder zeichnen
	for (i=0;i<13;i++)
		 Rechteck(&K_2DAttr[i].box);

	// Buttons zeichen
	DrawButtons(K_2DATTR);
	attr2D = Fenster[AktivFenster].attr2D;

	// Formel rausschreiben
	DrawStr(&K_2DAttr[0].box, AlleFormeln[Koordinaten[attr2D->koor1].index],0);
	DrawStr(&K_2DAttr[1].box, AlleFormeln[Koordinaten[attr2D->koor2].index],0);

	// diverse Koordinatenbeschriftungen
	s[1]=0;
	s[0]=Koordinaten[attr2D->koor1].var;
	outtextxy(17,404,s);
	strcpy(K_2DAttr[19].name, s);
	Dbutton(&K_2DAttr[19]);
	s[0]=Koordinaten[attr2D->koor2].var;
	outtextxy(17,424,s);
	strcpy(K_2DAttr[20].name, s);
	Dbutton(&K_2DAttr[20]);

	// Intervalle ausgeben
	DrawDouble(&K_2DAttr[2].box, attr2D->k1_min, "");
	DrawDouble(&K_2DAttr[3].box, attr2D->k1_max, "");
	DrawDouble(&K_2DAttr[4].box, attr2D->k2_min, "");
	DrawDouble(&K_2DAttr[5].box, attr2D->k2_max, "");

	// Konstantenliste ausgeben
	DrawKonst(&K_2DAttr[6], attr2D->top, 4);

	// Startwerte ausgeben
	DrawStartwert(K_2DATTR);

	// Anzahl der Punkte ausgeben
	DrawLong(&K_2DAttr[12].box, Attraktor.n, 0);
}

void  DrawK_2DAttrZ()
/*
ͻ
 Zeichnet die Kommandozentrale fr die 2D-Attraktormanipulation.        
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    alle fr die 2D-Attraktordarstellung relevanten  
                       Parameter (Zahlenreihendarstellung)              
                       K_2DAttrZ[] (Positionen der Buttons und          
                                    Eingabefelder)                      
                                                                        
ͼ
*/
{
	struct attraktor2D *attr2D;
	int i;

	DrawKommandozentrale(&Kommandozentrale);
	DrawBorder(13,336,310,440);
	DrawBorder(314,336,516,440);
	DrawBorder(521,336,625,440);
	setcolor(EGA_BLACK);
	outtextxy(91 ,344,"Darstellungsbereich");
	outtextxy(103,359,"fr Zahlenreihen");
	outtextxy(364,344,"Start-");
	outtextxy(368,359,"werte");
	outtextxy(436,344,"Schritt-");
	outtextxy(448,359, "weite");
	outtextxy(529,344,"Verschieben");
	outtextxy(15,384,"x:[");
	outtextxy(166,384,",");
	outtextxy(300,384,"]");
	outtextxy(15,404,"y:[");
	outtextxy(166,404,",");
	outtextxy(300,404,"]");
	outtextxy(315,384,"x(n)=");
	outtextxy(315,404,"y(n)=");
	outtextxy(426,384,"+");
	outtextxy(426,404,"+");
	outtextxy(506,384,"n");
	outtextxy(506,404,"n");
	for (i=0;i<8;i++)
		 Rechteck(&K_2DAttrZ[i].box);
	DrawButtons(K_2DATTRZ);
	attr2D = Fenster[AktivFenster].attr2D;

	DrawDouble(&K_2DAttrZ[0].box, attr2D->k1_min, "");
	DrawDouble(&K_2DAttrZ[1].box, attr2D->k1_max, "");
	DrawDouble(&K_2DAttrZ[2].box, attr2D->k2_min, "");
	DrawDouble(&K_2DAttrZ[3].box, attr2D->k2_max, "");

	DrawInt(&K_2DAttrZ[4].box, attr2D->stwertx, 0);
	DrawInt(&K_2DAttrZ[5].box, attr2D->sweite,  0);
	DrawInt(&K_2DAttrZ[6].box, attr2D->stwerty, 0);
	DrawInt(&K_2DAttrZ[7].box, attr2D->sweite,  0);
}

void  DrawK_3DAttr()
/*
ͻ
 Zeichnet die Kommandozentrale fr die 3D-Attraktormanipulation.        
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    alle fr die 3D-Attraktordarstellung relevanten  
                       Parameter (Formeldarstellung)                    
                       K_3DAttr [] (Positionen der Buttons und          
                                    Eingabefelder)                      
                                                                        
ͼ
*/
{
	struct attraktor3D *attr3D;
	int i;

	DrawKommandozentrale(&Kommandozentrale);
	DrawBorder(13,336,295,440);
	DrawBorder(299,336,399,440);
	DrawBorder(403,336,484,440);
	DrawBorder(488,336,625,440);
	setcolor(EGA_BLACK);
	outtextxy(126,344,"Formeln");
	outtextxy(309,344,"Konstanten");
	outtextxy(406,344,"Startpkte");
	outtextxy(512,344,"Verschieben");
	outtextxy(325,404,"Punkte");
	outtextxy(27, 426,"Koordinatenkreuz:");
	for (i=0;i<13;i++)
		 Rechteck(&K_3DAttr[i].box);
	DrawButtons(K_3DATTR);
	attr3D = Fenster[AktivFenster].attr3D;
	DrawStr(&K_3DAttr[0].box, AlleFormeln[Koordinaten[attr3D->koor1].index],0);
	DrawStr(&K_3DAttr[1].box, AlleFormeln[Koordinaten[attr3D->koor2].index],0);
	DrawStr(&K_3DAttr[2].box, AlleFormeln[Koordinaten[attr3D->koor3].index],0);
	DrawKonst(&K_3DAttr[3], attr3D->top, 2);
	DrawStartwert(K_3DATTR);
	DrawLong(&K_3DAttr[5].box, Attraktor.n, 0);
}

void DrawK_3DAttrZ()
/*
ͻ
 Zeichnet die Kommandozentrale fr die 3D-Attraktormanipulation.        
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    alle fr die 3D-Attraktordarstellung relevanten  
                       Parameter (Zahlenreihendarstellung)              
                       K_3DAttrZ[] (Positionen der Buttons und          
                                    Eingabefelder)                      
                                                                        
ͼ
*/
{
	struct attraktor3D *attr3D;
	int i;

	DrawKommandozentrale(&Kommandozentrale);
	DrawBorder(13,336,222,440);
	DrawBorder(495,336,625,440);
	setcolor(EGA_BLACK);
	outtextxy(19,384,"x(n)=");
	outtextxy(19,404,"y(n)=");
	outtextxy(19,424,"z(n)=");
	outtextxy(131,384,"+");
	outtextxy(131,404,"+");
	outtextxy(131,424,"+");
	outtextxy(211,384,"n");
	outtextxy(211,404,"n");
	outtextxy(211,424,"n");
	outtextxy(70,344,"Start-");
	outtextxy(74,359,"werte");
	outtextxy(144,344,"Schritt-");
	outtextxy(152,359, "weite");
	outtextxy(512,344,"Verschieben");
	settextjustify(CENTER_TEXT,CENTER_TEXT);
	outtextxy(356,360,"Zahlenreihen");
	outtextxy(356,380,"Darstellung");
	outtextxy(356,400,"fr");
	outtextxy(356,420,"3D-Attraktoren");
	settextjustify(LEFT_TEXT,TOP_TEXT);
  for (i=0;i<6;i++)
		 Rechteck(&K_3DAttrZ[i].box);
	DrawButtons(K_3DATTRZ);
	attr3D = Fenster[AktivFenster].attr3D;

	DrawInt(&K_3DAttrZ[0].box, attr3D->stwertx, 0);
	DrawInt(&K_3DAttrZ[1].box, attr3D->sweite,  0);
	DrawInt(&K_3DAttrZ[2].box, attr3D->stwerty, 0);
	DrawInt(&K_3DAttrZ[3].box, attr3D->sweite,  0);
	DrawInt(&K_3DAttrZ[4].box, attr3D->stwertz, 0);
	DrawInt(&K_3DAttrZ[5].box, attr3D->sweite,  0);
}

void DrawK_Poincare(void)
/*
ͻ
 Zeichnet die Kommandozentrale fr die Poincaredarstellung.             
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    alle fr die Poincaredarstellung relevanten      
                       Parameter                                        
                       K_Poincare  (Positionen der Buttons und          
                                    Eingabefelder)                      
                                                                        
ͼ
*/
{
	struct poincare *poinc;

	poinc = Fenster[AktivFenster].poinc;
	DrawKommandozentrale(&Kommandozentrale);
	DrawBorder( 18,336,231,440);
	DrawBorder(243,336,327,440);
	DrawBorder(334,336,418,440);
	DrawBorder(425,336,509,440);
	DrawBorder(521,336,625,440);
	setcolor(EGA_BLACK);
	outtextxy(92, 344, "Formeln");
	outtextxy(257 ,344,"Punkt 1");
	outtextxy(347,344,"Punkt 2");
	outtextxy(439,344,"Punkt 3");
	outtextxy(528,344,"Verschieben");
	DrawButtons(K_POINCARE);
	DrawStr(&K_Poincare[14].box, AlleFormeln[Koordinaten[poinc->koor1].index],0);
	DrawStr(&K_Poincare[15].box, AlleFormeln[Koordinaten[poinc->koor2].index],0);
	DrawStr(&K_Poincare[16].box, AlleFormeln[Koordinaten[poinc->koor3].index],0);
	DrawDouble(&K_Poincare[0].box, poinc->x1, "");
	DrawDouble(&K_Poincare[1].box, poinc->y1, "");
	DrawDouble(&K_Poincare[2].box, poinc->z1, "");
	DrawDouble(&K_Poincare[3].box, poinc->x2, "");
	DrawDouble(&K_Poincare[4].box, poinc->y2, "");
	DrawDouble(&K_Poincare[5].box, poinc->z2, "");
	DrawDouble(&K_Poincare[6].box, poinc->x3, "");
	DrawDouble(&K_Poincare[7].box, poinc->y3, "");
	DrawDouble(&K_Poincare[8].box, poinc->z3, "");
}


void DrawK_PoincareZ(void)
/*
ͻ
 Zeichnet die Kommandozentrale fr die Poincaredarstellung fr ZR       
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    alle fr die Poincaredarstellung relevanten      
                       Parameter                                        
                       K_PoincareZ (Positionen der Buttons und          
                                    Eingabefelder)                      
                                                                        
ͼ
*/
{
	struct poincare *poinc;

	poinc = Fenster[AktivFenster].poinc;
	DrawKommandozentrale(&Kommandozentrale);
	DrawBorder(13,336,222,440);
	DrawBorder(238,336,322,440);
	DrawBorder(329,336,413,440);
	DrawBorder(420,336,504,440);
	DrawBorder(521,336,625,440);
	setcolor(EGA_BLACK);
	outtextxy(19,384,"x(n)=");
	outtextxy(19,404,"y(n)=");
	outtextxy(19,424,"z(n)=");
	outtextxy(131,384,"+");
	outtextxy(131,404,"+");
	outtextxy(131,424,"+");
	outtextxy(211,384,"n");
	outtextxy(211,404,"n");
	outtextxy(211,424,"n");
	outtextxy(70,344,"Start-");
	outtextxy(74,359,"werte");
	outtextxy(144,344,"Schritt-");
	outtextxy(152,359, "weite");
	outtextxy(257 ,344,"Punkt 1");
	outtextxy(342,344,"Punkt 2");
	outtextxy(434,344,"Punkt 3");
	outtextxy(528,344,"Verschieben");
	DrawButtons(K_POINCAREZ);
	DrawInt(&K_PoincareZ[0].box, poinc->stwertx, 0);
	DrawInt(&K_PoincareZ[1].box, poinc->sweite,  0);
	DrawInt(&K_PoincareZ[2].box, poinc->stwerty, 0);
	DrawInt(&K_PoincareZ[3].box, poinc->sweite,  0);
	DrawInt(&K_PoincareZ[4].box, poinc->stwertz, 0);
	DrawInt(&K_PoincareZ[5].box, poinc->sweite,  0);
	DrawDouble(&K_PoincareZ[6].box,  poinc->x1, "");
	DrawDouble(&K_PoincareZ[7].box,  poinc->y1, "");
	DrawDouble(&K_PoincareZ[8].box,  poinc->z1, "");
	DrawDouble(&K_PoincareZ[9].box,  poinc->x2, "");
	DrawDouble(&K_PoincareZ[10].box, poinc->y2, "");
	DrawDouble(&K_PoincareZ[11].box, poinc->z2, "");
	DrawDouble(&K_PoincareZ[12].box, poinc->x3, "");
	DrawDouble(&K_PoincareZ[13].box, poinc->y3, "");
	DrawDouble(&K_PoincareZ[14].box, poinc->z3, "");
}


void DrawKommandozentrale(pos)
struct box *pos;
/*
ͻ
 Zeichnet den Hintergrund der Kommandozentralen.                        
͹
                                                                        
 Eingabeparameter:     pos (Zeiger auf Ausmae der Kommandozentrale)    
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{
	ms_hide();
	setfillstyle(SOLID_FILL, EGA_LIGHTGRAY);
	bar(pos->x1,pos->y1,pos->x2,pos->y2);
	setcolor(EGA_BLACK);
	line(pos->x1,pos->y1,pos->x2,pos->y1);
	setcolor(EGA_DARKGRAY);
	line(pos->x2-7,pos->y1+7,pos->x1+7,pos->y1+7);
	line(pos->x1+7,pos->y1+7,pos->x1+7,pos->y2-7);
	setcolor(EGA_WHITE);
	line(pos->x1,pos->y1+1,pos->x2,pos->y1+1);
	line(pos->x1,pos->y2-1,pos->x2,pos->y2-1);
	line(pos->x1+7,pos->y2-7,pos->x2-7,pos->y2-7);
	line(pos->x2-7,pos->y2-7,pos->x2-7,pos->y1+7);
	ms_visible();
}



void Kommando(what)
int what;
/*
ͻ
 Zeichnet je nach bergebenem Parameter die entsprechende Kommando-     
 zentrale.                                                              
͹
                                                                        
 Eingabeparameter:     what (Code fr Kommandozentralen)                
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{
	int i;

	DrawKommandozentrale(&Kommandozentrale);
	switch(what)
	{
		case NOTHING:       setcolor(EGA_DARKGRAY);
								  for(i=0; i<2; i++) {
									  outtextxy(130+i, 350+i, "                    ESA V1.0");
									  outtextxy(130+i, 365+i, "        Editor fr seltsame Attraktoren");
									  outtextxy(134+i, 390+i, "                     1992");
									  outtextxy(130+i, 417+i, "Entwickelt an der Technischen Universitt Wien");
									  outtextxy(130+i, 427+i, "  (c) Harald Orovits und Raimund Oberreiter");
								  setcolor(EGA_WHITE);
								  }
								  break;
		case K_BIFURKATION: DrawK_Bifurk();
								  editindex=cursorindex=0;
								  editfield1=0;
								  break;
		case K_2DATTRZ:     DrawK_2DAttrZ();
								  break;
		case K_2DATTR:      DrawK_2DAttr();
								  break;
		case K_3DATTR:		  DrawK_3DAttr();
								  break;
		case K_3DATTRZ:     DrawK_3DAttrZ();
								  break;
		case K_POINCARE:    DrawK_Poincare();
								  break;
		case K_POINCAREZ:   DrawK_PoincareZ();
								  break;
		default: 			  break;
	}
}

int WhatButton(status)
int status;
/*
ͻ
 berprft welcher Button mit der Maus gedrckt wurde oder welches      
 Eingabefeld ausgewhlt wurde und liefert eine entsprechende Nummer     
 zurck.                                                                
͹
                                                                        
 Eingabeparameter:     status (augenblicklicher Zustand des ESA)        
 Ausgabeparameter:     keine                                            
 Returnwerte:          gedrckter Button oder gewhltes Eingabefeld     
 globale Variablen:    die Positionen aller Eingabefelder und Buttons   
                                                                        
ͼ
*/
{
	int i;

	if (status&MENUELEISTE)
		for (i=0;i<5;i++) if(ms_range(&Menueleiste[i].box)) return(Menueleiste[i].id);
	if (status&FENSTER1)
		for (i=0;i<2;i++) if(ms_range(&Fenster1[i].box)) return(Fenster1[i].id);
	if (status&FENSTER2)
		for (i=0;i<4;i++) if(ms_range(&Fenster2[i].box)) return(Fenster2[i].id);
	if (status&FENSTER3)
		for (i=0;i<6;i++) if(ms_range(&Fenster3[i].box)) return(Fenster3[i].id);
	if (status&M_FILE)
		for (i=0;i<5;i++) if(ms_range(&M_File[i].box)) return(M_File[i].id);
	if (status&M_GRAFIK)
		for (i=0;i<4;i++) if(ms_range(&M_Grafik[i].box)) return(M_Grafik[i].id);
	if (status&M_ORBIT2)
		for (i=0;i<3;i++) if(ms_range(&M_Orbit2[i].box)) return(M_Orbit2[i].id);
	if (status&M_ORBIT3)
		for (i=0;i<5;i++) if(ms_range(&M_Orbit3[i].box)) return(M_Orbit3[i].id);
	if (status&M_FENSTER)
		for (i=0;i<3;i++) if(ms_range(&M_Fenster[i].box)) return(M_Fenster[i].id);
	if (status&K_BIFURKATION)
		for (i=0;i<19;i++) if(ms_range(&K_Bifurkation[i].box)) return(K_Bifurkation[i].id);
	if (status&K_2DATTR)
		for (i=0;i<24;i++) if(ms_range(&K_2DAttr[i].box)) return(K_2DAttr[i].id);
	if (status&K_3DATTR)
		for (i=0;i<25;i++) if(ms_range(&K_3DAttr[i].box)) return(K_3DAttr[i].id);
	if (status&K_2DATTRZ)
		for (i=0;i<13;i++) if(ms_range(&K_2DAttrZ[i].box)) return(K_2DAttrZ[i].id);
	if (status&K_3DATTRZ)
		for (i=0;i<15;i++) if(ms_range(&K_3DAttrZ[i].box)) return(K_3DAttrZ[i].id);
	if (status&K_POINCARE)
		for (i=0;i<17;i++) if(ms_range(&K_Poincare[i].box)) return(K_Poincare[i].id);
	if (status&K_POINCAREZ)
		for (i=0;i<20;i++) if(ms_range(&K_PoincareZ[i].box)) return(K_PoincareZ[i].id);
	return(0);
}  /* WhatButton */

int WhatDLGButton(status)
int status;
/*
ͻ
 berprft welcher Button in einer Dialogbox mit der Maus gedrckt wurde
 oder welches Eingabefeld ausgewhlt wurde und liefert eine entsprech-  
 ende Nummer zurck.                                                    
͹
                                                                        
 Eingabeparameter:     status (aufgerufene Dialogbox)                   
 Ausgabeparameter:     keine                                            
 Returnwerte:          gedrckter Button oder gewhltes Eingabefeld     
 globale Variablen:    die Positionen aller Eingabefelder und Buttons   
                       smtlicher Dialogboxen                           
                                                                        
ͼ
*/
{
	int i;
	switch(status) {
		case DLG_FORMEL:
			for (i=1;i<42;i++) if(ms_range(&DLG_Formel[i].box))
									 return(DLG_Formel[i].id);
			break;
		case DLG_DATEI:
			for (i=1;i<16;i++) if(ms_range(&DLG_Datei[i].box))
									 return(DLG_Datei[i].id);
			break;
		case DLG_SETUP:
			for (i=1;i<8;i++) if(ms_range(&DLG_Setup[i].box))
									 return(DLG_Setup[i].id);
			break;
		case DLG_INFO:
			for (i=1;i<3;i++) if(ms_range(&DLG_Info[i].box))
								  return(DLG_Info[i].id);
			break;
	}
	return(0);
}

int DrawDlgInfo(toptext, text)
char *toptext;
char text[250];
/*
ͻ
 Zeichnet eine spezielle Dialogbox (Messagebox) auf den Bildschirm.     
 Besitzt nur zwei Buttons (OK bzw. Abbrechen) die in einer eigenen      
 Schleife behandelt werden.                                             
͹
                                                                        
 Eingabeparameter:     toptext (berschrift der Messagebox)             
                       text (Text, der in der Messagebox ausgegeben     
                             werden soll)                               
 Ausgabeparameter:     keine                                            
 Returnwerte:          1  OK-Button wurde gedrckt oder ENTER bettigt  
                       0  Abbrechen wurde gedrckt oder ESC bettigt    
 globale Variablen:    DLG_Info[] (Positionen der Buttons)              
                                                                        
ͼ
*/
{
	int but,med,i,j=0,size,x,y;
	char zeile[35];

	med = X3+(262/2);
	x=med;
	y=Y3+36;
	DrawKommandozentrale(&DLG_Info[0].box);
	settextjustify(CENTER_TEXT, CENTER_TEXT);
	setcolor(EGA_RED);
	outtextxy(med,Y3+16, toptext);
	setcolor(EGA_BLACK);
	size=strlen(text);
	for (i=0; i<size; i++) {
		zeile[j]=text[i];
		j++;
		if (text[i] == '\n') {
		  zeile[j-1]=0;
		  outtextxy(x,y, zeile);
		  y+=15;
		  j=0;
		} /* if */
	} /* for */
	zeile[j]=0;
	outtextxy(x,y, zeile);
	settextjustify(LEFT_TEXT, TOP_TEXT);
	DrawDLGButtons(DLG_INFO);
	for(;;)
	{
	  ms_visible();
	  while(ms_leftb());
	  while(!ms_leftb() && !bioskey(1));
	  if(!bioskey(1))  but = WhatDLGButton(DLG_INFO);
	  else {
		  char key=0;
		  key = (char)bioskey(0);
		  if (key==13) but = 198;
		  if (key==27) but = 197;
	  }
	  switch(but) {
		  case 197: ms_hide();
						button_on(&DLG_Info[1].box, DLG_Info[1].name);
						delay(200);
						button_off(&DLG_Info[1].box, DLG_Info[1].name);
						ms_visible();
						return(0);
		  case 198: ms_hide();
						button_on(&DLG_Info[2].box, DLG_Info[2].name);
						delay(200);
						button_off(&DLG_Info[2].box, DLG_Info[2].name);
						ms_visible();
						return(1);
		  default:  break;
	  }
	} /* for */
}  /* DrawDlgInfo() */

void DrawEmptyWindow()
/*
ͻ
 Lscht den Inhalt eines Fensters.                                      
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    WindowStatus (Fenstermdodus)                     
                       AktivFenster (aktives Fenster)                   
                       Fenster2[]   (Ausmae der Fenster im Zwei- bzw.  
                       Fenster3[]    Dreifenstermodus)                  
                                                                        
ͼ
*/
{
	struct fillsettingstype fillinfo;

	getfillsettings(&fillinfo);
	setfillstyle(SOLID_FILL, EGA_BLACK);
	if (WindowStatus == 2)
	{
		switch(AktivFenster)
		{
			case 1:  bar(Fenster2[0].box.x1+7, Fenster2[0].box.y1+7,
							 Fenster2[0].box.x2-7, Fenster2[0].box.y2-7);
						break;
			case 2:  bar(Fenster2[1].box.x1+7, Fenster2[1].box.y1+7,
							 Fenster2[1].box.x2-7, Fenster2[1].box.y2-7);
						break;
			default: break;
		}
	}
	if (WindowStatus == 3)
	{
		switch(AktivFenster)
		{
			case 3:  bar(Fenster3[0].box.x1+7, Fenster3[0].box.y1+7,
							 Fenster3[0].box.x2-7, Fenster3[0].box.y2-7);
						break;
			case 4:  bar(Fenster3[1].box.x1+7, Fenster3[1].box.y1+7,
							 Fenster3[1].box.x2-7, Fenster3[1].box.y2-7);
						break;
			case 5:  bar(Fenster3[2].box.x1+7, Fenster3[2].box.y1+7,
							 Fenster3[2].box.x2-7, Fenster3[2].box.y2-7);
						break;
			default: break;
		}
	}
	setfillstyle(fillinfo.pattern, fillinfo.color);
}


void DrawMeasure(obxodery)
int obxodery;
/*
ͻ
 Zeichnet die Maachsen in ein Fenster.                                 
͹
                                                                        
 Eingabeparameter:     obxodery (x oder y  Bemaung)                    
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{
	struct fillsettingstype fillinfo;
	struct box *box;
	int xy;
	char var[2];

	var[1] = 0;
	getfillsettings(&fillinfo);
	setcolor(EGA_RED);
	box = WhatWindow();
	setfillstyle(SOLID_FILL, EGA_BLACK);
	bar(box->x1+7, box->y2-18, box->x2-7, box->y2-7);
	bar(box->x2-18, box->y1+7, box->x2-7, box->y2-7);
	if(obxodery == 0) {  /* 0 .. x */
		// Feststellen der richtigen Variablen
		switch(Fenster[AktivFenster].what) {
			case K_POINCARE:
			case K_POINCAREZ:
				var[0]='H';
				break;
			case K_BIFURKATION:
				var[0] = Fenster[AktivFenster].bif->konstante;
				break;
			case K_2DATTR:
				var[0] = Koordinaten[Fenster[AktivFenster].attr2D->koor1].var;
				break;
			case K_2DATTRZ:
				var[0] = 'x';
				break;
		}
		// zeichnen des Pfeils
		xy = (box->x2 - box->x1)/2;
		setcolor(EGA_LIGHTRED);
		outtextxy(box->x1+12, box->y2-16, "-");
		outtextxy(box->x2-18, box->y2-16, "+");
		setcolor(EGA_RED);
		line(box->x1+22, box->y2-13, box->x1+xy-6, box->y2-13);
		outtextxy(box->x1+xy-4, box->y2-17, var);
		line(box->x1+xy+5, box->y2-13, box->x2- 23, box->y2-13);
		// Pfeilspitzen
		line(box->x1+22, box->y2-13, box->x1+26, box->y2-17);
		line(box->x1+22, box->y2-13, box->x1+26, box->y2-9);
		line(box->x2-23, box->y2-13, box->x2-27, box->y2-17);
		line(box->x2-23, box->y2-13, box->x2-27, box->y2-9);
	}
	else {
		// Feststellen der richtigen Variablen
		switch(Fenster[AktivFenster].what) {
			case K_POINCARE:
			case K_POINCAREZ:
				var[0]='V';
				break;
			case K_BIFURKATION:
				var[0] = Koordinaten[Fenster[AktivFenster].bif->koor].var;
				break;
			case K_2DATTR:
				var[0] = Koordinaten[Fenster[AktivFenster].attr2D->koor2].var;
				break;
			case K_2DATTRZ:
				var[0] = 'y';
				break;
		}
		// zeichnen des Pfeils
		xy = (box->y2 - box->y1)/2;
		setcolor(EGA_LIGHTRED);
		outtextxy(box->x2-16, box->y1+13, "+");
		outtextxy(box->x2-17, box->y2-18, "-");
		setcolor(EGA_RED);
		line(box->x2-13, box->y1+23, box->x2-13, box->y1+xy-5);
		outtextxy(box->x2-17, box->y1+xy-4, var);
		line(box->x2-13, box->y1+xy+5, box->x2-13, box->y2-23);
		line(box->x2-13, box->y1+23, box->x2-17, box->y1+27);
		line(box->x2-13, box->y1+23, box->x2-9,  box->y1+27);
		line(box->x2-13, box->y2-23, box->x2-17, box->y2-27);
		line(box->x2-13, box->y2-23, box->x2-9,  box->y2-27);
	}
	setcolor(fillinfo.color);
}


void  DrawScreen()
/*
ͻ
 Zeichnet den gesamten Bildschirm neu. Dies passiert zu Beginn des      
 Programmes oder wenn nicht genug Speicher zur Rettung des Hinter-      
 grundes zur Verfgung steht.                                           
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    WindowStatus (Status der Fenster)                
                       Fenster[]    (globale Fensterstruktur)           
                                                                        
ͼ
*/
{
	DrawButtons(MENUELEISTE);
	Window(WindowStatus);
	PrintStatus("                  ESA - Editor fr seltsame Attraktoren");
	Kommando(Fenster[AktivFenster].what);
}


//  Zeichne schwarzes Rechteck mit weiem Inhalt,
//	 gibt dann bergebene Zahl in diesem Feld in der Mitte aus.


void  DrawDouble(pos, number, offstring)
struct box *pos;   /* Rechteck in das gezeichnet wird */
double number;     /* Zahl die in String verwandelt wird */
char *offstring;   /* String wird ab offset Stelle in der Box ausgegeben */
{
	 char dummy[50];
	 char sou[50];
	 char dest[50];
	 int len;
	 int offlen;
	 int outpos;

	 dest[0]=0;   /* Initialisieren */
	 dummy[0]=0;
	 sou[0]=0;

	 offlen = _fstrlen(offstring);
	 len=(pos->x2-pos->x1-3)/8-offlen;   /* len Zeichen passen in das Rechteck */
	 // Double Zahl in einen String konvertieren
	 // und mit Offsetstring mergen.
	 sprintf(sou, "%lf", number);
	 _fstrncpy(dest, sou, len);
	 dest[len]=0;
	 _fstrcpy(dummy,offstring);
	 _fstrcpy(&dummy[_fstrlen(offstring)],dest);
	 dummy[len+_fstrlen(offstring)]=0;
	 // schwarzen Rahmen zeichnen
	 setcolor(EGA_BLACK);
	 rectangle(pos->x1,pos->y1,pos->x2,pos->y2);
	 // Inhalt wei fllen
	 setfillstyle(SOLID_FILL, EGA_WHITE);
	 bar(pos->x1+1,pos->y1+1,pos->x2-1,pos->y2-1);
	 // double Zahl in schwarz ausgeben
	 setcolor(EGA_BLACK);
	 outpos=((pos->y2-pos->y1)-8)/2;
	 outtextxy(pos->x1+5,pos->y1+outpos,dummy);
}


// Zeichne schwarzes Rechteck mit weiem Inhalt,
//	gibt dann bergebenen String in diesem Rechteck in der Mitte aus

void  DrawStr(pos, string, cursor)
struct box *pos;   /* Rechteck in das gezeichnet wird */
char *string;      /* auszugebende Zeichenkette */
int cursor;
{
	 char dest[50];
	 int len;
	 int outpos;

	 len=(pos->x2-pos->x1-3)/8;
	 strncpy(dest, string, len);
	 dest[len]=0;
	 // Zeichne schwarzen Rahmen
	 setcolor(EGA_BLACK);
	 rectangle(pos->x1,pos->y1,pos->x2,pos->y2);
	 // Innerhalb mit weier Flche ausfllen
	 setfillstyle(SOLID_FILL, EGA_WHITE);
	 bar(pos->x1+1,pos->y1+1,pos->x2-1,pos->y2-1);
	 // String in schwarz an richtiger Position ausgeben
	 setcolor(EGA_BLACK);
	 outpos=((pos->y2-pos->y1)-8)/2;
	 outtextxy(pos->x1+5,pos->y1+outpos,dest);
	 if(cursor) DrawCursor(pos->x1+13, pos->y1+4, EGA_LIGHTRED);
}


// Zeichne schwarzes Rechteck mit weiem Inhalt,
//	gibt dann bergebenen String in diesem Rechteck in der Mitte aus.

void  DrawInt(pos, n, cursor)
struct box *pos;   /* Rechteck in das gezeichnet wird */
int n;   			 /* auszugebende Integerzahl */
int cursor;        /* optional mit Cursor */
{
	 char dest[50], string[50];
	 int len;
	 int outpos;

	 // Integerzahl in String umwandeln
	 sprintf(string, "%d", n);
	 len=(pos->x2-pos->x1-3)/8;
	 strncpy(dest, string, len);
	 dest[len]=0;
	 // schwarzen Rahmen zeichnen
	 setcolor(EGA_BLACK);
	 rectangle(pos->x1,pos->y1,pos->x2,pos->y2);
	 // weien Inhalt zeichnen
	 setfillstyle(SOLID_FILL, EGA_WHITE);
	 bar(pos->x1+1,pos->y1+1,pos->x2-1,pos->y2-1);
	 // Text in schwarz ausgeben
	 setcolor(EGA_BLACK);
	 outpos=((pos->y2-pos->y1)-8)/2;
	 outtextxy(pos->x1+5,pos->y1+outpos,dest);
	 // auf Wunsch Cursor zeichnen
	 if(cursor) DrawCursor(pos->x1+10, pos->y1+4, EGA_LIGHTRED);
}


//  Zeichne schwarzes Rechteck mit weiem Inhalt,
//	 gibt dann bergebenen String in diesem Rechteck in der Mitte aus.

void  DrawLong(pos, n, cursor)
struct box *pos;   /* Rechteck in das gezeichnet wird */
unsigned long n;   /* auszugebende Longzahl */
int cursor;        /* optional mit Cursor */
{
	 char dest[50], string[50];
	 int len;
	 int outpos;

	 // Longzahl in String umwandeln
	 sprintf(string, "%ld", n);
	 len=(pos->x2-pos->x1-3)/8;
	 strncpy(dest, string, len);
	 dest[len]=0;
	 // schwarzen Rahmen zeichnen
	 setcolor(EGA_BLACK);
	 rectangle(pos->x1,pos->y1,pos->x2,pos->y2);
	 // Inhalt des Rechtecks in wei halten
	 setfillstyle(SOLID_FILL, EGA_WHITE);
	 bar(pos->x1+1,pos->y1+1,pos->x2-1,pos->y2-1);
	 // Text in schwarz ausgeben
	 setcolor(EGA_BLACK);
	 outpos=((pos->y2-pos->y1)-8)/2;
	 outtextxy(pos->x1+5,pos->y1+outpos,dest);
	 // Auf Wunsch mit Cursor
	 if(cursor) DrawCursor(pos->x1+10, pos->y1+4, EGA_LIGHTRED);
}


// Darstellung der Konstantenliste ab dem Editierfeld Button.
// Beginne ab der Konstanten top und zeichne num Konstantenfelder

void  DrawKonst(Button, top, num)
struct button *Button;  // erstes Editierfeld
int 	 top;             // oberste Konstante
int    num;             // Anzahl der darzustellenden Felder
{
	int anz,i;
	char konst[26], string[30];

	anz=GetCL(konst);
	if ((anz-top)<num) anz=anz-top;
	if (anz>num) anz=num;
	// Felder mit Konstantenwerten fllen
	for(i=0;i<anz;i++)
	{
		string[0]=konst[i+top];
		string[1]='=';
		string[2]=0;
		DrawDouble(&Button[i].box, var_const_list[konst[i+top]-97].fvalue, string);
	} /* for */
	// Fllen der restlichen, nicht bentigten Felder
	for(;i<num;i++)  Rechteck(&(Button[i].box));
}


// Startwertliste zeichnen.

void  DrawStartwert(what)
int what;     // welche Startwertliste soll gezeichnet werden?
{
		int i;
		char s[4];
		struct attraktor2D *attr2D;
		struct attraktor3D *attr3D;

		setcolor(EGA_BLACK);
		s[1] = s[2] = s[3] = 0;
		switch(what) {
			case K_BIFURKATION:
								 // Bifurkation
								 // Startwert ausgeben
								 DrawDouble(&K_Bifurkation[9].box, Attraktor.stpkte[Fenster[AktivFenster].bif->koor],"");
								 setfillstyle(SOLID_FILL,EGA_LIGHTGRAY); bar(17,424,23,432); setcolor(EGA_BLACK);
								 // mit richtiger Koordinate beschriften
								 s[0] = Koordinaten[Fenster[AktivFenster].bif->koor].var;
								 outtextxy(17,424,s);
								 break;
			case K_2DATTR:
								 // 2D Attraktor
								 attr2D=Fenster[AktivFenster].attr2D;
								 // Inhalt der 1.Koordinate lschen
								 setfillstyle(SOLID_FILL, EGA_LIGHTGRAY);
								 bar(422,364,440,392);
								 // 1. Koordinate beschriften
								 s[0]=Koordinaten[attr2D->koor1].var;
								 s[1]=attr2D->akt_stpkt+48;
								 outtextxy(422,364,s);
								 // Inhalt der 2.Koordinate lschen
								 setfillstyle(SOLID_FILL,EGA_LIGHTGRAY);
								 bar(17,404,23,432);
								 // 2. Koordinate beschriften
								 setcolor(EGA_BLACK);
								 s[1]=0; outtextxy(17,404,s);
								 s[0]=Koordinaten[attr2D->koor2].var;
								 s[1]=attr2D->akt_stpkt+48;
								 outtextxy(422,384,s);
								 s[1]=0; outtextxy(17,424,s);
								 // Zahlen reinschreiben
								 DrawDouble(&K_2DAttr[10].box, Attraktor.stpkte[anzKoor*(attr2D->akt_stpkt-1)+attr2D->koor1], "");
								 DrawDouble(&K_2DAttr[11].box, Attraktor.stpkte[anzKoor*(attr2D->akt_stpkt-1)+attr2D->koor2], "");
								 break;
			case K_3DATTR:
								 // 3D Attraktor
								 attr3D=Fenster[AktivFenster].attr3D;
								 // Platz fr Koordinaten freimachen
								 setfillstyle(SOLID_FILL, EGA_LIGHTGRAY);
								 bar(408,364,423,420);
								 // Koordinaten rausschreiben
								 s[0]=Koordinaten[attr3D->koor1].var;
								 s[1]=attr3D->akt_stpkt+48;
								 outtextxy(408,364,s);
								 s[0]=Koordinaten[attr3D->koor2].var;
								 s[1]=attr3D->akt_stpkt+48;
								 outtextxy(408,384,s);
								 s[0]=Koordinaten[attr3D->koor3].var;
								 s[1]=attr3D->akt_stpkt+48;
								 outtextxy(408,404,s);
								 // Alle drei Werte reinschreiben
								 DrawDouble(&K_3DAttr[6].box, Attraktor.stpkte[anzKoor*(attr3D->akt_stpkt-1)+attr3D->koor1], "");
								 DrawDouble(&K_3DAttr[7].box, Attraktor.stpkte[anzKoor*(attr3D->akt_stpkt-1)+attr3D->koor2], "");
								 DrawDouble(&K_3DAttr[8].box, Attraktor.stpkte[anzKoor*(attr3D->akt_stpkt-1)+attr3D->koor3], "");
								 break;
			case DLG_FORMEL:
								 // Formeldialogbox
								 s[2]='=';
								 s[1]=(char) Modi.akt_stpkt+48;
								 // Arbeiten mit den Kopiien der Originalwerte,
								 // da der Anwender spter ABBRECHEN knnte.
								 for(i=0; i<10; i++) {
										if(NewKoordinaten[i].index==-1) Rechteck(&DLG_Formel[11+i].box);
										else {
											 s[0]=NewAlleFormeln[NewKoordinaten[i].index][0];
											 DrawDouble(&DLG_Formel[11+i].box, Modi.stpkte[10*(Modi.akt_stpkt-1)+i], s);
										}
								 }
								 break;
			}
}


void  draw_string(rect, text, col)
struct box *rect;
char *text;
int col;
/*
ͻ
 Gibt einen Text innerhalb eines rechteckigen Bereiches in der ge-      
 wnschten Farbe aus.                                                   
͹
                                                                        
 Eingabeparameter:     rect (Zeiger auf rechteckigen Bereich)           
                       text (Zeiger auf String)                         
                       col  (Farbe des Textes)                          
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{
	int center_x;
	int center_y;
	unsigned int color;
	struct textsettingstype text_info;
	int height;
	int width;
	int t_height;
	int t_width;

	color = getcolor();
	gettextsettings(&text_info);
	setwritemode(0);
	setcolor(col);

	height = rect->y2 - rect->y1;
	width = rect->x2 - rect->x1;
	t_height = textheight(text);
	t_width = textwidth(text);
	if ((height < t_height) || (width < t_width))
	{
		settextstyle(SMALL_FONT, HORIZ_DIR, 4);
		if (height - t_height < width - t_width)
			setusercharsize(height, t_height, height, t_height);
		else
			setusercharsize(width, t_width, width, t_width);
	}
	else
		settextstyle(DEFAULT_FONT, HORIZ_DIR, 1);
	settextjustify(CENTER_TEXT, CENTER_TEXT);
	center_y = height/2 + rect->y1;
	center_x = width/2 + rect->x1;
	outtextxy(center_x, center_y, text);

	setcolor(color);
	settextstyle(text_info.font, text_info.direction, text_info.charsize);
	settextjustify(text_info.horiz, text_info.vert);
}

void  button_off(pos, name)
struct box *pos;
char *name;
/*
ͻ
 Zeichnet einen plastisch wirkenden nicht gedrckten Button.            
͹
                                                                        
 Eingabeparameter:     pos  (Zeiger auf Position des Buttons)           
                       name (Beschriftung des Buttons)                  
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{
	struct fillsettingstype fill_info;
	unsigned int color;

	ms_hide();
	getfillsettings(&fill_info);
	color = getcolor();

	setcolor(EGA_BLACK);
	setwritemode(0);
	setfillstyle(SOLID_FILL, EGA_WHITE);
	bar(pos->x1, pos->y1, pos->x2, pos->y2);

	setfillstyle(SOLID_FILL, EGA_DARKGRAY);
	bar(pos->x1+3, pos->y1+3, pos->x2, pos->y2);
	putpixel(pos->x2, pos->y1+1,EGA_DARKGRAY);
	putpixel(pos->x2, pos->y1+2,EGA_DARKGRAY);
	putpixel(pos->x2-1, pos->y1+2,EGA_DARKGRAY);
	putpixel(pos->x2, pos->y1,EGA_DARKGRAY);
	putpixel(pos->x2-1, pos->y1+1,EGA_DARKGRAY);
	putpixel(pos->x2-2, pos->y1+2,EGA_DARKGRAY);
	putpixel(pos->x1, pos->y2,EGA_DARKGRAY);
	putpixel(pos->x1+1, pos->y2,EGA_DARKGRAY);
	putpixel(pos->x1+2, pos->y2,EGA_DARKGRAY);
	putpixel(pos->x1+1, pos->y2-1,EGA_DARKGRAY);
	putpixel(pos->x1+2, pos->y2-1,EGA_DARKGRAY);
	putpixel(pos->x1+2, pos->y2-2,EGA_DARKGRAY);
	setfillstyle(SOLID_FILL, EGA_LIGHTGRAY);
	bar(pos->x1 + 3, pos->y1 + 3, pos->x2 - 3, pos->y2 - 3);

	draw_string(pos, name, EGA_BLACK);

	setcolor(color);
	setfillstyle(fill_info.pattern, fill_info.color);
	ms_visible();
}

void  button_on(pos, name)
struct box *pos;
char *name;
/*
ͻ
 Zeichnet einen plastisch wirkenden gedrckten Button.                  
͹
                                                                        
 Eingabeparameter:     pos  (Zeiger auf Position des Buttons)           
                       name (Beschriftung des Buttons)                  
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{
	struct box bx;

	struct fillsettingstype fill_info;
	struct linesettingstype line_info;
	unsigned int color;

	ms_hide();
	getfillsettings(&fill_info);
	getlinesettings(&line_info);
	color = getcolor();

	setcolor(EGA_BLACK);
	setwritemode(0);
	setfillstyle(SOLID_FILL, EGA_DARKGRAY);
	bar(pos->x1, pos->y1, pos->x2, pos->y2);
	setlinestyle(SOLID_LINE, 0, 1);
	line(pos->x1+1, pos->y2-1, pos->x1+1, pos->y1+1);
	line(pos->x1+1, pos->y1+1, pos->x2-1, pos->y1+1);
	setcolor(EGA_LIGHTGRAY);
	line(pos->x1+1, pos->y2-1, pos->x2-1, pos->y2-1);
	line(pos->x2-1, pos->y2-1, pos->x2-1, pos->y1+1);

	bx.x1 = pos->x1+1;
	bx.x2 = pos->x2+1;
	bx.y1 = pos->y1+1;
	bx.y2 = pos->y2+1;
	draw_string(&bx, name, EGA_BLACK);

	setcolor(color);
	setfillstyle(fill_info.pattern, fill_info.color);
	setlinestyle(line_info.linestyle, line_info.upattern, line_info.thickness);
	ms_visible();
}

void  Dbutton(button)
struct button *button;
/*
ͻ
 Zeichnet einen gedrckten oder nicht gedrckten Button, je nach dem    
 ob die Variable button.pressed auf Eins oder Null gesetzt ist.         
͹
                                                                        
 Eingabeparameter:     button  (Zeiger auf den Button)                  
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    keine                                            
                                                                        
ͼ
*/

{
	if(button->pressed) button_on(&(button->box), button->name);
	else button_off(&(button->box), button->name);
}

void  DrawWindow(pos)
struct box *pos;
/*
ͻ
 Zeichnet ein schwarzes Ausgabefenster mit plastisch wirkendem Rahmen.  
͹
                                                                        
 Eingabeparameter:     pos  (Ausmae des Fensters)                      
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    keine                                            
                                                                        
ͼ
*/

{
	int i;
	ms_hide();

//	setfillstyle(SOLID_FILL, EGA_WHITE);
//	bar(pos->x1,pos->y1,pos->x2,pos->y2);
//	setfillstyle(SOLID_FILL, EGA_LIGHTGRAY);
//	bar(pos->x1+2,pos->y1+2,pos->x2-2,pos->y2-2);

	setcolor(EGA_WHITE);
	for (i=0; i<2; i++)
		rectangle(pos->x1+i, pos->y1+i, pos->x2-i, pos->y2-i);
	setcolor(EGA_LIGHTGRAY);
	for (i=2; i<8; i++)
		rectangle(pos->x1+i, pos->y1+i, pos->x2-i, pos->y2-i);
	setfillstyle(SOLID_FILL, EGA_BLACK);
	bar(pos->x1+7,pos->y1+7,pos->x2-7,pos->y2-7);

	setcolor(EGA_BLACK);
	line(pos->x1+4,pos->y1+4,pos->x2-4,pos->y1+4);
	line(pos->x1+4,pos->y1+4,pos->x1+4,pos->y2-4);
	setcolor(EGA_WHITE);
	line(pos->x1+5,pos->y2-4,pos->x2-4,pos->y2-4);
	line(pos->x2-4,pos->y2-4,pos->x2-4,pos->y1+5);
	setfillstyle(SOLID_FILL, EGA_DARKGRAY);
	bar(pos->x1+1,pos->y2-1,pos->x2,pos->y2);
	bar(pos->x2-1,pos->y1+1,pos->x2,pos->y2);
	putpixel(pos->x1, pos->y2, EGA_DARKGRAY);
	putpixel(pos->x2, pos->y1, EGA_DARKGRAY);
	ms_visible();
}

void  Window(anz)
int anz;
/*
ͻ
 Zeichnet, je nach dem ob anz 1, 2 oder 3 ist, eines, zwei oder drei    
 Ausgabefenster auf den Bildschirm, inklusive der Buttons zum Um-       
 schalten zwischen den dargestellten Fenstern.                          
͹
                                                                        
 Eingabeparameter:     anz  (Anzahl der zu zeichnenden Fenster)         
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    Fenster1[] (Fensterausmae im Einbildmodus)      
                       Fenster2[] (Fensterausmae im Zweibildmodus)     
                       Fenster3[] (Fensterausmae im Dreibildmodus)     
                                                                        
ͼ
*/
{
	switch(anz)
	{
		case 1:DrawWindow(&Fenster1[0].box);
				 DrawButtons(FENSTER1);
				 break;
		case 2:DrawWindow(&Fenster2[0].box);
				 DrawWindow(&Fenster2[1].box);
				 DrawButtons(FENSTER2);
				 break;
		case 3:DrawWindow(&Fenster3[0].box);
				 DrawWindow(&Fenster3[1].box);
				 DrawWindow(&Fenster3[2].box);
				 DrawButtons(FENSTER3);
				 break;
	}
}

struct box  *WhatWindow()
/*
ͻ
 Liefert die Ausmae des gerade aktiven Fensters.                       
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          box   (Ausmae des aktiven Fensters)             
 globale Variablen:    Fenster1[] (Fensterausmae im Einbildmodus)      
                       Fenster2[] (Fensterausmae im Zweibildmodus)     
                       Fenster3[] (Fensterausmae im Dreibildmodus)     
                                                                        
ͼ
*/
{
	switch(AktivFenster)
	{
		case 0: return(&Fenster1[0].box);
		case 1:
		case 2: return(&Fenster2[AktivFenster-1].box);
		case 3:
		case 4:
		case 5: return(&Fenster3[AktivFenster-3].box);
	}
	return(&Fenster1[0].box); /* Sollte nie zutreffen ! */
}

struct button  *WhatWindowButton()
/*
ͻ
 Liefert Zeiger auf den Button zum aktiven Fenster.                     
͹
                                                                        
 Eingabeparameter:     keine                                            
 Ausgabeparameter:     keine                                            
 Returnwerte:          button (Zeiger auf aktiven Fensterbutton)        
 globale Variablen:    Fenster1[], Fenster2[], Fenster3[]               
                                                                        
ͼ
*/
{
	switch(AktivFenster)
	{
		case 0: return(&Fenster1[1]);
		case 1:
		case 2: return(&Fenster2[AktivFenster+1]);
		case 3:
		case 4:
		case 5: return(&Fenster3[AktivFenster]);
	}
	return(NULL);
}


void  DrawButtons(status)
int status;
/*
ͻ
 Zeichnet je nach bergebenem Status die zugehrigen Buttons.           
͹
                                                                        
 Eingabeparameter:     status (Programmstatus)                          
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    alle Variablen, die Buttonpositionen enthalten   
                                                                        
ͼ
*/
{
	int i;

	if (status&MENUELEISTE) for (i=0;i<5;i++) Dbutton(&Menueleiste[i]);
	if (status&FENSTER1)    for (i=1;i<2;i++) Dbutton(&Fenster1[i]);
	if (status&FENSTER2)    for (i=2;i<4;i++) Dbutton(&Fenster2[i]);
	if (status&FENSTER3)    for (i=3;i<6;i++) Dbutton(&Fenster3[i]);
	if (status&M_FILE)      for (i=0;i<5;i++) Dbutton(&M_File[i]);
	if (status&M_GRAFIK)    for (i=0;i<4;i++) Dbutton(&M_Grafik[i]);
	if (status&M_ORBIT2)    for (i=0;i<3;i++) Dbutton(&M_Orbit2[i]);
	if (status&M_ORBIT3)    for (i=0;i<5;i++) Dbutton(&M_Orbit3[i]);
	if (status&M_FENSTER)   for (i=0;i<3;i++) Dbutton(&M_Fenster[i]);
	if (status&K_BIFURKATION) for (i=12;i<19;i++) Dbutton(&K_Bifurkation[i]);
	if (status&K_2DATTR)    for (i=13;i<24;i++) Dbutton(&K_2DAttr[i]);
	if (status&K_2DATTRZ)   for (i=8;i<13;i++) Dbutton(&K_2DAttrZ[i]);
	if (status&K_3DATTR)    for (i=9;i<25;i++) Dbutton(&K_3DAttr[i]);
	if (status&K_3DATTRZ)   for (i=6;i<15;i++) Dbutton(&K_3DAttrZ[i]);
	if (status&K_POINCARE)  for (i=9;i<14;i++) Dbutton(&K_Poincare[i]);
	if (status&K_POINCAREZ)  for (i=15;i<20;i++) Dbutton(&K_PoincareZ[i]);
}

void  DrawDLGButtons(status)
int status;
/*
ͻ
 Zeichnet je nach bergebenem Status die Buttons zu den entsprech-      
 enden Dialogboxen (File, Formel, ...).                                 
͹
                                                                        
 Eingabeparameter:     status (Dialogbox)                               
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    DLG_Formel[] (Buttons der Formeldialogbox)       
                       DLG_Datei[]  (Buttons der Dateidialogbox)        
                       DLG_Setup[]  (Buttons der Setupdialogbox)        
                       DLG_Info[]   (Buttons der Infodialogbox)         
                                                                        
ͼ
*/
{
	int i;
	switch(status) {
		case DLG_FORMEL: for (i=21;i<42;i++) Dbutton(&DLG_Formel[i]);break;
		case DLG_DATEI : for (i=7;i<16;i++) Dbutton(&DLG_Datei[i]);break;
		case DLG_SETUP : for (i=6;i<8;i++) Dbutton(&DLG_Setup[i]);break;
		case DLG_INFO  : for (i=1;i<3;i++) Dbutton(&DLG_Info[i]);break;
		default        : break;

  }
}


void  DrawStatuszeile(pos)
struct box *pos;
/*
ͻ
 Zeichnet die Statuszeile.                                              
͹
                                                                        
 Eingabeparameter:     pos   (Abmessungen der Statuszeile)              
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{
	ms_hide();
  setcolor(EGA_BLACK);
  line(pos->x1,pos->y1,pos->x2,pos->y1);
  setcolor(EGA_WHITE);
  line(pos->x1,pos->y1+1,pos->x2,pos->y1+1);
  setcolor(EGA_LIGHTGRAY);
  line(pos->x1,pos->y1+2,pos->x2,pos->y1+2);
  setfillstyle(SOLID_FILL, EGA_LIGHTGRAY);
  bar(pos->x1,pos->y1+3,pos->x2,pos->y2);
  setcolor(EGA_DARKGRAY);
  line(pos->x1+10,pos->y1+3,pos->x2-10,pos->y1+3);
  line(pos->x1+10,pos->y1+3,pos->x1+10,pos->y2-1);
  setcolor(EGA_WHITE);
  line(pos->x1+10,pos->y2-1,pos->x2-10,pos->y2-1);
  line(pos->x2-10,pos->y1+3,pos->x2-10,pos->y2-1);
  if(inserttoggle) {
	  setcolor(EGA_DARKGRAY);
	  line(pos->x2-38,pos->y1+3,pos->x2-38,pos->y2-1);
	  setcolor(EGA_WHITE);
	  line(pos->x2-43,pos->y1+3,pos->x2-43,pos->y2-1);
	  setcolor(EGA_LIGHTGRAY);
	  bar(pos->x2-42, pos->y1+2, pos->x2-39, pos->y2-1);
	  setcolor(EGA_BLACK);
	  outtextxy(pos->x2-36, pos->y1+7, "INS");
  }
  ms_visible();
}

void  PrintStatus(char *string)
/*
ͻ
 Gibt Meldung in der Statuszeile aus. Etwaige vorhergehenden Meldungen  
 werden gelscht.                                                       
͹
                                                                        
 Eingabeparameter:     string  (auszugebende Meldung)                   
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    Statuszeile[]                                    
                                                                        
ͼ
*/
{
	char str2[80];
	int i;

	for(i=0; i<80; i++) str2[i]='\0';
	strncpy(str2, string, 80);     /* Max. 80 Zeichen */
	if(strlen(string)<80) str2[strlen(string)]='\0';
	else str2[80]='\0';
	DrawStatuszeile(&Statuszeile);
	setcolor(EGA_BLACK);
	outtextxy(20, 467, str2);
}

void  DrawBorder(x1,y1,x2,y2)
int x1,x2,y1,y2;
/*
ͻ
 Zeichnet einen plastisch wirkenden Rahmen. Wird vor allem bei der Ge-  
 staltung der Kommandozentrale verwendet.                               
͹
                                                                        
 Eingabeparameter:     x1, y1  (linke obere Ecke des Rahmens)           
                       x2, y2  (rechte untere Ecke des Rahmens)         
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{
	ms_hide();
	setcolor(EGA_WHITE);
	line(x1,y1,x1,y2);
	line(x1,y1,x2,y1);
	setcolor(EGA_DARKGRAY);
	line(x2,y1,x2,y2);
	line(x2,y2,x1,y2);
	ms_visible();
}

void  Rechteck(pos)
struct box *pos;
/*
ͻ
 Zeichnet ein Eingabefeld (weies Reckteck mit schwarzem Rahmen).       
͹
                                                                        
 Eingabeparameter:     pos   (Ausmae des Eingabefeldes)                
 Ausgabeparameter:     keine                                            
 Returnwerte:          keine                                            
 globale Variablen:    keine                                            
                                                                        
ͼ
*/
{
	setcolor(EGA_BLACK);
	rectangle(pos->x1,pos->y1,pos->x2,pos->y2);
	setfillstyle(SOLID_FILL,EGA_WHITE);
	bar(pos->x1+1,pos->y1+1,pos->x2-1,pos->y2-1);
}
