#include <iostream>
#include <stdlib.h>

#include "FlowData.h"

int main(int argc, char** argv)
{
	printf("Hello student :)\n");
	
	FlowData* dataset = new FlowData();
	//load a dataset, an example path is given
	bool result = dataset->loadDataset("H:\\Work\\Courses\\VisLu WS0708\\Bsp2\\Daten\\hurricane_timeseries\\hurricane_p_tc",false);
	//exit if the loading was not successful
	if (!result) {system("PAUSE"); return 1;}

	//copies the geometry into a new channel
	int chX = dataset->createChannelGeometry(0);
	int chY = dataset->createChannelGeometry(1);
	//in the data sets for the VisLU, the velocity vector is stored in the first three floats, thus channels 0, 1, and 2 contain its x, y, z components
	//this command creates a channel with the velocity magnitude
	int vel = dataset->createChannelVectorLength(0,1,2);

	//aproximate velocity magnitude value in the middle
	//we take the velocity magnitude channel created at the previous line and ask for its value at position 0.5, 0.5 of normalized dataset coordinates (both dimensions scaled to floats from 0..1)
	std::cout << dataset->getChannel(vel)->getValueNormPos(vec3(0.5,0.5)) << std::endl;

	//memory clean up
	delete dataset;
	system("PAUSE");
	return 0;
}

