﻿
varying mat2 rotm;
uniform sampler2D directionTexture;
uniform sampler2D magnitudeTexture;
uniform float sizeFactor;

void main()
{
	float pi = 3.141592;
	vec2 dir = texture2D(directionTexture, vec2(1.0 - gl_MultiTexCoord0.y, gl_MultiTexCoord0.x)).xy;
	float mag = texture2D(magnitudeTexture, vec2(1.0 - gl_MultiTexCoord0.y, gl_MultiTexCoord0.x)).x;
	
	dir.x -= 0.5;
	dir.y -= 0.5;
	
	dir = normalize(dir);
	
	float winkel = acos(dir.x);
	
	if (dir.y < 0.0)
	{
		winkel = (2.0*pi) - winkel;
	}
		
	rotm = mat2(cos(winkel), -sin(winkel), sin(winkel), cos(winkel));	

	gl_PointSize = (10.0 + mag*30.0) * (sizeFactor / 10.0);
	gl_Position = ftransform();
}