uniform float channelRange;
uniform sampler2D channelTex;

uniform vec3 color1;
uniform vec3 color2;

vec4 HSVtoRGB(float h, float s, float v) {
        float f, hTemp, p, q, t;
        int i;
        vec3 result = vec3(0.0);

        if(s == 0.0) {
                // Achromatic color
                result = vec3(v);
                return vec4(result, 1.0);
        }

        if(h < 0.0)
                h += 1.0;
        if(h >= 1.0)
                h -= 1.0;


        hTemp = h * 6.0;
        i = int(floor(hTemp));
        f = hTemp - float(i);

        p = v * (1.0 - s);
        q = v * (1.0 - (s * f));
        t = v * (1.0 - (s * (1.0 - f)));

        if(i == 0)
                result = vec3(v, t, p);
        else if(i == 1)
                result = vec3(q, v, p);
        else if(i == 2)
                result = vec3(p, v, t);
        else if(i == 3)
                result = vec3(p, q, v);
        else if(i == 4)
                result = vec3(t, p, v);
        else if(i == 5)
                result = vec3(v, p, q);

        return vec4(result, 1.0);
}


void main()
{
    float intensity = texture2D(channelTex, gl_TexCoord[0].xy).r;
    gl_FragColor = vec4(mix(color1, color2, intensity), 1.0);
}
