uniform sampler2D channel0Tex;
uniform sampler2D channel1Tex;

uniform float pointSize;

uniform int fixedSize;

void main()
{
	gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
	gl_TexCoord[0] = gl_MultiTexCoord0;

        // map auf 0..1
        vec2 position = (gl_Vertex.xy- gl_PointSize) / 800.0;

	float velocityX = texture2D(channel0Tex, position.xy).x;
        float velocityY = -texture2D(channel1Tex, position.xy).x;
	
        // map auf -1..1 fr Winkel Berechnung
        velocityX = (velocityX * 2.0 - 1.0);
        velocityY = (velocityY * 2.0 + 1.0);

	vec2 velocity = vec2(velocityX, velocityY);

        //0.2 wird zu lnge addiert damit auch bei sehr kleinen Werten ein Pfeil sichtbar wird
        float magnitude = (0.2 + length(velocity))/1.2;
        gl_PointSize = pointSize * magnitude * 2.0;
	
        if(fixedSize == 1)
            gl_PointSize = pointSize;

	velocity = normalize(velocity);

        // Winkelberechnung
        float angle = acos(velocity.x/length(velocity));

        //da velocity normalisiert wurde is der winkel nur noch von x abhngig, somit muss
        //in y Richtung im quadranten 3 und 4 der winkel angepasst werden
        if(velocityY < 0.0) angle = 2.0*3.1415926535 - angle;

        // winkel wird in texcoord abgespeichert um diesen im fragment shader zur verfgung zu haben
        gl_TexCoord[1].x = angle;
        gl_TexCoord[1].y = magnitude;
}
