uniform sampler2D arrowTex;

uniform vec3 color1;
uniform vec3 color2;

void main()
{
        float cos = cos(gl_TexCoord[1].x);
        float sin = sin(gl_TexCoord[1].x);
        float magnitude = gl_TexCoord[1].y;

        //Rotation um die z-Achse
        mat2 rotmat = mat2(cos, -sin, sin, cos);
	
        //map auf -1..1 fr rotation
        vec2 rotTex = gl_TexCoord[0].xy * 2.0 - 1.0;

        //Rotation
        rotTex = rotmat * rotTex;

        //map auf 0..1
        rotTex = (rotTex + 1.0) * 0.5;

        rotTex.x = clamp(rotTex.x, 0.0 , 1.0);
        rotTex.y = clamp(rotTex.y, 0.0 , 1.0);


        gl_FragColor = texture2D(arrowTex, rotTex.xy);
        gl_FragColor.xyz = mix(color1, color2, magnitude) * 0.7;
}
