varying vec4 gl_TexCoord[];

uniform sampler2D channel0;
uniform sampler2D channel1;
uniform sampler2D channel3;
uniform sampler2D channel4;

uniform sampler1D transferfunction1;
uniform sampler1D transferfunction2;

uniform sampler2D arrows;
uniform sampler2D streamlines;
uniform sampler2D streamlines_glyphs;

uniform bool show_arrows;
uniform bool show_streamlines;
uniform bool show_glyphs;

uniform float alpha_streamlines;

uniform bool add_streamlines; //if false, subtract

uniform int colorcoding;    //0 = channel3 and tf1, 1=channel4 and tf2

void main(void)
{
    vec2 my_texcoord = vec2(gl_TexCoord[1].t, 1.0 - gl_TexCoord[1].s);
    vec2 my_glyph_texcoord = vec2(my_texcoord.s, 1.0 - my_texcoord.t);

    gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0);

    if (colorcoding == 1 || colorcoding == 0)
	gl_FragColor += texture1D(transferfunction1, texture2D(channel3, gl_TexCoord[0].st).r);

    if (colorcoding == 2 || colorcoding == 0)
	gl_FragColor += texture1D(transferfunction2, texture2D(channel4, gl_TexCoord[0].st).r);

    if (show_arrows)
	gl_FragColor += texture2D(arrows, my_texcoord) * texture2D(arrows, my_texcoord).a;

    if (show_streamlines)
    {
	if (add_streamlines)
	    gl_FragColor += texture2D(streamlines, my_texcoord) * alpha_streamlines;
	else
	    gl_FragColor -= texture2D(streamlines, my_texcoord) * alpha_streamlines;
    }

    if (show_glyphs && add_streamlines)
	gl_FragColor += texture2D(streamlines_glyphs, my_glyph_texcoord) * alpha_streamlines;
    if (show_glyphs && !add_streamlines)
	gl_FragColor -= texture2D(streamlines_glyphs, my_glyph_texcoord) * alpha_streamlines;

}
