#pragma once

#ifndef MYQGLWIDGET_H
#define MYQGLWIDGET_H

#include <GL/glew.h>
#include <QGLWidget>
#include <QGLShader>

/*!
* \brief this class represents a QGLWidget that is used for displaying results using OpenGL
*/
class MyQGLWidget : public QGLWidget
{
	Q_OBJECT
public:
	MyQGLWidget(QWidget *parent);

	virtual ~MyQGLWidget();

public slots:
	void setProjectionMode(int mode);
protected:
	int m_iProjectionMode;
	int m_w;
	int m_h;

	void initializeGL();

	void resizeGL(int w, int h);

	void paintGL();
	void renderTextureWithTF(int channel, int tf_id);
};

#endif // MYQGLWIDGET_H
