#include <assert.h>
#include "myqglwidget.h"

#include "MainWindow.h"
#include "TransferFunction.h"
#include "Logger.h"
#include "FlowData.h"
#include "FlowRenderer.h"

// CONSTRUCTOR
MyQGLWidget::MyQGLWidget( QWidget *parent ) : QGLWidget(parent)
{
    m_iProjectionMode = 0;
}

// DESTRUCTOR
MyQGLWidget::~MyQGLWidget()
{

}

// gets called only one time
void MyQGLWidget::initializeGL()
{
	if (GLEW_OK != glewInit())
	{
		// GLEW failed!
		exit(1);
	}

	//glEnable(GL_DEPTH_TEST);
	//glEnable(GL_BLEND);
	//glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_TEXTURE_1D);
	glEnable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);
	glDisable(GL_LIGHTING);
	//glEnable(GL_BLEND);
	//glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	//glDepthFunc(GL_LEQUAL);
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST); // Really Nice Perspective Calculations

	glClearColor(0.0f, 0.0f, 0.0f, 0.0f); // paint on black

	//SlicedRenderer::instance()->initialize();
	//RaytracedRenderer::instance()->initialize();
}

/*!
* \brief This methods gets called on every resize and the first time the OpenGL widget is created.
* The method takes care of recalculating aspect ration and perspective or orthographic projection.
* \param w the width of the new QGLWidget
* \param h the height of the new QGLWidget
*/
void MyQGLWidget::resizeGL( int w, int h )
{
    m_w = w;
    m_h = h;

    FlowRenderer::instance()->setRenderSize(w,h);

	// setup viewport
	
	// recalculate perspective projection matrix
	//glm::mat4 projectionmatrixP = glm::perspective( 120.f, (float)(w/h), 0.1f, 5.0f );

    glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
    glLoadIdentity();							// Reset The Projection Matrix

    // Calculate The Aspect Ratio Of The Window
    glViewport(0, 0, w, h);
    /*if (m_iProjectionMode == 0)
	gluPerspective(45.0f,(GLfloat)w/(GLfloat)h,0.1f,100.0f);
    else
	glOrtho(-2,2,-2 / (w/(GLfloat)h), 2 / (w/(GLfloat)h), 0.1f, 100.0f);*/
    /* gluOrtho2D(0,w,0,h);*/
    /* glScalef(1, -1, 1);*/

    glMatrixMode(GL_MODELVIEW);						// Select The Modelview Matrix
    glLoadIdentity();

    //RaytracedRenderer::instance()->resize(w,h);
}

/*!
* \brief This methods gets called on every resize and the first time the OpenGL widget is created.
* The method takes care of recalculating aspect ration and perspective or orthographic projection.
*/
void MyQGLWidget::paintGL()
{
/*    FlowGeometry *geometry = dataset->getGeometry();

    // attention: x and y are flipped!

    int dimension_x = geometry->getDimY();
    int dimension_y = geometry->getDimX();

    float max_x = geometry->getPosY(dimension_y-1);
    float max_y = geometry->getPosX(dimension_y * dimension_x - 1);*/

    FlowRenderer::instance()->render();

  /*  glDisable(GL_BLEND);
    glDisable(GL_LIGHTING);
    glActiveTexture(GL_TEXTURE0);
    glDisable(GL_TEXTURE_2D);
    glActiveTexture(GL_TEXTURE1);
    glDisable(GL_TEXTURE_2D);
    glActiveTexture(GL_TEXTURE2);
    glDisable(GL_TEXTURE_2D);
    glActiveTexture(GL_TEXTURE3);
    glDisable(GL_TEXTURE_2D);
    glActiveTexture(GL_TEXTURE4);
    glDisable(GL_TEXTURE_2D);
    glActiveTexture(GL_TEXTURE5);
    glDisable(GL_TEXTURE_2D);
    glActiveTexture(GL_TEXTURE6);
    glDisable(GL_TEXTURE_2D);
    glActiveTexture(GL_TEXTURE7);
    glDisable(GL_TEXTURE_2D);

    glColor3f(1.0f, 1.0f, 1.0f);
    glBegin(GL_POINTS);
    for (int x=0; x < dimension_x; x++)
	for (int y=0; y < dimension_y; y++)
	{
	float p_x = geometry->getPosY(x) / max_x;
	float p_y = geometry->getPosX(y * dimension_y + x) / max_y;
	p_x = p_x * 2.0 - 1.0;
	p_y = p_y * 2.0 - 1.0;
	glVertex3f(p_x, p_y, 0.0);
	//cout << p_x << ":" << p_y << endl;
	}

    glEnd();*/
    //cout << "draw" << endl;



   /* glBegin(GL_LINE_STRIP);
    glVertex3f(-1.0f, -1.0f, 0.0f);  //left bottom
    glVertex3f(-1.0f, 1.0f, 0.0f);  //left top
    glVertex3f(1.0f, -1.0f, 0.0f);  //right bottom
    glVertex3f(1.0f, 1.0f, 0.0f);  //right top
    glEnd();*/

}

/*!
* \brief This method sets the projection mode
* \param mode int 0 for perspective or int 1 for orthogonal.
*/
void MyQGLWidget::setProjectionMode(int mode)
{
    m_iProjectionMode = mode;
    resizeGL(m_w,m_h);
}
