#ifndef __transferfunction_header
#define __transferfunction_header

#include <QtOpenGL>

/**
* Representation of a transferfunction that maps
* an input scalarfield value to [r, g, b, a] and stores this mapping
* in a 1D Texture on the GPU for fast lookups.
*/
class TransferFunction : public QObject
{
    Q_OBJECT
public:
	TransferFunction(void);
	virtual ~TransferFunction(void);

	static TransferFunction *instance(int id);	//returns singelton instance

	GLuint getTextureName();
public slots:
	void updateTransferTexture(unsigned char *new_data);

private:
	GLuint textureName;
};


#endif
