#include "TransferFunction.h"
#include "Logger.h"
#include "assert.h"
#include <iostream>

using namespace std;

TransferFunction *TransferFunction::instance(int id)
{
    assert (id < 2);

    static TransferFunction singelton_instance_TF[2];

    return &singelton_instance_TF[id];
}

TransferFunction::TransferFunction(void)
{
    this->textureName = 0;
}

TransferFunction::~TransferFunction(void)
{

}

void TransferFunction::updateTransferTexture(unsigned char *new_data)
{
    //we got new data from the transferfunction editing widgets
    //the data is already prepared to use as an opengl texture, so we simple map it in the graphics memory

    if (this->textureName==0)
	glGenTextures(1, &this->textureName);

    glEnable(GL_TEXTURE_1D);
    glBindTexture(GL_TEXTURE_1D, this->textureName);

    glTexImage1D(GL_TEXTURE_1D, 0, GL_RGBA, 4096, 0, GL_RGBA, GL_UNSIGNED_BYTE, new_data);

    glTexParameteri(GL_TEXTURE_1D,GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    glTexParameteri(GL_TEXTURE_1D,GL_TEXTURE_MAG_FILTER, GL_LINEAR);

    glTexParameteri(GL_TEXTURE_1D,GL_TEXTURE_WRAP_S, GL_CLAMP);

    //free memory block which we got (see comments in GradientEditor::prepareTransferFunctionData() )
    delete[] new_data;
}

GLuint TransferFunction::getTextureName()
{
    if (this->textureName == 0)
	Logger::instance()->log(Logger::Error, "Transfertexture not created yet");

    return this->textureName;
}
