#include "MainWindow.h"
#include "ui_MainWindow.h"
#include "gradients.h"
#include "TransferFunction.h"
#include "FlowData.h"
#include "FlowRenderer.h"
#include "Logger.h"

#include <iostream>
#include <QTimer>

using namespace std;

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    QTimer *test = new QTimer();
    test->setInterval(35);
    test->start();
    connect(test, SIGNAL(timeout()), ui->OpenGLWidget, SLOT(updateGL()));

    //and connect signals and slots
    connect(ui->loadFileButton, SIGNAL(clicked()), this, SLOT(loadDataset()));
    //connect(dialog, SIGNAL(fileSelected(QString)), VolumeData::instance(), SLOT(loadDataSet(QString)));

    //connect also menu entry file/open with file dialog
    connect(ui->actionOpen, SIGNAL(triggered()), this, SLOT(loadDataset()));

    //connect transferfunction things
    connect(ui->TransferFunction1, SIGNAL(transferFunctionChanged(unsigned char*)), TransferFunction::instance(0), SLOT(updateTransferTexture(unsigned char*)));
    connect(ui->TransferFunction2, SIGNAL(transferFunctionChanged(unsigned char*)), TransferFunction::instance(1), SLOT(updateTransferTexture(unsigned char*)));

    //connect button to update view
    connect(ui->testButton, SIGNAL(clicked()), FlowRenderer::instance(), SLOT(updateArrowTexture()));
    connect(ui->testButton, SIGNAL(clicked()), FlowRenderer::instance(), SLOT(updateStreamlinesTexture()));

    //connect ui elements with FLowRenderer
    connect(ui->comboBox_colorcoding, SIGNAL(activated(int)), FlowRenderer::instance(), SLOT(setColorCoding(int)));
    connect(ui->checkbox_showarrows, SIGNAL(clicked(bool)), FlowRenderer::instance(), SLOT(setShowArrows(bool)));
    connect(ui->checkbox_streamlines, SIGNAL(clicked(bool)), FlowRenderer::instance(), SLOT(setShowStreamlines(bool)));
    connect(ui->comboBox_StreamlineMode, SIGNAL(activated(int)), FlowRenderer::instance(), SLOT(setStreamlinesMode(int)));
    connect(ui->dSB_dsep, SIGNAL(valueChanged(double)), FlowRenderer::instance(), SLOT(setDsep(double)));
    connect(FlowRenderer::instance(), SIGNAL(DsepChanged(double)), ui->dSB_dsep, SLOT(setValue(double)));

    connect(ui->dSB_dtest, SIGNAL(valueChanged(double)), FlowRenderer::instance(), SLOT(setDtest(double)));
    connect(FlowRenderer::instance(), SIGNAL(DtestChanged(double)), ui->dSB_dtest, SLOT(setValue(double)));

    connect(ui->dSB_dstep, SIGNAL(valueChanged(double)), FlowRenderer::instance(), SLOT(setDstep(double)));
    connect(FlowRenderer::instance(), SIGNAL(DstepChanged(double)), ui->dSB_dstep, SLOT(setValue(double)));

    connect(ui->checkbox_tapering, SIGNAL(clicked(bool)), FlowRenderer::instance(), SLOT(setUseTapering(bool)));
    connect(FlowRenderer::instance(), SIGNAL(UseTaperingChanged(bool)), ui->checkbox_tapering, SLOT(setChecked(bool)));

    connect(ui->spinBox_StreamlineWidth, SIGNAL(valueChanged(int)), FlowRenderer::instance(), SLOT(setStreamlineWidth(int)));
    connect(FlowRenderer::instance(), SIGNAL(StreamlineWidthChanged(int)), ui->spinBox_StreamlineWidth, SLOT(setValue(int)));

    connect(ui->comboBox_StreamlineTexturingMode, SIGNAL(activated(int)), FlowRenderer::instance(), SLOT(setStreamlineTexturingMode(int)));
    connect(FlowRenderer::instance(), SIGNAL(StreamlineTexturingModeChanged(int)), ui->comboBox_StreamlineTexturingMode, SLOT(setCurrentIndex(int)));

    connect(ui->spinBox_periodLength, SIGNAL(valueChanged(int)), FlowRenderer::instance(), SLOT(setStreamlineTexturingPeriodLength(int)));
    connect(FlowRenderer::instance(), SIGNAL(StreamlineTexturingPeriodLengthChanged(int)), ui->spinBox_periodLength, SLOT(setValue(int)));

    connect(ui->checkBox_Glyphs, SIGNAL(clicked(bool)), FlowRenderer::instance(), SLOT(setUseGlyphs(bool)));
    connect(FlowRenderer::instance(), SIGNAL(UseGlyphsChanged(bool)), ui->checkBox_Glyphs, SLOT(setChecked(bool)));

    connect(ui->button_load_tf1, SIGNAL(clicked()), this, SLOT(loadTF1()));
    connect(ui->button_load_tf2, SIGNAL(clicked()), this, SLOT(loadTF2()));
    connect(ui->button_save_tf1, SIGNAL(clicked()), this, SLOT(saveTF1()));
    connect(ui->button_save_tf2, SIGNAL(clicked()), this, SLOT(saveTF2()));

    connect(ui->spinBox_max_segments, SIGNAL(valueChanged(int)), FlowRenderer::instance(), SLOT(setMaxStreamlineSegments(int)));
    connect(FlowRenderer::instance(), SIGNAL(MaxStreamlineSegmentsChanged(int)), ui->spinBox_max_segments, SLOT(setValue(int)));

    connect(FlowRenderer::instance(), SIGNAL(ShowArrowsChanged(bool)), ui->checkbox_showarrows, SLOT(setChecked(bool)));
    connect(FlowRenderer::instance(), SIGNAL(ShowStreamlinesChanged(bool)), ui->checkbox_streamlines, SLOT(setChecked(bool)));

    connect(ui->horizontalSlider_streamlinesAlpha, SIGNAL(valueChanged(int)), FlowRenderer::instance(), SLOT(setStreamlinesAlpha(int)));
    connect(FlowRenderer::instance(), SIGNAL(StreamlinesAlphaChanged(int)), ui->horizontalSlider_streamlinesAlpha, SLOT(setValue(int)));

    connect(ui->comboBox_CompoMode, SIGNAL(activated(int)), FlowRenderer::instance(), SLOT(setStreamlinesComboMode(int)));
    connect(FlowRenderer::instance(), SIGNAL(StreamlinesComboModeChanged(int)), ui->comboBox_CompoMode, SLOT(setCurrentIndex(int)));

}

void MainWindow::loadDataset()
{
    QString filename = QFileDialog::getOpenFileName(this, tr("Open File"),"",tr("*.dat files (*.dat)"));

    if (filename.isNull())
	return;

    //load a dataset, an example path is given
    //bool result = FlowData::instance()->loadDataset("flowdata/hurricane10/hurricane_p_tc_singletime10.dat",false);
    bool result = FlowData::instance()->loadDataset(filename.toLatin1().data(),false);
    //exit if the loading was not successful
    if (!result)
    {
	cerr << "Could not load file: " << filename.toStdString() << endl;
    }
    else
    {
	ui->lineSelectedFile->setText(filename);

	//copies the geometry into a new channel
	int chX = FlowData::instance()->createChannelGeometry(0);
	int chY = FlowData::instance()->createChannelGeometry(1);
	//in the data sets for the VisLU, the velocity vector is stored in the first three floats, thus channels 0, 1, and 2 contain its x, y, z components
	//this command creates a channel with the velocity magnitude
	int vel = FlowData::instance()->createChannelVectorLength(0,1,2);

	FlowRenderer::instance()->updateArrowTexture();
	FlowRenderer::instance()->updateStreamlinesTexture();
    }

}

void MainWindow::loadTF1()
{
    QString filename = QFileDialog::getOpenFileName(this, tr("Open File"),"",tr("Transferfunctions (*.tff)"));
    if (filename.isNull())
	return;

    ui->TransferFunction1->loadFromFile(filename.toLatin1().data());
}

void MainWindow::loadTF2()
{
    QString filename = QFileDialog::getOpenFileName(this, tr("Open File"),"",tr("Transferfunctions (*.tff)"));
    if (filename.isNull())
	return;

    ui->TransferFunction2->loadFromFile(filename.toLatin1().data());
}

void MainWindow::saveTF1()
{
    QString filename = QFileDialog::getSaveFileName(this, tr("Save File"),"",tr("Transferfunctions (*.tff)"));
    if (filename.isNull())
	return;

    ui->TransferFunction1->saveToFile(filename.toLatin1().data());
}

void MainWindow::saveTF2()
{
    QString filename = QFileDialog::getSaveFileName(this, tr("Save File"),"",tr("Transferfunctions (*.tff)"));
    if (filename.isNull())
	return;

    ui->TransferFunction2->saveToFile(filename.toLatin1().data());
}

MainWindow::~MainWindow()
{

}
