uniform sampler2D tex_entry;
uniform sampler2D tex_exit;
uniform sampler3D tex_intensity;
uniform sampler1D tex_transfer;
uniform sampler3D tex_gradient;

uniform int mode;

uniform float cutX;
uniform float cutY;
uniform float cutZ;

uniform bool lightOn;
uniform float ambientAmount;
uniform float diffuseAmount;
uniform float specularAmount;

uniform int renderMode;

void main() {
	// 3D Mode
	if (renderMode == 1) {
		//int mode = 2;

		const float dz = 0.005;
		const int maxrange = 347;
		
		vec4 entry_point = texture2D(tex_entry, vec2(gl_TexCoord[0]));
		vec4 exit_point = texture2D(tex_exit, vec2(gl_TexCoord[0]));
		
		float dist = distance(entry_point, exit_point)/dz;
		int maxiter = int(floor(dist));
		
		vec3 diff = (exit_point.xyz - entry_point.xyz)/dist;
		
		vec4 Result = vec4(0.0, 0.0, 0.0, 0.0);
		
		// ensure  that background color is set right according to transfer function
		// TODO: doesn't work in AVERAGE mode
		//vec4 Result = texture1D(tex_transfer, 0.0);
		
		float maxIntensity = 0.0;
		
		if (entry_point.w == 0.0) {
			discard;
		} else {
			//float numSamples = 0.0f;
			bool work = true;
			
			for (int i = 0; i < maxrange && work; i++) {
				
				float intensity = texture3D(tex_intensity, entry_point.xyz).x;
				
				vec4 transferred = texture1D(tex_transfer, intensity);

				float offset = 0.02;

				vec3 lightColor = transferred.xyz;

				if (lightOn) {
					vec3 grad = vec3(texture3D(tex_intensity, (entry_point.xyz + offset*vec3(1.0,0.0,0.0))).x - (texture3D(tex_intensity, (entry_point.xyz + offset*vec3(-1.0,0.0,0.0))).x),
								 texture3D(tex_intensity, (entry_point.xyz + offset*vec3(0.0,1.0,0.0))).x - (texture3D(tex_intensity, (entry_point.xyz + offset*vec3(0.0,-1.0,0.0))).x),
								 texture3D(tex_intensity, (entry_point.xyz + offset*vec3(0.0,0.0,1.0))).x - (texture3D(tex_intensity, (entry_point.xyz + offset*vec3(0.0,0.0,-1.0))).x));
					//vec3 grad = texture3D(tex_gradient, entry_point.xyz).xyz;
					
					vec3 lightPos = normalize(exit_point.xyz-entry_point.xyz);
					float diffuse = 0.3;
					float specular = 0.0;
					
					if (length(grad) > 0.01) {
						diffuse = min(1.0, max(0.0, dot(normalize(grad), lightPos)));
						specular = diffuse;
						specular = pow(max(0.0, specular), 12.0);
						// TODO
						float light = ambientAmount + diffuseAmount * diffuse;
						lightColor = transferred.xyz*light + specular * specularAmount;
					}
				} else {
					lightColor = lightColor * ambientAmount;
				}

				
				if (mode == 1) { //MIP
					if (intensity > maxIntensity) {
						if (entry_point.x >= cutX && entry_point.y >= cutY && entry_point.z <= (1.0 - cutZ)) {
							maxIntensity = intensity;
							Result = vec4(lightColor, 1);
						}
					}
					if (i >= maxiter) {
						work = false;
					}
				} else if (mode == 0) { //AVERAGE
					if (entry_point.x >= cutX && entry_point.y >= cutY && entry_point.z <= (1.0 - cutZ)) {
						Result.xyz += transferred.w * lightColor;
						Result.w = transferred.w;
					}
					
					if (i >= maxiter) {
						work = false;
					}
				} else { //ADDITIVE
					if (entry_point.x >= cutX && entry_point.y >= cutY && entry_point.z <= (1.0 - cutZ)) {
						Result.xyz += lightColor * transferred.w * (1.0 - Result.w);
						Result.w += (1.0 - Result.w) * transferred.w;
					}
					
					
					if (Result.w >= 1.0) {
						break;
					}
					if (i >= maxiter) {
						break;
					}
				}
				
				entry_point.xyz += diff;
				if (i >= maxiter) {
					break;
				}
			}
			
			if (mode == 0) {
				if (maxiter > 0) {
					Result /= float(maxiter);
				} else {
					Result = vec4(0.0, 0.0, 0.0, 1.0);
				}

			}
			
			gl_FragColor = Result;
		}
	} else {
		vec4 intensity = texture3D(tex_intensity, vec3(gl_TexCoord[1]));
		gl_FragColor = texture1D(tex_transfer, intensity.x);
	}


}