﻿uniform sampler2D enterColorSampler;
uniform sampler2D enterDepthSampler;
uniform sampler2D exitColorSampler;
uniform sampler2D exitDepthSampler;

uniform sampler3D dataSampler;
uniform sampler1D transferSampler;
uniform sampler1D backTransferSampler;

uniform float raySamplerDist;

uniform vec3 planeNormal;
uniform float planeDist;

uniform vec3 texelSize;

uniform vec3 viewDir;


uniform vec3 Intensity;

vec3 densityNormal(vec3 texCoord)
{
	float densityOfXplus1	= texture3D(dataSampler, texCoord + vec3(texelSize.x,	0.0f,			0.0f));
	float densityOfXminus1	= texture3D(dataSampler, texCoord + vec3(-texelSize.x,	0.0f,			0.0f));
	float densityOfYplus1	= texture3D(dataSampler, texCoord + vec3(0.0f,			texelSize.y,	0.0f));
	float densityOfYminus1	= texture3D(dataSampler, texCoord + vec3(0.0f,			-texelSize.y,	0.0f));
	float densityOfZplus1	= texture3D(dataSampler, texCoord + vec3(0.0f,			0.0f,			texelSize.z));
	float densityOfZminus1	= texture3D(dataSampler, texCoord + vec3(0.0f,			0.0f,			-texelSize.z));
	
	float dX = densityOfXplus1 - densityOfXminus1;
	float dY = densityOfYplus1 - densityOfYminus1;
	float dZ = densityOfZplus1 - densityOfZminus1;
	
	vec3 normal = vec3(dX, dY, dZ);
	
	if(length(normal) > 0)
	{
		normal = normalize(normal);
	}
	
	return normal;
}

vec3 getColor(vec3 yRGB, float yDensity, vec3 yNormal)
{
	float specularExponent = 7.0f + 500.0f * yDensity;
	
	float cosOfLightAngle = 0.0;
	vec3 halfwayVector = normalize(viewDir + viewDir);
	
	float specular = 0.0;
	
	if (dot(yNormal, viewDir) > 0.0)
		cosOfLightAngle = dot(yNormal, viewDir);
	
	if (dot(yNormal, halfwayVector) > 0.0)
		specular = pow(dot(yNormal, halfwayVector), specularExponent);
		
	float Ia = Intensity.x;
	float Id = Intensity.y * cosOfLightAngle;	
	float Is = min(Intensity.z * specular, 1.0f);
	
	return max(min((Ia + Id) * yRGB + Is * vec3(1.0f, 1.0f, 1.0f), 1.0f), 0.0f);
} 

void main()
{
	float ein = vec3(texture2D(enterDepthSampler, gl_TexCoord[0])).r;
	float aus = vec3(texture2D(exitDepthSampler, gl_TexCoord[0])).r;
	
	vec3 texEin = vec3(texture2D(enterColorSampler, gl_TexCoord[0]));
	vec3 texAus = vec3(texture2D(exitColorSampler, gl_TexCoord[0]));
	
	if (ein != aus)
	{
		vec3 start = texEin;
		vec3 end = texAus;
		vec3 add = end - start;
		float sampleDist = length(add);
		vec3 normadd = normalize(add);
		
		vec4 color = vec4(0.0f, 0.0f, 0.0f, 0.0f);
		float d = 0.0;
		bool planeHit = false;
		
		vec3 texCoord;
		vec4 dichte;
		vec4 transfered;
		
		do
		{
			texCoord = vec3(start + normadd*d);
		
			if (dot(planeNormal, texCoord - vec3(0.5, 0.5, 0.5)) - planeDist >= raySamplerDist / 2.0)
			{
				dichte = texture3D(dataSampler, texCoord);
				transfered = texture1D(transferSampler, dichte.x);			
				
				color.rgb += (1.0 - color.a) * transfered.a * getColor(transfered.rgb, dichte, densityNormal(texCoord));
				color.a += (1.0 - color.a) * transfered.a;
			}
			else if (dot(planeNormal, texCoord - vec3(0.5, 0.5, 0.5)) - planeDist > -raySamplerDist / 2.0)
			{
				planeHit = true;
			}
			else
			{
				dichte = texture3D(dataSampler, texCoord);
				transfered = texture1D(backTransferSampler, dichte.x);
				
				color.rgb += (1.0 - color.a) * transfered.a * getColor(transfered.rgb, dichte, densityNormal(texCoord));
				color.a += (1.0 - color.a) * transfered.a;
			}
			
			d += raySamplerDist;
			
		} while (color.a < 1.0 && d <= sampleDist);
		
		if (planeHit && length(vec3(color)) <= 0.2)
		{
			color.rg = 0.0;
			color.b = 0.3;
			color.a = 1.0;
		}
		
		gl_FragColor = color;
	}
	else
	{
		gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0);
	}
}