varying vec4 gl_TexCoord[];
varying mat3 NormalMatrix;
varying mat4 ModelviewMatrix;

uniform sampler2D backface_fbo;
uniform sampler2D frontface_fbo;
uniform sampler3D volumetexture;
uniform sampler1D transferfunction;
uniform sampler3D gradients;
uniform int mode;
uniform int height;
uniform int width;
uniform int depth;
uniform int steps_mode;

uniform bool shading_enabled;

void main(void)
{
	/// material and light
    vec3 lightDiffuse = vec3(1.0);
    vec3 lightSpecular = vec3(1.0);
    vec3 materialDiffuse = vec3(0.6);
    vec3 materialSpecular = vec3(1.0);
    float materialShininess = 200.0;
    float ambientLight = 0.15;



	/// entry and exit position for volumedata
    vec3 start_position = texture2D(frontface_fbo, gl_TexCoord[0].st).xyz;
    vec3 end_position = texture2D(backface_fbo, gl_TexCoord[0].st).xyz;

    if (start_position == end_position)
	gl_FragColor = vec4(0.0);
    else
	{
	vec3 color = vec3(0.0);
	float density = 0.0;
	float alpha = 0.0;

	float length_of_ray_x = (end_position.x - start_position.x) * float(width);
	float length_of_ray_y = (end_position.y - start_position.y) * float(height);
	float length_of_ray_z = (end_position.z - start_position.z) * float(depth);
	float length_of_ray = sqrt(length_of_ray_x * length_of_ray_x + length_of_ray_y * length_of_ray_y + length_of_ray_z * length_of_ray_z);
	float steps;
	float factor_for_tf_alpha;

	if (steps_mode == 0)
	{
	    steps = int(length_of_ray * 2.0);
	    factor_for_tf_alpha = 2.0;
	}
	else
	{
	    steps = float(steps_mode);
	    factor_for_tf_alpha = steps / length_of_ray;
	}

	vec3 step = (end_position - start_position) / steps;
        		
	/**************************************
	* depending on mode decide what to do *
	**************************************/
	if (mode == 2) ///< MIP MODE
	{
	    float maxdensity = 0.0;
	    /// find maximum density for MIP mode
	    for (float i=0.0; i < steps; i+=1.0)
	    {
		/// get the density using lookup in volumedata 3d texture
		density = texture3D(volumetexture, start_position + i*step).r;
		if (maxdensity < density)
		    maxdensity = density;
	    }

	    /// get the color using transferfunction lookup
	    vec4 tf_color = texture1D(transferfunction, maxdensity);
	    color = tf_color.rgb;
	    gl_FragColor = vec4(color, 1.0);
	}
	else if (mode == 1) ///< F2B COMP MODE
	{
	    for (float i=0.0; i < steps; i+=1.0)
	    {
		vec3 current_position = start_position + i*step;
		/// get the density using lookup in volumedata 3d texture
		density = texture3D(volumetexture, current_position).r;

		/// get the color using transferfunction lookup
		vec4 tf_color = texture1D(transferfunction, density);
		tf_color.a /= factor_for_tf_alpha;

		vec3 light_value = vec3(0.0);

		if (shading_enabled)
		{
		    vec3 my_Lightpos = (vec4(10.0, 10.0, 10.0, 1.0)).xyz;
		    vec4 my_Pos = vec4(ModelviewMatrix * vec4((current_position - 0.5) * 2.0, 1.0));
		    vec3 eyePos = -my_Pos.xyz;
		    vec3 L = normalize(my_Lightpos - my_Pos.xyz);
		    vec3 E = normalize(eyePos);

		    vec3 N = normalize(NormalMatrix * (-normalize((texture3D(gradients, current_position).xyz - 0.5) * 2.0)));
		    float lambertTerm = dot(N, L);

		    if (lambertTerm > 0.0)
		    {
		    vec3 R = reflect(-L, N);

		    float specular = pow(max(dot(R, E), 0.0), materialShininess);

		    light_value = min(ambientLight + lightDiffuse*materialDiffuse*lambertTerm + lightSpecular*materialSpecular*specular, 1.0);
		    }
		    else
			light_value = vec3(ambientLight);
		}
		else
		    light_value = vec3(1.0);

		/// do front to back composition (f2b comp.)
		/// and stop if opacity already 1.0
		if (alpha < 1.0)
		{
		color += (light_value * tf_color.rgb) * min(tf_color.a, 1.0 - alpha);
		alpha += tf_color.a;
		}
	    }
	    gl_FragColor = vec4(color, alpha);
	}
	else if (mode == 0) ///< FIRST HIT MODE
	{
	    for (float i=0.0; i < steps; i+=1.0)
	    {
		/// get the density using lookup in volumedata 3d texture
		density = texture3D(volumetexture, start_position + i*step).r;

		/// get the color using transferfunction lookup
		vec4 tf_color = texture1D(transferfunction, density);

		/// search for First Hit
		if (tf_color.a > 0.0)
		{
		/// calculate phong
		vec3 my_Lightpos = (vec4(10.0, 10.0, 10.0, 1.0)).xyz;
		vec4 my_Pos = vec4(ModelviewMatrix * vec4((start_position + i*step - 0.5) * 2.0, 1.0));
		vec3 eyePos = -my_Pos.xyz;
		vec3 L = normalize(my_Lightpos - my_Pos.xyz);
		vec3 E = normalize(eyePos);

		vec3 N = normalize(NormalMatrix * (-normalize((texture3D(gradients, start_position + i*step).xyz - 0.5) * 2.0)));
		float lambertTerm = dot(N, L);

		if (lambertTerm > 0.0)
		{
		vec3 R = reflect(-L, N);

		float specular = pow(max(dot(R, E), 0.0), materialShininess);

		color = tf_color.rgb * (ambientLight + lightDiffuse*materialDiffuse*lambertTerm + lightSpecular*materialSpecular*specular);
		}


		if (shading_enabled == false)
		    color = tf_color.rgb;

		break;
		}
	    }
	    gl_FragColor = vec4(color, 1.0);
	}
    }
} // end main
