#include "myqglwidget.h"
/*
#include <glm/glm.hpp>
#include <glm/core/type_mat4x4.hpp>
#include <glm/gtc/matrix_projection.hpp>
#include <glm/gtc/type_ptr.hpp>*/

#include "MainWindow.h"
#include "TransferFunction.h"
#include "VolumeData.h"
#include "Logger.h"
#include "SlicedRenderer.h"
#include "RaytracedRenderer.h"
#include "Visualizer.h"


// CONSTRUCTOR
MyQGLWidget::MyQGLWidget( QWidget *parent ) : QGLWidget(parent)
{
    m_iProjectionMode = 0;
}

// DESTRUCTOR
MyQGLWidget::~MyQGLWidget()
{

}

// gets called only one time
void MyQGLWidget::initializeGL()
{
	if (GLEW_OK != glewInit())
	{
		// GLEW failed!
		exit(1);
	}

	glEnable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_TEXTURE_1D);
	glDisable(GL_TEXTURE_2D);
	glEnable(GL_TEXTURE_3D);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glDepthFunc(GL_LEQUAL);
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST); // Really Nice Perspective Calculations

	glClearColor(0.0f, 0.0f, 0.0f, 0.0f); // paint on black

	SlicedRenderer::instance()->initialize();
	RaytracedRenderer::instance()->initialize();
}

/*!
* \brief This methods gets called on every resize and the first time the OpenGL widget is created.
* The method takes care of recalculating aspect ration and perspective or orthographic projection.
* \param w the width of the new QGLWidget
* \param h the height of the new QGLWidget
*/
void MyQGLWidget::resizeGL( int w, int h )
{
    m_w = w;
    m_h = h;
	// setup viewport
	
	// recalculate perspective projection matrix
	//glm::mat4 projectionmatrixP = glm::perspective( 120.f, (float)(w/h), 0.1f, 5.0f );

    glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
    glLoadIdentity();							// Reset The Projection Matrix

    // Calculate The Aspect Ratio Of The Window
    glViewport(0, 0, w, h);
    if (m_iProjectionMode == 0)
	gluPerspective(45.0f,(GLfloat)w/(GLfloat)h,0.1f,100.0f);
    else
	glOrtho(-2,2,-2 / (w/(GLfloat)h), 2 / (w/(GLfloat)h), 0.1f, 100.0f);
    /* gluOrtho2D(0,w,0,h);*/
    /* glScalef(1, -1, 1);*/

    glMatrixMode(GL_MODELVIEW);						// Select The Modelview Matrix
    glLoadIdentity();

    RaytracedRenderer::instance()->resize(w,h);
}

/*!
* \brief This methods gets called on every resize and the first time the OpenGL widget is created.
* The method takes care of recalculating aspect ration and perspective or orthographic projection.
*/
void MyQGLWidget::paintGL()
{
    Visualizer::instance()->render();
}

/*!
* \brief This method sets the projection mode
* \param mode int 0 for perspective or int 1 for orthogonal.
*/
void MyQGLWidget::setProjectionMode(int mode)
{
    m_iProjectionMode = mode;
    resizeGL(m_w,m_h);
}
