#ifndef GRADIENTS_H
#define GRADIENTS_H

#include <QtGui>

class HoverPoints;

class ShadeWidget : public QWidget
{
    Q_OBJECT
public:
    enum ShadeType {
        RedShade,
        GreenShade,
        BlueShade,
        ARGBShade
    };

    ShadeWidget(ShadeType type, QWidget *parent);

    void setGradientStops(const QGradientStops &stops);

    void paintEvent(QPaintEvent *e);

    QSize sizeHint() const { return QSize(150, 40); }
    QPolygonF points() const;

    void setPoints(QPolygonF points);

    void setPixmap(QPixmap pixmap);

    HoverPoints *hoverPoints() const { return m_hoverPoints; }

    uint colorAt(int x);

signals:
    void colorsChanged();

private:
    void generateShade();

    ShadeType m_shade_type;
    QImage m_shade;
    QImage m_histogram;
    HoverPoints *m_hoverPoints;
    QLinearGradient m_alpha_gradient;
};

class GradientEditor : public QWidget
{
    Q_OBJECT
public:
    GradientEditor(QWidget *parent);

    void setGradientStops(const QGradientStops &stops);

    QColor getColorAt(int i);
    ShadeWidget *m_alpha_shade;

public slots:
    void pointsUpdated();
    void saveToFile(QString filename);
    void loadFromFile(QString filename);

signals:
    void gradientStopsChanged(const QGradientStops &stops);
    void transferFunctionChanged(unsigned char *new_texture_data);

private:
    ShadeWidget *m_red_shade;
    ShadeWidget *m_green_shade;
    ShadeWidget *m_blue_shade;


    unsigned char * prepareTransferFunctionData();
};

#endif // GRADIENTS_H
