#ifndef __volume_data_header
#define __volume_data_header

#include <GL/glew.h>
#include <QtOpenGL>

/*!
* \brief This object represents the volumetric data.
*/
class VolumeData : public QObject
{
    Q_OBJECT
public:
	VolumeData();
	virtual ~VolumeData(void);

	GLuint getTextureName();
	GLuint getGradientTextureName();

	static VolumeData* instance();

	int getHeight() { return m_iHeight; }
	int getWidth() { return m_iWidth; }
	int getDepth() { return m_iDepth; }

public slots:
	void loadDataSet(QString filename);
	int* getHistogramData();
	float* getNormalizedHistogramData();
	float* getLogNormalizedHistogramData();

private:
	GLfloat *data; ///< the volumetric data
	GLfloat *gradients; ///< gradient at every pos of voldata
	int *histodata; ///< histogram values
	GLuint textureName;
	GLuint gradientTextureName;
	GLfloat* getVolumetricData();
	int m_iWidth;
	int m_iHeight;
	int m_iDepth;
	
};

#endif
