#ifndef VISUALIZER_H
#define VISUALIZER_H

#include <QObject>
#include <QtOpenGL>

/*!
* \brief This class is for managing the visualization process, drawing the bounding box, rotating the scene and choose the right renderer.
*/
class Visualizer : public QObject
{
    Q_OBJECT

private:

    ///types
    //@{

    enum TRenderMode
    {
	SLICE = 0,
	RAYTRACE = 1,
    };

    //@}


    ///variables
    ///@{
	TRenderMode	    m_tMode;	    //which rendermode?
	unsigned int	    m_nSlice;	    //which slide should be rendered?
	int		    m_iRotateX;	    //Rotation around x-axis
	int		    m_iRotateY;	    //Rotation around y-axis
	int		    m_iRotateZ;	    //Rotation around z-axis
	float		    m_fZoom;
    ///@}

    ///intern functions
    ///@{
	void ItlRenderWireBox();
    ///@}

public:

    Visualizer();
    ///this class is a singelton, instance() returns the pointer to the instance
    static Visualizer *instance();

    void initialize();
    void render();

public slots:
    ///public slots which can be called as function or connected to fitting signals
    ///@{
	void setRotationX(int iRotationAngle);
	void setRotationY(int iRotationAngle);
	void setRotationZ(int iRotationAngle);
	void setZoom(int iZoom);
	void setRenderMode(int iMode);
    ///@}
};

#endif // VISUALIZER_H
