#include <GL/glew.h>
#include <QtOpenGL>
#include <cmath>
#include <algorithm>

#include "Visualizer.h"
#include "SlicedRenderer.h"
#include "TransferFunction.h"
#include "RaytracedRenderer.h"
#include "VolumeData.h"

Visualizer instance_visualizer_singelton;

Visualizer *Visualizer::instance()
{
    return &instance_visualizer_singelton;
}

Visualizer::Visualizer()
{
    m_fZoom = 1.0;
}

void Visualizer::ItlRenderWireBox()
{
    glPushAttrib(GL_ALL_ATTRIB_BITS);
    glPushMatrix();

    glUseProgram(0);
    glDisable(GL_TEXTURE_1D);
    glDisable(GL_TEXTURE_3D);
    glBegin(GL_LINES);
    glColor4d(1.0, 1.0, 1.0, 1.0);

    glVertex3f(-1.0f, -1.0f, 1.0f);
    glVertex3f(-1.0f, -1.0f, -1.0f);

    glVertex3f(-1.0f, 1.0f, 1.0f);
    glVertex3f(-1.0f, 1.0f, -1.0f);

    glVertex3f(1.0f, -1.0f, 1.0f);
    glVertex3f(1.0f, -1.0f, -1.0f);

    glVertex3f(1.0f, 1.0f, 1.0f);
    glVertex3f(1.0f, 1.0f, -1.0f);

    glVertex3f(-1.0f, 1.0f, 1.0f);
    glVertex3f(1.0f, 1.0f, 1.0f);

    glVertex3f(-1.0f, 1.0f, -1.0f);
    glVertex3f(1.0f, 1.0f, -1.0f);

    glVertex3f(-1.0f, -1.0f, 1.0f);
    glVertex3f(1.0f, -1.0f, 1.0f);

    glVertex3f(-1.0f, -1.0f, -1.0f);
    glVertex3f(1.0f, -1.0f, -1.0f);

    glVertex3f(-1.0f, -1.0f, -1.0f);
    glVertex3f(-1.0f, 1.0f, -1.0f);

    glVertex3f(1.0f, -1.0f, -1.0f);
    glVertex3f(1.0f, 1.0f, -1.0f);

    glVertex3f(-1.0f, -1.0f, 1.0f);
    glVertex3f(-1.0f, 1.0f, 1.0f);

    glVertex3f(1.0f, -1.0f, 1.0f);
    glVertex3f(1.0f, 1.0f, 1.0f);
    glEnd();

    glPopMatrix();
    glPopAttrib();
}

void Visualizer::render()
{
    GLbitfield flags = GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT;
    //clear buffers
    glClear(flags);

    glLoadIdentity();

    glTranslatef(0.0f,0.0f, -5.0f);
    glScalef(m_fZoom, m_fZoom, m_fZoom);

    glRotatef(m_iRotateZ, 0.0f, 0.0f, 1.0f);
    glRotatef(m_iRotateY, 0.0f, 1.0f, 0.0f);
    glRotatef(m_iRotateX, 1.0f, 0.0f, 0.0f);

    int iWidth = VolumeData::instance()->getWidth();
    int iHeight = VolumeData::instance()->getHeight();
    int iDepth = VolumeData::instance()->getDepth();

    float iMaxDimension = (float) max(iWidth, max(iHeight, iDepth));

    glScalef(iWidth / iMaxDimension, iHeight / iMaxDimension, iDepth / iMaxDimension);

    /*glPushMatrix();
    glScalef(1.005f, 1.005f, 1.005f);	//to avoid flickering artefacts
    ItlRenderWireBox();
    glPopMatrix();*/

    if (m_tMode != SLICE)
	RaytracedRenderer::instance()->preRender();

    if (m_tMode == SLICE)
    {
	ItlRenderWireBox();
	glTranslatef(-1.0f, -1.0f, -1.0f);
	glScalef(2.0f,2.0f,2.0f);
	SlicedRenderer::instance()->render();
    }
    else
	RaytracedRenderer::instance()->render();

}

void Visualizer::setRotationX(int iRotationAngle)
{
    m_iRotateX = iRotationAngle;
}

void Visualizer::setRotationY(int iRotationAngle)
{
    m_iRotateY = iRotationAngle;
}

void Visualizer::setRotationZ(int iRotationAngle)
{
    m_iRotateZ = iRotationAngle;
}

void Visualizer::setRenderMode(int iMode)
{
    m_tMode = (TRenderMode) iMode;
}

void Visualizer::setZoom(int iZoom)
{
    m_fZoom = iZoom / 10.0f;
}
