#ifndef __sliced_renderer_header
#define __sliced_renderer_header

#include <QObject>
#include <QtOpenGL>

/*
 This class is for rendering slices and gets called by the Visualizer class
 */

class SlicedRenderer : public QObject
{
    Q_OBJECT

private:

    ///types
    //@{

    ///define a enum to specify the axis which we should slice
    enum TAxis
    {
	Z_AXIS = 0,
	X_AXIS = 1,
	Y_AXIS = 2
    };

    enum TMode
    {
	SINGLE_SLICE = 0,
	SINGLE_SLICE_LOOPED = 1,
	ALL_SLICES = 2
    };

    //@}


    ///variables
    ///@{
    TAxis	    m_tAxis;	    //which axis should be sliced?
    TMode	    m_tMode;	    //which rendermode?
    unsigned int    m_nSlice;	    //which slide should be rendered?
    unsigned int    m_nLoopCount;

    QGLShaderProgram m_qShader;
    ///@}

    ///intern functions
    ///@{

	void ItlRenderAllSlices();
	void ItlRenderSingleSlice();

	void ItlRenderSingleSliceX();
	void ItlRenderSingleSliceY();
	void ItlRenderSingleSliceZ();
    ///@}
public:

    ///this class is a singelton, instance() returns the pointer to the instance

    static SlicedRenderer *instance();

    void initialize();
    void render();

    //constructor
    SlicedRenderer();

public slots:
    ///public slots which can be called as function or connected to fitting signals
    ///@{
    void setMode(int iMode);
    void setSlice(int iSlice);
    void setAxis(int iAxis);
    ///@}
};

#endif //__sliced_renderer_header
