#include <GL/glew.h>
#include <QtOpenGL>

#include "SlicedRenderer.h"
#include "TransferFunction.h"
#include "VolumeData.h"

SlicedRenderer instance_sliced_renderer;

const float MaxSlice = 100.0f;

SlicedRenderer::SlicedRenderer()
{
    this->m_nLoopCount = 0;
    this->m_nSlice = 50;
}

SlicedRenderer *SlicedRenderer::instance()
{
    return &instance_sliced_renderer;
}

void SlicedRenderer::setAxis(int iAxis)
{
    this->m_tAxis = (TAxis) iAxis;
}

void SlicedRenderer::setMode(int iMode)
{
    this->m_tMode = (TMode) iMode;
}

void SlicedRenderer::setSlice(int iSlice)
{
    this->m_nSlice = (unsigned int) iSlice;
}


void SlicedRenderer::ItlRenderSingleSliceX()
{
    float zSliceNumber = m_nSlice / MaxSlice;

    glBegin(GL_TRIANGLES);
    glTexCoord3f(zSliceNumber, 0.0f, 0.0);
    glVertex3f(zSliceNumber, 0.0f, 0.0);

    glTexCoord3f(zSliceNumber, 1.0f, 1.0f);
    glVertex3f(zSliceNumber, 1.0f, 1.0f);

    glTexCoord3f(zSliceNumber, 1.0f, 0.0f);
    glVertex3f(zSliceNumber, 1.0f, 0.0f);

    glTexCoord3f(zSliceNumber, 0.0f, 0.0f);
    glVertex3f(zSliceNumber, 0.0f, 0.0f);

    glTexCoord3f(zSliceNumber, 0.0f, 1.0f);
    glVertex3f(zSliceNumber, 0.0f, 1.0f);

    glTexCoord3f(zSliceNumber, 1.0f, 1.0);
    glVertex3f(zSliceNumber, 1.0f, 1.0f);
    glEnd();
}

void SlicedRenderer::ItlRenderSingleSliceY()
{
    float zSliceNumber = m_nSlice / MaxSlice;

    glBegin(GL_TRIANGLES);
    glTexCoord3f(0.0f, zSliceNumber, 0.0);
    glVertex3f(0.0f, zSliceNumber, 0.0);

    glTexCoord3f(1.0f, zSliceNumber, 1.0f);
    glVertex3f(1.0f, zSliceNumber, 1.0f);

    glTexCoord3f(1.0f, zSliceNumber, 0.0f);
    glVertex3f(1.0f, zSliceNumber, 0.0f);

    glTexCoord3f(0.0f, zSliceNumber, 0.0f);
    glVertex3f(0.0f, zSliceNumber, 0.0f);

    glTexCoord3f(0.0f, zSliceNumber, 1.0f);
    glVertex3f(0.0f, zSliceNumber, 1.0f);

    glTexCoord3f(1.0f, zSliceNumber, 1.0);
    glVertex3f(1.0f, zSliceNumber, 1.0);
    glEnd();
}

void SlicedRenderer::ItlRenderSingleSliceZ()
{
    float zSliceNumber = m_nSlice / MaxSlice;

    glBegin(GL_TRIANGLES);
    glTexCoord3f(0.0f, 0.0f, zSliceNumber);
    glVertex3f(0.0f, 0.0f, zSliceNumber);

    glTexCoord3f(1.0f, 1.0f, zSliceNumber);
    glVertex3f(1.0f, 1.0f, zSliceNumber);

    glTexCoord3f(0.0f, 1.0f, zSliceNumber);
    glVertex3f(0.0f, 1.0f, zSliceNumber);

    glTexCoord3f(0.0f, 0.0f, zSliceNumber);
    glVertex3f(0.0f, 0.0f, zSliceNumber);

    glTexCoord3f(1.0f, 0.0f, zSliceNumber);
    glVertex3f(1.0f, 0.0f, zSliceNumber);

    glTexCoord3f(1.0f, 1.0f, zSliceNumber);
    glVertex3f(1.0f, 1.0f, zSliceNumber);
    glEnd();
}

void SlicedRenderer::ItlRenderSingleSlice()
{
    if (m_tAxis == X_AXIS)
	ItlRenderSingleSliceX();
    else if (m_tAxis == Y_AXIS)
	    ItlRenderSingleSliceY();
    else ItlRenderSingleSliceZ();
}

void SlicedRenderer::ItlRenderAllSlices()
{
    int nSlice_backup = m_nSlice;

    bool swapped_loop = false;

    if (swapped_loop == true)
    {
	for (int i=99; i >= 0; i--)
	{
	    m_nSlice = i;
	    ItlRenderSingleSlice();
	}
    }
    else
    {
	for (int i=0; i < 100; i++)
	{
	    m_nSlice = i;
	    ItlRenderSingleSlice();
	}
   }

    m_nSlice = nSlice_backup;
}

void SlicedRenderer::initialize()
{

    //load our shader

    QGLShader shadervs(QGLShader::Vertex);
    QGLShader shaderfs(QGLShader::Fragment);
    m_qShader.setParent(this);
    shadervs.compileSourceFile(QString("shaders/simple.vs"));
    shaderfs.compileSourceFile(QString("shaders/slicing.fs"));
    m_qShader.addShader(&shadervs);
    m_qShader.addShader(&shaderfs);
    m_qShader.link();
}

void SlicedRenderer::render()
{
    m_qShader.bind();

    // pass textures to shaders
    glActiveTexture(GL_TEXTURE0);
    glBindTexture(GL_TEXTURE_1D, TransferFunction::instance()->getTextureName());
    glEnable(GL_TEXTURE_1D);
    m_qShader.setUniformValue(m_qShader.uniformLocation(QString("transferfunction")), 0);

    glActiveTexture(GL_TEXTURE1);
    glBindTexture(GL_TEXTURE_3D,VolumeData::instance()->getTextureName());
    glEnable(GL_TEXTURE_3D);
    m_qShader.setUniformValue(m_qShader.uniformLocation(QString("volumetexture")), 1);

    if (m_tMode == ALL_SLICES)
    {
	ItlRenderAllSlices();
    }
    else
    if (m_tMode == SINGLE_SLICE_LOOPED)
    {
	if (m_nLoopCount==100)
	    m_nLoopCount=0;

	unsigned int nSlice_backup = m_nSlice;

	m_nSlice = m_nLoopCount++;

	ItlRenderSingleSlice();

	m_nSlice = nSlice_backup;
    }
    else
	ItlRenderSingleSlice();

    m_qShader.release();
}
