#ifndef RAYTRACEDRENDERER_H
#define RAYTRACEDRENDERER_H

#include <QObject>
#include <QtOpenGL>


/*
 This class is for raytraced rendering and gets called by the Visualizer class
 */

class RaytracedRenderer : public QObject
{
    Q_OBJECT

private:

    ///types
    //@{

    //@}


    ///variables
    ///@{
	QGLFramebufferObject *m_pFrontSidesFBO;
	QGLFramebufferObject *m_pBackSidesFBO;
	QGLFramebufferObject *m_pRayCastFBO;

	QGLShaderProgram m_qPosIsColorShader;
	QGLShaderProgram m_qRaytraceShader;
	QGLShaderProgram m_qDrawResultShader;

	bool m_bInitialized;
	bool m_bRedraw;
	int m_iHeight;
	int m_iWidth;
	int m_iMode;
	int m_iSteps;
	bool m_bFixedLowSteps;
	bool m_bAllowFixedLowSteps;
	bool m_bProgressiveRefinement;
	bool m_bShadingEnabled;
	float m_fFBOSizeFactor;

	float m_fClipXLeft;
	float m_fClipXRight;
	float m_fClipYTop;
	float m_fClipYBottom;
	float m_fClipZBack;
	float m_fClipZFront;
    ///@}

    ///intern functions
    ///@{
	void itlDrawColorCube();
    ///@}
public:

    ///this class is a singelton, instance() returns the pointer to the instance
    static RaytracedRenderer *instance();

    ///constructor
    RaytracedRenderer();

    ///initialize the fbos and shaders
    void initialize();

    ///raytrace through colur cube
    void render();

    ///renders the color cube in the fbos
    void preRender();

    ///resize our fbos if the opengl widgets size changed
    void resize(int w, int h);

public slots:
    ///public slots which can be called as function or connected to fitting signals
    ///@{
    void setMode(int iMode) { m_iMode = iMode; }
    void setSteps(int iSteps) { m_iSteps = iSteps; }
    void setClippingValues(float fXLeft, float fXRight, float fYTop, float fYBottom, float fZBack, float fZFront);
    void setRedraw() { m_bRedraw = true;}
    void setShadingEnabled(bool b) { m_bShadingEnabled = b; }
    void setFixedLowSteps();
    void unsetFixedLowSteps();

    void setAllowFixedLowSteps(bool allow) { m_bAllowFixedLowSteps = allow;}
    void setProgressiveRefinement(bool bActive) { m_bProgressiveRefinement = bActive; }
    void saveRenderedImageToFile(QString filename);

    void setFBOSize(int iSelected);
    ///@}
};

#endif // RAYTRACEDRENDERER_H
