#include "MainWindow.h"
#include "ui_MainWindow.h"
#include "gradients.h"
#include "TransferFunction.h"
#include "VolumeData.h"
#include "SlicedRenderer.h"
#include "RaytracedRenderer.h"
#include "Visualizer.h"
#include <iostream>
#include <QTimer>

using namespace std;

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    QTimer *test = new QTimer();
    test->setInterval(35);
    test->start();
    connect(test, SIGNAL(timeout()), ui->OpenGLWidget, SLOT(updateGL()));

    //connect signal to update transferfunction-texture if user changed transferfunction
    connect(ui->gradienteditor, SIGNAL(transferFunctionChanged(unsigned char *)), TransferFunction::instance(), SLOT(updateTransferTexture(unsigned char *)));

    //create file dialog
    QFileDialog *dialog = new QFileDialog(this, "Load Volume Data", "", "*.dat files (*.dat)");
    dialog->setFileMode(QFileDialog::ExistingFile);
    dialog->setAcceptMode(QFileDialog::AcceptOpen);

    //and connect signals and slots
    connect(ui->loadFileButton, SIGNAL(clicked()), dialog, SLOT(show()));
    connect(dialog, SIGNAL(fileSelected(QString)), VolumeData::instance(), SLOT(loadDataSet(QString)));
    connect(dialog, SIGNAL(fileSelected(QString)), ui->lineSelectedFile, SLOT(setText(QString)));
    connect(dialog, SIGNAL(fileSelected(QString)), this, SLOT(loadInitialTransferFunction()));

    //connect also menu entry file/open with file dialog
    connect(ui->actionOpen, SIGNAL(triggered()), dialog, SLOT(show()));

    //connect signals to update slice, axis, rotation and render mode
    connect(ui->horizontalSlider, SIGNAL(valueChanged(int)), SlicedRenderer::instance(), SLOT(setSlice(int)));
    connect(ui->comboBox_3, SIGNAL(currentIndexChanged(int)), SlicedRenderer::instance(), SLOT(setAxis(int)));
    connect(ui->comboBox_2, SIGNAL(currentIndexChanged(int)), SlicedRenderer::instance(), SLOT(setMode(int)));
    connect(ui->slider_xrotate, SIGNAL(valueChanged(int)), Visualizer::instance(), SLOT(setRotationX(int)));
    connect(ui->slider_yrotate, SIGNAL(valueChanged(int)), Visualizer::instance(), SLOT(setRotationY(int)));
    connect(ui->slider_zrotate, SIGNAL(valueChanged(int)), Visualizer::instance(), SLOT(setRotationZ(int)));
    connect(ui->slider_zoom, SIGNAL(valueChanged(int)), Visualizer::instance(), SLOT(setZoom(int)));
    connect(ui->tabs_rendermodes, SIGNAL(currentChanged(int)), Visualizer::instance(), SLOT(setRenderMode(int)));

    //create file dialogs and connect load TF and save TF buttons with actions
    QFileDialog *loadTFDialog = new QFileDialog(this, "Load Transferfunction", "", "Transferfunctions (*.tff)");
    loadTFDialog->setFileMode(QFileDialog::ExistingFile);
    loadTFDialog->setAcceptMode(QFileDialog::AcceptOpen);
    QFileDialog *saveTFDialog = new QFileDialog(this, "Save Transferfunction", "", "Transferfunctions (*.tff)");
    saveTFDialog->setFileMode(QFileDialog::AnyFile);
    saveTFDialog->setAcceptMode(QFileDialog::AcceptSave);

    connect(ui->loadTFButton, SIGNAL(clicked()), loadTFDialog, SLOT(show()));
    connect(loadTFDialog, SIGNAL(fileSelected(QString)), ui->gradienteditor, SLOT(loadFromFile(QString)));
    connect(ui->saveTFButton, SIGNAL(clicked()), saveTFDialog, SLOT(show()));
    connect(saveTFDialog, SIGNAL(fileSelected(QString)), ui->gradienteditor, SLOT(saveToFile(QString)));

    //connect combobox projection mode signal/slots
    connect(ui->comboBox_4, SIGNAL(activated(int)), ui->OpenGLWidget, SLOT(setProjectionMode(int)));

    //connect combobox for raycasting method
    connect(ui->comboBox_RCMode, SIGNAL(activated(int)), RaytracedRenderer::instance(), SLOT(setMode(int)));
    connect(ui->slider_clip_x_left, SIGNAL(valueChanged(int)), this, SLOT(processClippingSliderXLeft()));
    connect(ui->slider_clip_x_right, SIGNAL(valueChanged(int)), this, SLOT(processClippingSliderXRight()));

    connect(ui->slider_clip_y_top, SIGNAL(valueChanged(int)), this, SLOT(processClippingSliderYTop()));
    connect(ui->slider_clip_y_bottom, SIGNAL(valueChanged(int)), this, SLOT(processClippingSliderYBottom()));

    connect(ui->slider_clip_z_back, SIGNAL(valueChanged(int)), this, SLOT(processClippingSliderZBack()));
    connect(ui->slider_clip_z_front, SIGNAL(valueChanged(int)), this, SLOT(processClippingSliderZFront()));

    //connect combobox for steps
    connect(ui->comboBox_Steps, SIGNAL(currentIndexChanged(int)), RaytracedRenderer::instance(), SLOT(setSteps(int)));

    //connect checkbox for progressive refinement
    connect(ui->checkBox_ProgressiveRefinement, SIGNAL(clicked(bool)), RaytracedRenderer::instance(), SLOT(setProgressiveRefinement(bool)));

    //connect actions which force complete redraw
    connect(ui->slider_xrotate, SIGNAL(sliderPressed()), RaytracedRenderer::instance(), SLOT(setFixedLowSteps()));
    connect(ui->slider_xrotate, SIGNAL(sliderReleased()), RaytracedRenderer::instance(), SLOT(unsetFixedLowSteps()));

    connect(ui->slider_yrotate, SIGNAL(sliderPressed()), RaytracedRenderer::instance(), SLOT(setFixedLowSteps()));
    connect(ui->slider_yrotate, SIGNAL(sliderReleased()), RaytracedRenderer::instance(), SLOT(unsetFixedLowSteps()));

    connect(ui->slider_zrotate, SIGNAL(sliderPressed()), RaytracedRenderer::instance(), SLOT(setFixedLowSteps()));
    connect(ui->slider_zrotate, SIGNAL(sliderReleased()), RaytracedRenderer::instance(), SLOT(unsetFixedLowSteps()));


    connect(ui->slider_clip_x_left, SIGNAL(sliderPressed()), RaytracedRenderer::instance(), SLOT(setFixedLowSteps()));
    connect(ui->slider_clip_x_left, SIGNAL(sliderReleased()), RaytracedRenderer::instance(), SLOT(unsetFixedLowSteps()));

    connect(ui->slider_clip_x_right, SIGNAL(sliderPressed()), RaytracedRenderer::instance(), SLOT(setFixedLowSteps()));
    connect(ui->slider_clip_x_right, SIGNAL(sliderReleased()), RaytracedRenderer::instance(), SLOT(unsetFixedLowSteps()));

    connect(ui->slider_clip_y_top, SIGNAL(sliderPressed()), RaytracedRenderer::instance(), SLOT(setFixedLowSteps()));
    connect(ui->slider_clip_y_top, SIGNAL(sliderReleased()), RaytracedRenderer::instance(), SLOT(unsetFixedLowSteps()));

    connect(ui->slider_clip_y_bottom, SIGNAL(sliderPressed()), RaytracedRenderer::instance(), SLOT(setFixedLowSteps()));
    connect(ui->slider_clip_y_bottom, SIGNAL(sliderReleased()), RaytracedRenderer::instance(), SLOT(unsetFixedLowSteps()));

    connect(ui->slider_clip_z_back, SIGNAL(sliderPressed()), RaytracedRenderer::instance(), SLOT(setFixedLowSteps()));
    connect(ui->slider_clip_z_back, SIGNAL(sliderReleased()), RaytracedRenderer::instance(), SLOT(unsetFixedLowSteps()));

    connect(ui->slider_clip_z_front, SIGNAL(sliderPressed()), RaytracedRenderer::instance(), SLOT(setFixedLowSteps()));
    connect(ui->slider_clip_z_front, SIGNAL(sliderReleased()), RaytracedRenderer::instance(), SLOT(unsetFixedLowSteps()));

    connect(ui->slider_zoom, SIGNAL(sliderPressed()), RaytracedRenderer::instance(), SLOT(setFixedLowSteps()));
    connect(ui->slider_zoom, SIGNAL(sliderReleased()), RaytracedRenderer::instance(), SLOT(unsetFixedLowSteps()));

    //connect checkbox which enables low steps when moving
    connect(ui->checkBox_FixedLowSteps, SIGNAL(clicked(bool)), RaytracedRenderer::instance(), SLOT(setAllowFixedLowSteps(bool)));

    //connect selecting of rendertarget size
    connect(ui->comboBox_FBOSize, SIGNAL(activated(int)), RaytracedRenderer::instance(), SLOT(setFBOSize(int)));

    //connect "save rendered image to file" button with file dialog
    QFileDialog *saveImageDialog = new QFileDialog(this, "Save image", "", "Image Files (*.png *.jpg *.bmp)");
    saveImageDialog->setFileMode(QFileDialog::AnyFile);
    saveImageDialog->setAcceptMode(QFileDialog::AcceptSave);
    connect(ui->saveimagetofilebutton, SIGNAL(clicked()), saveImageDialog, SLOT(show()));
    connect(saveImageDialog, SIGNAL(fileSelected(QString)), RaytracedRenderer::instance(), SLOT(saveRenderedImageToFile(QString)));

    //connect checkbox for shading
    connect(ui->checkBox_Shading, SIGNAL(clicked(bool)), RaytracedRenderer::instance(), SLOT(setShadingEnabled(bool)));

}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::processClippingSliderXLeft()
{
    if (ui->slider_clip_x_left->value() > ui->slider_clip_x_right->value())
	ui->slider_clip_x_right->setValue(ui->slider_clip_x_left->value());

    RaytracedRenderer::instance()->setClippingValues(ui->slider_clip_x_left->value() / 100.0f,
						     ui->slider_clip_x_right->value() / 100.0f,
						     ui->slider_clip_y_top->value() / 100.0f,
						     ui->slider_clip_y_bottom->value() / 100.0f,
						     ui->slider_clip_z_front->value() / 100.0f,
						     ui->slider_clip_z_back->value() / 100.0f);

}

void MainWindow::processClippingSliderXRight()
{
    if (ui->slider_clip_x_left->value() > ui->slider_clip_x_right->value())
	ui->slider_clip_x_left->setValue(ui->slider_clip_x_right->value());

    RaytracedRenderer::instance()->setClippingValues(ui->slider_clip_x_left->value() / 100.0f,
						     ui->slider_clip_x_right->value() / 100.0f,
						     ui->slider_clip_y_top->value() / 100.0f,
						     ui->slider_clip_y_bottom->value() / 100.0f,
						     ui->slider_clip_z_front->value() / 100.0f,
						     ui->slider_clip_z_back->value() / 100.0f);
}

void MainWindow::processClippingSliderYTop()
{
    if (ui->slider_clip_y_top->value() < ui->slider_clip_y_bottom->value())
	ui->slider_clip_y_bottom->setValue(ui->slider_clip_y_top->value());

    RaytracedRenderer::instance()->setClippingValues(ui->slider_clip_x_left->value() / 100.0f,
						     ui->slider_clip_x_right->value() / 100.0f,
						     ui->slider_clip_y_top->value() / 100.0f,
						     ui->slider_clip_y_bottom->value() / 100.0f,
						     ui->slider_clip_z_front->value() / 100.0f,
						     ui->slider_clip_z_back->value() / 100.0f);
}

void MainWindow::processClippingSliderYBottom()
{
    if (ui->slider_clip_y_top->value() < ui->slider_clip_y_bottom->value())
	ui->slider_clip_y_top->setValue(ui->slider_clip_y_bottom->value());

    RaytracedRenderer::instance()->setClippingValues(ui->slider_clip_x_left->value() / 100.0f,
						     ui->slider_clip_x_right->value() / 100.0f,
						     ui->slider_clip_y_top->value() / 100.0f,
						     ui->slider_clip_y_bottom->value() / 100.0f,
						     ui->slider_clip_z_front->value() / 100.0f,
						     ui->slider_clip_z_back->value() / 100.0f);
}

void MainWindow::processClippingSliderZBack()
{
    if (ui->slider_clip_z_back->value() > ui->slider_clip_z_front->value())
	ui->slider_clip_z_front->setValue(ui->slider_clip_z_back->value());

    RaytracedRenderer::instance()->setClippingValues(ui->slider_clip_x_left->value() / 100.0f,
						     ui->slider_clip_x_right->value() / 100.0f,
						     ui->slider_clip_y_top->value() / 100.0f,
						     ui->slider_clip_y_bottom->value() / 100.0f,
						     ui->slider_clip_z_front->value() / 100.0f,
						     ui->slider_clip_z_back->value() / 100.0f);
}

void MainWindow::processClippingSliderZFront()
{
    if (ui->slider_clip_z_back->value() > ui->slider_clip_z_front->value())
	ui->slider_clip_z_back->setValue(ui->slider_clip_z_front->value());

    RaytracedRenderer::instance()->setClippingValues(ui->slider_clip_x_left->value() / 100.0f,
						     ui->slider_clip_x_right->value() / 100.0f,
						     ui->slider_clip_y_top->value() / 100.0f,
						     ui->slider_clip_y_bottom->value() / 100.0f,
						     ui->slider_clip_z_front->value() / 100.0f,
						     ui->slider_clip_z_back->value() / 100.0f);
}
void MainWindow::loadInitialTransferFunction()
{
    QGradientStops stops;

    stops << QGradientStop(0.00, QColor::fromRgb(255,100,0,100));
    stops << QGradientStop(1.00, QColor::fromRgb(0,100,255,100));

    ui->gradienteditor->setGradientStops(stops);
}
