/*
 * header file for Logger class
 * written by: christian moellinger <ch.moellinger@gmail.com>
 * 10/2010
 */

#ifndef __realtime_lu_logger
#define __realtime_lu_logger

#include <string>
#include <fstream>

class Logger
{
public:
    enum LogLevel
    {
	Trace=0,
	Debug,
	Warn,
	Error,
	Fatal,
	Nothing ///< if no output is wanted, set the loglevel to Nothing
    };

    /// function to set log level for file (messages with a lower level are ignored)
    void setLogLevelForFile(LogLevel loglevel);

    /// function to set log level for console (messages with a lower level are ignored)
    void setLogLevelForConsole(LogLevel loglevel);

    /// function to write log messages
    void log(LogLevel level, const std::string message);

    /// function to write log messages
    void log(LogLevel level, const char *message);

    /// returns instance of logger class (-> logger is designed as a singelton)
    static Logger* instance();

    Logger();
    ~Logger();
private:
    LogLevel loglevel_file;
    LogLevel loglevel_console;

    std::fstream logfile;

    /// intern function to transform a loglevel in a describing char*
    const char * getLevelName(LogLevel level);
};


#endif
