/*
 * source file for Logger class
 * written by: christian moellinger <ch.moellinger@gmail.com>
 * 10/2010
 */

#include <iostream>
#include <fstream>
#include <stdexcept>
#include "Logger.h"

using namespace std;

Logger singelton_instance;

Logger *Logger::instance()
{
    return &singelton_instance;
}

Logger::Logger()
{
    this->logfile.open("log.txt", ios::out);
}

Logger::~Logger()
{
    this->logfile.close();
}

void Logger::setLogLevelForConsole(LogLevel loglevel)
{
    this->loglevel_console = loglevel;
}

void Logger::setLogLevelForFile(LogLevel loglevel)
{
    this->loglevel_file = loglevel;
}

void Logger::log(LogLevel level, const char *message)
{
    if (level >= this->loglevel_console)
    {
	cerr << this->getLevelName(level) << " " << message << endl;
    }

    if (level >= this->loglevel_file)
    {
	this->logfile << this->getLevelName(level) << " " << message << endl;
    }

    if (level >= Fatal)
	throw new std::runtime_error(message);
}

void Logger::log(LogLevel level, const std::string message)
{
    this->log(level, message.data());
}

const char *Logger::getLevelName(LogLevel level)
{
    switch (level)
    {
    case Trace:
	return "TRACE";
	break;
    case Debug:
	return "DEBUG";
	break;
    case Warn:
	return "WARNING";
	break;
    case Error:
	return "ERROR";
	break;
    case Fatal:
	return "FATAL";
	break;
    default:
	throw new std::invalid_argument("wrong loglevel used!");
    }
}
