uniform sampler2D slice_sampler;
uniform sampler3D slice_sampler3D;
uniform sampler3D gradient_sampler3D;
uniform sampler1D transfer_sampler;
uniform sampler2D cube_front;
uniform sampler2D cube_back;
uniform mat4 modelview_inverse;
uniform float dz;

uniform int b_raycasting;
uniform int compositing_mode;
uniform int shade_mode;

const vec3 lightColor = vec3(1.0,1.0,1.0);
const vec3 viewPos = vec3(0,0,1);
const vec3 lightDirection = vec3(1,0,1);

struct Material{
	vec3 Ka;
	vec3 Kd;
	vec3 Ks;
	float m;
};

vec3 Shade(	in vec3 p,
			in vec3 n,
			in Material m,
			in vec3 l,
			in vec3 EL,
			in vec3 h )
{
	vec3 Lo;

	if(shade_mode == 1)
	{
		float cosTh = max(dot(n,h),0.0);
		float cosTi = max(dot(n,l),0.0);

		Lo = ( m.Ka + m.Kd*cosTi )*EL + m.Ks * pow(cosTh,m.m)  * lightColor;
	}
	else
	{
		Lo = EL;
	}

	return (Lo);
}

void main()
{
	vec4 inten = texture3D(slice_sampler3D, vec3(gl_TexCoord[0]));

	Material material;
	material.Ks = vec3(1.0,1.0,1.0);
	material.m = 10.0;
	material.Ka = vec3(0.2,0.2,0.2);
	material.Kd = vec3(1.0,1.0,1.0);

	if (1 == b_raycasting) 
	{
		const int maxrange = 4095;
		vec4 entry_point = texture2D(cube_front, vec2(gl_TexCoord[0]));
		vec4 exit_point = texture2D(cube_back, vec2(gl_TexCoord[0]));
		
		float dist = distance(entry_point, exit_point)/dz;
		int maxiter = int(floor(dist));
		vec3 diff = (exit_point.xyz - entry_point.xyz)/dist;

		if (entry_point.w != 0.0)
		{
			vec3 point = vec3(entry_point);
			vec4 Result = vec4(0.0);
			float maxDensity = 0.0;
			
			vec3 v = normalize( vec3( modelview_inverse*vec4(viewPos,1.0) ) );
			vec3 l = normalize( vec3( modelview_inverse*vec4(lightDirection,1.0) ) );
			vec3 h = normalize(v + l);
			
			for (int i = 0; i < maxrange; i++)
			{
				vec3 norm = normalize(texture3D(gradient_sampler3D, point).xyz-0.5);
				
				vec4 intensity = texture3D(slice_sampler3D, point);
				vec4 transferred = texture1D(transfer_sampler, intensity.x/16.0);
				float density = intensity.x/16.0;

				vec3 shade = Shade( point,norm,material,l,transferred.xyz,h);

				if (0 == compositing_mode)
				{
					Result.xyz += (1.0 - Result.w) * transferred.w / 0.005 * dz * shade;
					Result.w += (1.0 - Result.w) * transferred.w / 0.005 * dz;
					if ((Result.w >= 1.0)) break;
				}
				else if (1 == compositing_mode) // averaging
				{
					Result.xyz += transferred.w * shade;
					Result.w += transferred.w;
				}
				else if (2 == compositing_mode) // maximum intensity projection
				{
					if (density > maxDensity)
					{
						maxDensity = density;
						Result = vec4(shade, transferred.w);
					}
				}

				if ((i >= maxiter)) break;

				point += diff;
			}

			if (0 == compositing_mode || 2 == compositing_mode)
				gl_FragColor = Result;
			else if (1 == compositing_mode) 
			{
				if (maxiter != 0) gl_FragColor = Result / float(maxiter) *3.0;
				else gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0);
			}
		}
	}
	else
	{
		gl_FragColor = texture1D(transfer_sampler, inten.x/16.0);
	}
}