#version 120

uniform sampler3D volume;
uniform sampler1D transfer;
uniform sampler2D front;
uniform sampler2D back;
uniform float dz;
uniform int maxrange;
uniform vec3 texCoordSteps;
uniform mat4 modelView;

void main()
{
	// Code nach VisLU-Tutorial (http://www.cg.tuwien.ac.at/~ilcik/VolVisOpenGL2008.pdf)

	vec4 entry_point = texture2D(front, vec2(gl_TexCoord[0]));
	vec4 exit_point = texture2D(back, vec2(gl_TexCoord[0]));
	
	float dist = distance(entry_point, exit_point)/dz;
	int maxiter = int(floor(dist));

	// exit - entry => front-to-back 
	vec3 diff = (exit_point.xyz - entry_point.xyz)/dist;

	if (entry_point.w == 0.0 || maxiter==0)
		discard;
	else
	{
		vec3 point = entry_point.xyz;
		vec4 intensity = texture3D(volume, point);
		vec4 transferred = texture1D(transfer, intensity.x);

		vec4 Result;
		Result.xyz = transferred.w * transferred.xyz;
		Result.w = transferred.w;

		for(int i = 0; i < maxrange; i++)
		{
			intensity = texture3D(volume, point);
			transferred = texture1D(transfer, intensity.x);			
			
			Result.xyz += transferred.w * transferred.xyz;
			Result.w += transferred.w;
			point +=diff;

			if (i >= maxiter) 
			{
				Result /= float(maxiter);
				break;
			}
		} 

		gl_FragColor = Result;
	}
}