#ifndef TIMECHANNEL_H
#define TIMECHANNEL_H

#include "FlowChannel.h"

#include <vector>

using namespace std;

//maximum nuber of channels. For VisLU data sets we have only 5 anyways
#define max_channels 16

class TimeChannel
{
	friend class FlowData;

 public:
	TimeChannel(FlowGeometry* g);
	~TimeChannel();

	int createChannel();
	void deleteChannel(int i);

	int createChannelGeometry(int dimension);

	int createChannelVectorLength(FlowChannel* chX, FlowChannel* chY, FlowChannel* chZ = 0);
	int createChannelVectorLength(int chX, int chY, int chZ);

	///returns a pointer to the instance of channel at given adress. This is the only way to access the channels storage (at line 28)
	FlowChannel* getChannel(int i) { return this->channels[i]; };

 private:
	FlowGeometry* geometry;

	///is the channel slot free?
	bool freeChannel[max_channels];    
	///stores the values of data channels for one time step. For time-dependent data, the best solution is to create a separate class handling channels in one timestep and to instanciate this class for all timesteps.
	FlowChannel* channels[max_channels];
};

#endif
