#include "TimeChannel.h"

TimeChannel::TimeChannel(FlowGeometry* geom)
{
	this->geometry = geom;

	//mark all the channel slots as free
	for(int i = 0; i < max_channels; i++) {
		this->channels[i] = NULL;
		this->freeChannel[i] = true;
	}
}

TimeChannel::~TimeChannel()
{
	//delete all the channels
	for(int i = 0; i < max_channels; i++) {
		if (!this->freeChannel[i])
			this->deleteChannel(i);
	}
}

int TimeChannel::createChannel()
{
    //find the first unused channel slot
	int i = 0;
	while ((!this->freeChannel[i]) && (i < max_channels)) i++;

	//if there is a free slot
	if (i < max_channels) {
		//cout << "Creating channel at " << i << " ... ";
		//create a new channel
		this->channels[i] = new FlowChannel(this->geometry);
		//remember the slot
		this->freeChannel[i] = false;
		//return the adress of the new channel
		return i;

	} else {
		return -1;
		std::cerr << "There is no free channel slot!" << std::endl;
	}
}

void TimeChannel::deleteChannel(int i)
{
	//if the address is really occupied
	if (!this->freeChannel[i]) {
		//std::cout << "Deleting channel at " << i << " ... ";
		//delete the channel instance
		delete this->channels[i];
		this->channels[i] = NULL;
		//free the slot
		this->freeChannel[i] = true;

	} else {
		std::cout << "Tried to delete a non-existing channel at " << i << "." << std::endl;
	}
}

int TimeChannel::createChannelVectorLength(FlowChannel* chX, FlowChannel* chY, FlowChannel* chZ)
{
	int result = this->createChannel();

	//check whether we deal with 2D or 3D vectors
	if (chZ) {
		for (int i = 0; i < this->geometry->getDimX() * this->geometry->getDimY(); i++)
			this->channels[result]->setValue(i,sqrt(chX->getValue(i)*chX->getValue(i) + chY->getValue(i)*chY->getValue(i) + chZ->getValue(i)*chZ->getValue(i)));
	} else {
		for (int i = 0; i < this->geometry->getDimX() * this->geometry->getDimY(); i++)
			this->channels[result]->setValue(i,sqrt(chX->getValue(i)*chX->getValue(i) + chY->getValue(i)*chY->getValue(i)));
	}

	return result;
}

int TimeChannel::createChannelVectorLength(int chX, int chY, int chZ)
{
	//just a wrapper for the method above
	if (chZ >= 0)
		return this->createChannelVectorLength(this->getChannel(chX), this->getChannel(chY), this->getChannel(chZ));

	return this->createChannelVectorLength(this->getChannel(chX), this->getChannel(chY));
}

int TimeChannel::createChannelGeometry(int dimension)
{
	int result = this->createChannel();
	//just take the dimension as if it was an offset to the geometryData array
	channels[result]->copyValues((float*) this->geometry->geometryData, 3, dimension);
	return result;
}
