#ifndef STREAMLINEGRID_H
#define STREAMLINEGRID_H

#include "Streamline.h"

#include <vector>
#include "vec3.h"

using namespace std;

class StreamlineGrid
{
	friend class StreamLine;

 public:
	StreamlineGrid(int, int, int);
	~StreamlineGrid();

	StreamLine* getNextLine();

	void addStreamLine(StreamLine*);

	void clear();

	void changeDTest(float);
	void changeDSep(int);

	float getDTest() { return this->dTest; };
	int getDSep() { return this->dSep; };

 private:
	int dSep;
	float dTest;

	float maxDistanceCheck;

	int dimX;
	int dimY;

	int cellsX;
	int cellsY;
	
	vector<vector<vec3>*> cells;
	vector<StreamLine*> streamLines;

	bool checkDistances(const vec3, float);
	void addSample(const vec3);
};

#endif
