#include "StreamlineGrid.h"

StreamlineGrid::StreamlineGrid(int dimX, int dimY, int dSep)
{
	this->dSep = 20;

	this->dimX = dimX;
	this->dimY = dimY;

	this->dTest = 0.5;

	this->changeDSep(dSep);
}

StreamlineGrid::~StreamlineGrid()
{
	this->clear();
}

StreamLine* StreamlineGrid::getNextLine()
{
	if (this->streamLines.size() == 0) {
		vec3 seed(this->dimX / 2, this->dimY / 2);
		return new StreamLine(this, seed);
	}

	for (int i = this->streamLines.size() - 1; i >= 0; i--) {
		vec3 seed;
		StreamLine* line = this->streamLines[i];

		if (line->getNextSeed(&seed))
			return new StreamLine(this, seed);
	}

	return 0;
}

void StreamlineGrid::addStreamLine(StreamLine* line)
{
	line->finalize();
	this->streamLines.push_back(line);
}

void StreamlineGrid::clear()
{
	for (unsigned int i = 0; i < this->streamLines.size() ; i++)
		delete this->streamLines[i];

	this->streamLines.clear();

	int cellCount = this->cellsX * this->cellsY;
	for (int i = 0; i < cellCount; i++)
		this->cells[i]->clear();
}

void StreamlineGrid::changeDTest(float dTest)
{
	if (dTest > 1.0)
		return;

	this->dTest = dTest;
}

void StreamlineGrid::changeDSep(int dSep)
{
	this->dSep = dSep;
	this->maxDistanceCheck = 2 * (sqrt(2 * (this->dSep * this->dSep)));

	this->cellsX = (float) this->dimX / (float) this->dSep;
	this->cellsY = (float) this->dimY / (float) this->dSep;

	if (this->dimX % this->dSep != 0)
		this->cellsX++;
	if (this->dimY % this->dSep != 0)
		this->cellsY++;

	for (unsigned int i = 0; i < this->cells.size(); i++)
		delete this->cells[i];

	int cellCount = this->cellsX * this->cellsY;
	for (int i = 0; i < cellCount; i++)
		this->cells.push_back(new vector<vec3>());
}

void StreamlineGrid::addSample(const vec3 pos)
{
	int cellIndexX = (float) pos.v[0] / (float) this->dSep;
	int cellIndexY = (float) pos.v[1] / (float) this->dSep;
	int cellIndex = cellIndexY * this->cellsY + cellIndexX;

	this->cells[cellIndex]->push_back(pos);
}

bool StreamlineGrid::checkDistances(const vec3 pos, float distance)
{
	if (pos.v[0] < 0 || pos.v[1] < 0)
		return false;
	if (pos.v[0] > this->dimX || pos.v[1] > this->dimY)
		return false;

	int centerCellIndexX = (float) pos.v[0] / (float) this->dSep;
	int centerCellIndexY = (float) pos.v[1] / (float) this->dSep;

/*
	cout << "======== StreamlineGrid::checkDistances =========== " << endl;
	cout << "for position ";
	pos.print();
	cout << "located its cell at (" << centerCellIndexX << "/" << centerCellIndexY << ")" << endl;
*/

	// check all 9 cells (including the center) if all samplepoints within have more distance to pos then dSep
	for (int cellY = centerCellIndexY - 1; cellY <= centerCellIndexY + 1; cellY++) {
		for (int cellX = centerCellIndexX - 1; cellX <= centerCellIndexX + 1; cellX++) {
			if (cellY < 0 || cellX < 0)
				continue;
			if (cellY >= this->cellsY || cellX >= this->cellsX)
				continue;

			int cellIndex = cellY * this->cellsY + cellX;

			vector<vec3>* cell = this->cells[cellIndex];
//			cout << "sourrounding cell at (" << cellX << "/" << cellY << ") contains " << cell->size() << " samples" << endl;
			for (unsigned int i = 0; i < cell->size(); i++) {
				float dist = cell->at(i).dist(pos);

/*
				cout << "sample inside cell ";
				cell->at(i).print();
				cout << "has dist = " << dist << endl;
*/
				if (dist >  this->maxDistanceCheck)
					cout << "WARNING: bad error!" << endl;

				if (dist < distance) {
//					cout << "bad distance: " << dist << endl;
					return false;
				}
			}
		}
	}

// //	cout << "all distances clear" << endl;

	return true;
}
