#ifndef STREAMLINE_H
#define STREAMLINE_H

#include "vec3.h"
#include <vector>
#include <list>

using namespace std;

class StreamlineGrid;

class StreamLine
{
 public:
	StreamLine(StreamlineGrid*, const vec3&);
	~StreamLine();

	vec3& getStartSample() { return this->startSample; };

	bool getNextSeed(vec3*);

	bool addSample(const vec3);

	void finalize();

 private:
	vec3 startSample;
	StreamlineGrid* grid;

	vector<vec3> samples;
	list<vec3> potentialSeeds;
};

#endif
