#include "Streamline.h"

#include "StreamlineGrid.h"

#define IGNORE_LAST_SAMPLES 5

StreamLine::StreamLine(StreamlineGrid* grid, const vec3& startSample)
{
	this->startSample = startSample;
	this->grid = grid;
}

StreamLine::~StreamLine()
{
}

bool StreamLine::getNextSeed(vec3* seed)
{
	list<vec3>::iterator iter = this->potentialSeeds.begin();
	while (iter != this->potentialSeeds.end()) {
		vec3& potentialSeed = *iter;
		
		this->potentialSeeds.erase(iter);
		iter = this->potentialSeeds.begin();

		if (this->grid->checkDistances(potentialSeed, this->grid->getDSep())) {
			*seed = potentialSeed;
			return true;
		}
	}

	return false;
}

bool StreamLine::addSample(const vec3 sample)
{
	float dist = this->grid->getDSep() * this->grid->getDTest();
	if (this->grid->checkDistances(sample, dist) == false)
		return false;

	if (this->samples.size() >= 2) {
		const vec3& pointA = this->samples[this->samples.size() - 2];
		const vec3& pointB = this->samples[this->samples.size() - 1];

		vec3 vecAB(pointA.v[0] - pointB.v[0], pointA.v[1] - pointB.v[1]);
		vec3 vecBS(sample.v[0] - pointB.v[0], sample.v[1] - pointB.v[1]);

		vecAB.normalize();
		vecBS.normalize();

		float angle = vecAB.dot(vecBS);
		if (angle < 0)
			angle *= -1;

		if (angle < 0.1)
			return false;
	}

	if (this->samples.size() >= IGNORE_LAST_SAMPLES)
		this->grid->addSample(this->samples[this->samples.size() - IGNORE_LAST_SAMPLES]);

	if (this->samples.size() >= 1) {
		const vec3& prevPoint = this->samples[this->samples.size() - 1];

		// to create a normal just flip x and y and negate the first param
		vec3 normalLeft(-(sample.v[1] - prevPoint.v[1]), sample.v[0] - prevPoint.v[0]);
		vec3 normalRight(sample.v[1] - prevPoint.v[1], -(sample.v[0] - prevPoint.v[0]));

		normalLeft.normalize();
		normalRight.normalize();

		vec3 newSeedLeft = sample + (normalLeft * this->grid->getDSep());
		vec3 newSeedRight = sample + (normalRight * this->grid->getDSep());

		this->potentialSeeds.push_back(newSeedLeft);
		this->potentialSeeds.push_back(newSeedRight);
	}

	// all samplepoints within the 9 cells are farther arway then dSep => insert it in the according streamline and centerCell
	
	this->samples.push_back(sample);

	return true;
}

void StreamLine::finalize()
{
	
	if (this->samples.size() < IGNORE_LAST_SAMPLES)
		return;

	for (unsigned int i = this->samples.size() - IGNORE_LAST_SAMPLES + 1; i < this->samples.size(); i++)
		this->grid->addSample(this->samples[i]);
}
