#ifndef FLOATDATA_H
#define FLOATDATA_H

#include "FlowGeometry.h"
#include "FlowChannel.h"
#include "TimeChannel.h"

#include <stdio.h>
#include <iostream>
#include <string>
#include <vector>

using namespace std;

///class managing the data sets and related stuff like data loading, channels creation etc.
class FlowData
{
 private:
	///Is there any data loaded?
	bool loaded;

	/// number of channels (by thj)
	int numChannels;

	///Number of timesteps
	int timesteps;

	///Stores the underlying geometry
	FlowGeometry geometry;

	vector<TimeChannel*> timeChannels;

	bool loadTimestep(string filename, int i, bool bigEndian);

public:
	///initializes the channel storage
	FlowData();
	///destoys all created channels
	~FlowData();

	FlowGeometry& getGeometry() { return this->geometry; };

	/// returns the number of channels in this Dataset (by thj)
	int getChannelsNum() { return this->numChannels; };

	/// returns dimension of geometry in x-achsis (by thj)
	int getDimX() { return this->geometry.getDimX(); };
	/// returns dimension of geometry in y-achsis (by thj)
	int getDimY() { return this->geometry.getDimY(); };

	///Loads a dataset, returns true if everything successful. You have to specify the byte order used in the data
	bool loadDataset(string filename, bool bigEndian);

	///Returns the number of timesteps
	int getNumTimesteps() { return this->timesteps; };

	TimeChannel* getTimeChannel(int i) { return this->timeChannels[i]; };
};
#endif
