#ifndef SHADEWIDGET_H
#define SHADEWIDGET_H

#include <QPainter>

#include "Hoverpoints.h"
#include "../renderer/Renderer.h"

/**
* @class ShadeWidget implements a simple transferfunction editor
*/
 class ShadeWidget : public QWidget
 {
     Q_OBJECT
 public:
    
     ShadeWidget(QWidget *parent);

     void setGradientStops(const QGradientStops &stops);

     //! @brief sets the points of the transferfunction
     void set_shade_points(const QVector<TFPnt> &points);

    //! @brief sets the related transferfunction (updated if the points in the widget have changed)
     void set_transferfunction(Renderer::TransferFunction& tf);
    
    //! @brief sets the points changed in the transferfunction
     void set_transferfunction(const QVector<TFPnt> &points);

     void paintEvent(QPaintEvent *e);

     QSize sizeHint() const { return QSize(180, 390); }
     QVector<TFPnt> points() const;

     HoverPoints *hoverPoints() const { return m_hoverPoints; }

     uint colorAt(int x);

 public slots:
    //! @brief updates the gradient in the background
    void setGradientStops(QVector<TFPnt> points);

 private:
     void generateShade();

    QWidget *m_widget;

     Renderer::TransferFunction* m_transferFunction;
     QImage m_shade;
     HoverPoints *m_hoverPoints;
     QLinearGradient m_alpha_gradient;
 }; 

#endif
