#include "Shadewidget.h"

#include "../FlowVis.h"

using namespace std;

ShadeWidget::ShadeWidget(QWidget *parent)
     : QWidget(parent), m_alpha_gradient(QLinearGradient(0, 0, 0, 0))
 {
      m_widget = parent;

     // Checkers background

         QPixmap pm(20, 20);
         QPainter pmp(&pm);
         pmp.fillRect(0, 0, 10, 10, Qt::lightGray);
         pmp.fillRect(10, 10, 10, 10, Qt::lightGray);
         pmp.fillRect(0, 10, 10, 10, Qt::darkGray);
         pmp.fillRect(10, 0, 10, 10, Qt::darkGray);
         pmp.end();
         QPalette pal = palette();
         pal.setBrush(backgroundRole(), QBrush(pm));
         setAutoFillBackground(true);
         setPalette(pal);


     //QPolygonF points;

     setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Fixed);

     //std::cout << this->rect().height() << " | " << this->rect().width() << std::endl;

     //points << QPointF(0, this->rect().height()) << QPointF((int) ( this->rect().width() / 2),(int) ( this->rect().height() / 2)) << QPointF( this->rect().width(),0);

     m_hoverPoints = new HoverPoints(this, HoverPoints::CircleShape);
     m_hoverPoints->setSortType(HoverPoints::YSort);
     //m_hoverPoints->setPoints(points);
     //m_hoverPoints->setPointLock(0, HoverPoints::LockToTop);
     //m_hoverPoints->setPointLock(2, HoverPoints::LockToBottom);
     
     //connect(this, SIGNAL(update()), parent, SIGNAL(saveTransferFunctions("tf.xml")));
     //connect(m_hoverPoints, SIGNAL(pointsChanged(const QVector<TFPnt> &)), this, SIGNAL(setGradientStops(const QVector<TFPnt> &)));
     //connect(m_hoverPoints, SIGNAL(pointsChanged(const QVector<TFPnt> &)), parent, SIGNAL(saveTransferFunctions("tf.xml")));
 }

 QVector<TFPnt> ShadeWidget::points() const
 {
     return m_hoverPoints->points();
 }

 uint ShadeWidget::colorAt(int x)
 {
     generateShade();

     QVector<TFPnt> pts = m_hoverPoints->points();
     for (int i=1; i < pts.size(); ++i) {
         if (pts.at(i-1).pos.x() <= x && pts.at(i).pos.x() >= x) {
             QLineF l(pts.at(i-1).pos, pts.at(i).pos);
             l.setLength(l.length() * ((x - l.x1()) / l.dx()));
             return m_shade.pixel(qRound(qMin(l.x2(), (qreal(m_shade.width() - 1)))),
                                  qRound(qMin(l.y2(), qreal(m_shade.height() - 1))));
         }
     }
     return 0;
 }

void ShadeWidget::setGradientStops(const QVector<TFPnt> points)
{
    QGradientStops stops;
    
    for(int i=0; i < points.size(); i++)
    {
	stops << QGradientStop((float) points.at(i).pos.y() / height(), points.at(i).col);
    }
    setGradientStops(stops);

    set_transferfunction(points);

    ((Controls*) m_widget)->saveTransferFunctions("tf.xml");
}

 void ShadeWidget::setGradientStops(const QGradientStops &stops)
 {
         m_alpha_gradient = QLinearGradient(0, 0, 0, height());

         for (int i=0; i<stops.size(); ++i) {
             QColor c = stops.at(i).second;
             m_alpha_gradient.setColorAt(stops.at(i).first, QColor(c.red(), c.green(), c.blue()));
         }

         m_shade = QImage();
         generateShade();
         update();
 }

 void ShadeWidget::paintEvent(QPaintEvent *)
 {
     generateShade();

     QPainter p(this);
     p.drawImage(0, 0, m_shade);

     p.setPen(QColor(146, 146, 146));
     p.drawRect(0, 0, width() - 1, height() - 1);

     if (this->m_transferFunction->histo != (int*) 0)
     for(int i = 0; i < 128; i++)
     {
      p.drawRect(0, height() / 128 * i, this->m_transferFunction->histo[i] * width() / *(this->m_transferFunction->maxHist) , 1);
     }
 }

 void ShadeWidget::generateShade()
 {
     if (m_shade.isNull() || m_shade.size() != size()) {

             m_shade = QImage(size(), QImage::Format_ARGB32_Premultiplied);
             m_shade.fill(0);

             QPainter p(&m_shade);
             p.fillRect(rect(), m_alpha_gradient);
             p.setCompositionMode(QPainter::CompositionMode_SourceIn);
             QLinearGradient fade(0, 0, 0, height());
     }

 }

 void ShadeWidget::set_shade_points(const QVector<TFPnt> &points)
 {
     this->hoverPoints()->setPoints(points);
     //std::cout << points.size() << std::endl;
     this->hoverPoints()->setPointLock(0, HoverPoints::LockToTop);
     this->hoverPoints()->setPointLock(points.size() - 1, HoverPoints::LockToBottom);
     this->update();
 }

void ShadeWidget::set_transferfunction(Renderer::TransferFunction& tf)
{
      this->m_transferFunction = &tf;

      QVector<TFPnt> points;
      QGradientStops stops;

      //std::cout << (tf->points.at(0).a * this->rect().width() / 256) << " || " << (tf->points.at(0).pos) << std::endl;
     for(uint i = 0; i < tf.points.size(); i++) {
	cout << "tf.points[" << i << "].pos = " << tf.points[i].pos << endl;

	stops << QGradientStop((float) tf.points[i].pos / tf.width, QColor(tf.points[i].r, tf.points[i].g, tf.points[i].b, tf.points[i].a));
	
	TFPnt p;
	p.pos = QPointF(tf.points[i].a * this->rect().width() / 256, tf.points[i].pos * this->rect().height() / 4096);
	p.col = QColor(tf.points[i].r, tf.points[i].g, tf.points[i].b, tf.points[i].a);
	points << p;
      }

      setGradientStops(stops);
      set_shade_points(points);
}

void ShadeWidget::set_transferfunction(const QVector<TFPnt> &points)
{
   this->m_transferFunction->points.clear();

   for(int i=0; i<points.size(); i++)
   {
      Renderer::TFPoint tfPoint;
      tfPoint.r = points[i].col.red();
      tfPoint.g = points[i].col.green();
      tfPoint.b = points[i].col.blue();
      tfPoint.a = points[i].pos.x() / this->rect().width() * 256;
      cout << "ShadeWidget::set_transferfunction(points) : " << points[i].pos.y() << " , " << tfPoint.r << " , " << tfPoint.g << " , " << tfPoint.b << " , " << tfPoint.a << endl;
      tfPoint.pos = points[i].pos.y() / this->rect().height() * 4096;

      this->m_transferFunction->points.push_back(tfPoint);
    }
  
    FlowVis::getRenderer().setTransferFunction(*this->m_transferFunction);
}
 